/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmStoragePolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the storage policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#description VmStoragePolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#id VmStoragePolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the storage policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#name VmStoragePolicy#name}
    */
    readonly name: string;
    /**
    * tag_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#tag_rules VmStoragePolicy#tag_rules}
    */
    readonly tagRules: VmStoragePolicyTagRules[] | cdktf.IResolvable;
}
export interface VmStoragePolicyTagRules {
    /**
    * Whether to include or exclude datastores tagged with the provided tags
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#include_datastores_with_tags VmStoragePolicy#include_datastores_with_tags}
    */
    readonly includeDatastoresWithTags?: boolean | cdktf.IResolvable;
    /**
    * The tag category to select the tags from.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#tag_category VmStoragePolicy#tag_category}
    */
    readonly tagCategory: string;
    /**
    * The tags to use for creating a tag-based vm placement rule.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#tags VmStoragePolicy#tags}
    */
    readonly tags: string[];
}
export declare function vmStoragePolicyTagRulesToTerraform(struct?: VmStoragePolicyTagRules | cdktf.IResolvable): any;
export declare function vmStoragePolicyTagRulesToHclTerraform(struct?: VmStoragePolicyTagRules | cdktf.IResolvable): any;
export declare class VmStoragePolicyTagRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmStoragePolicyTagRules | cdktf.IResolvable | undefined;
    set internalValue(value: VmStoragePolicyTagRules | cdktf.IResolvable | undefined);
    private _includeDatastoresWithTags?;
    get includeDatastoresWithTags(): boolean | cdktf.IResolvable;
    set includeDatastoresWithTags(value: boolean | cdktf.IResolvable);
    resetIncludeDatastoresWithTags(): void;
    get includeDatastoresWithTagsInput(): boolean | cdktf.IResolvable | undefined;
    private _tagCategory?;
    get tagCategory(): string;
    set tagCategory(value: string);
    get tagCategoryInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    get tagsInput(): string[] | undefined;
}
export declare class VmStoragePolicyTagRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VmStoragePolicyTagRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmStoragePolicyTagRulesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy vsphere_vm_storage_policy}
*/
export declare class VmStoragePolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_vm_storage_policy";
    /**
    * Generates CDKTF code for importing a VmStoragePolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VmStoragePolicy to import
    * @param importFromId The id of the existing VmStoragePolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VmStoragePolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vm_storage_policy vsphere_vm_storage_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmStoragePolicyConfig
    */
    constructor(scope: Construct, id: string, config: VmStoragePolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tagRules;
    get tagRules(): VmStoragePolicyTagRulesList;
    putTagRules(value: VmStoragePolicyTagRules[] | cdktf.IResolvable): void;
    get tagRulesInput(): cdktf.IResolvable | VmStoragePolicyTagRules[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
