/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmfsDatastoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of custom attributes to set on this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#custom_attributes VmfsDatastore#custom_attributes}
    */
    readonly customAttributes?: {
        [key: string]: string;
    };
    /**
    * The managed object ID of the datastore cluster to place the datastore in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#datastore_cluster_id VmfsDatastore#datastore_cluster_id}
    */
    readonly datastoreClusterId?: string;
    /**
    * The disks to add to the datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#disks VmfsDatastore#disks}
    */
    readonly disks: string[];
    /**
    * The path to the datastore folder to put the datastore in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#folder VmfsDatastore#folder}
    */
    readonly folder?: string;
    /**
    * The managed object ID of the host to set up the datastore on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#host_system_id VmfsDatastore#host_system_id}
    */
    readonly hostSystemId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#id VmfsDatastore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the datastore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#name VmfsDatastore#name}
    */
    readonly name: string;
    /**
    * A list of tag IDs to apply to this object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#tags VmfsDatastore#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore vsphere_vmfs_datastore}
*/
export declare class VmfsDatastore extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_vmfs_datastore";
    /**
    * Generates CDKTF code for importing a VmfsDatastore resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VmfsDatastore to import
    * @param importFromId The id of the existing VmfsDatastore that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VmfsDatastore to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vmfs_datastore vsphere_vmfs_datastore} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmfsDatastoreConfig
    */
    constructor(scope: Construct, id: string, config: VmfsDatastoreConfig);
    get accessible(): cdktf.IResolvable;
    get capacity(): number;
    private _customAttributes?;
    get customAttributes(): {
        [key: string]: string;
    };
    set customAttributes(value: {
        [key: string]: string;
    });
    resetCustomAttributes(): void;
    get customAttributesInput(): {
        [key: string]: string;
    } | undefined;
    private _datastoreClusterId?;
    get datastoreClusterId(): string;
    set datastoreClusterId(value: string);
    resetDatastoreClusterId(): void;
    get datastoreClusterIdInput(): string | undefined;
    private _disks?;
    get disks(): string[];
    set disks(value: string[]);
    get disksInput(): string[] | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    get freeSpace(): number;
    private _hostSystemId?;
    get hostSystemId(): string;
    set hostSystemId(value: string);
    get hostSystemIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maintenanceMode(): string;
    get multipleHostAccess(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get uncommittedSpace(): number;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
