/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VnicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Key of the distributed portgroup the nic will connect to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#distributed_port_group Vnic#distributed_port_group}
    */
    readonly distributedPortGroup?: string;
    /**
    * UUID of the DVSwitch the nic will be attached to. Do not set if you set portgroup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#distributed_switch_port Vnic#distributed_switch_port}
    */
    readonly distributedSwitchPort?: string;
    /**
    * ESX host the interface belongs to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#host Vnic#host}
    */
    readonly host: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#id Vnic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * MAC address of the interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#mac Vnic#mac}
    */
    readonly mac?: string;
    /**
    * MTU of the interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#mtu Vnic#mtu}
    */
    readonly mtu?: number;
    /**
    * TCP/IP stack setting for this interface. Possible values are 'defaultTcpipStack', 'vmotion', 'provisioning'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#netstack Vnic#netstack}
    */
    readonly netstack?: string;
    /**
    * portgroup to attach the nic to. Do not set if you set distributed_switch_port.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#portgroup Vnic#portgroup}
    */
    readonly portgroup?: string;
    /**
    * Enabled services setting for this interface. Current possible values are 'vmotion', 'management' and 'vsan'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#services Vnic#services}
    */
    readonly services?: string[];
    /**
    * ipv4 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#ipv4 Vnic#ipv4}
    */
    readonly ipv4?: VnicIpv4;
    /**
    * ipv6 block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#ipv6 Vnic#ipv6}
    */
    readonly ipv6?: VnicIpv6;
}
export interface VnicIpv4 {
    /**
    * Use DHCP to configure the interface's IPv4 stack.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#dhcp Vnic#dhcp}
    */
    readonly dhcp?: boolean | cdktf.IResolvable;
    /**
    * IP address of the default gateway, if DHCP is not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#gw Vnic#gw}
    */
    readonly gw?: string;
    /**
    * address of the interface, if DHCP is not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#ip Vnic#ip}
    */
    readonly ip?: string;
    /**
    * netmask of the interface, if DHCP is not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#netmask Vnic#netmask}
    */
    readonly netmask?: string;
}
export declare function vnicIpv4ToTerraform(struct?: VnicIpv4OutputReference | VnicIpv4): any;
export declare function vnicIpv4ToHclTerraform(struct?: VnicIpv4OutputReference | VnicIpv4): any;
export declare class VnicIpv4OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VnicIpv4 | undefined;
    set internalValue(value: VnicIpv4 | undefined);
    private _dhcp?;
    get dhcp(): boolean | cdktf.IResolvable;
    set dhcp(value: boolean | cdktf.IResolvable);
    resetDhcp(): void;
    get dhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _gw?;
    get gw(): string;
    set gw(value: string);
    resetGw(): void;
    get gwInput(): string | undefined;
    private _ip?;
    get ip(): string;
    set ip(value: string);
    resetIp(): void;
    get ipInput(): string | undefined;
    private _netmask?;
    get netmask(): string;
    set netmask(value: string);
    resetNetmask(): void;
    get netmaskInput(): string | undefined;
}
export interface VnicIpv6 {
    /**
    * List of IPv6 addresses
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#addresses Vnic#addresses}
    */
    readonly addresses?: string[];
    /**
    * Use IPv6 Autoconfiguration (RFC2462).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#autoconfig Vnic#autoconfig}
    */
    readonly autoconfig?: boolean | cdktf.IResolvable;
    /**
    * Use DHCP to configure the interface's IPv4 stack.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#dhcp Vnic#dhcp}
    */
    readonly dhcp?: boolean | cdktf.IResolvable;
    /**
    * IP address of the default gateway, if DHCP or autoconfig is not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#gw Vnic#gw}
    */
    readonly gw?: string;
}
export declare function vnicIpv6ToTerraform(struct?: VnicIpv6OutputReference | VnicIpv6): any;
export declare function vnicIpv6ToHclTerraform(struct?: VnicIpv6OutputReference | VnicIpv6): any;
export declare class VnicIpv6OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VnicIpv6 | undefined;
    set internalValue(value: VnicIpv6 | undefined);
    private _addresses?;
    get addresses(): string[];
    set addresses(value: string[]);
    resetAddresses(): void;
    get addressesInput(): string[] | undefined;
    private _autoconfig?;
    get autoconfig(): boolean | cdktf.IResolvable;
    set autoconfig(value: boolean | cdktf.IResolvable);
    resetAutoconfig(): void;
    get autoconfigInput(): boolean | cdktf.IResolvable | undefined;
    private _dhcp?;
    get dhcp(): boolean | cdktf.IResolvable;
    set dhcp(value: boolean | cdktf.IResolvable);
    resetDhcp(): void;
    get dhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _gw?;
    get gw(): string;
    set gw(value: string);
    resetGw(): void;
    get gwInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic vsphere_vnic}
*/
export declare class Vnic extends cdktf.TerraformResource {
    static readonly tfResourceType = "vsphere_vnic";
    /**
    * Generates CDKTF code for importing a Vnic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Vnic to import
    * @param importFromId The id of the existing Vnic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Vnic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/vsphere/2.10.0/docs/resources/vnic vsphere_vnic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VnicConfig
    */
    constructor(scope: Construct, id: string, config: VnicConfig);
    private _distributedPortGroup?;
    get distributedPortGroup(): string;
    set distributedPortGroup(value: string);
    resetDistributedPortGroup(): void;
    get distributedPortGroupInput(): string | undefined;
    private _distributedSwitchPort?;
    get distributedSwitchPort(): string;
    set distributedSwitchPort(value: string);
    resetDistributedSwitchPort(): void;
    get distributedSwitchPortInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mac?;
    get mac(): string;
    set mac(value: string);
    resetMac(): void;
    get macInput(): string | undefined;
    private _mtu?;
    get mtu(): number;
    set mtu(value: number);
    resetMtu(): void;
    get mtuInput(): number | undefined;
    private _netstack?;
    get netstack(): string;
    set netstack(value: string);
    resetNetstack(): void;
    get netstackInput(): string | undefined;
    private _portgroup?;
    get portgroup(): string;
    set portgroup(value: string);
    resetPortgroup(): void;
    get portgroupInput(): string | undefined;
    private _services?;
    get services(): string[];
    set services(value: string[]);
    resetServices(): void;
    get servicesInput(): string[] | undefined;
    private _ipv4;
    get ipv4(): VnicIpv4OutputReference;
    putIpv4(value: VnicIpv4): void;
    resetIpv4(): void;
    get ipv4Input(): VnicIpv4 | undefined;
    private _ipv6;
    get ipv6(): VnicIpv6OutputReference;
    putIpv6(value: VnicIpv6): void;
    resetIpv6(): void;
    get ipv6Input(): VnicIpv6 | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
