/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.data_structure;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ThriftyList<T>
extends AbstractList<T>
implements List<T>,
Deque<T>,
Serializable,
Cloneable {
    private FixedListInternal<CircularListInternal<T>> sublists = new FixedListInternal(4);
    private int size;
    private int capacity;
    private int smallSublistCount;
    private int smallSublistSizeExp;
    private int largeSublistSizeExp;
    private int headSublistIndex;
    private int tailSublistIndex;
    private int freeCapacityHead;
    private int halveCapacityLimit;
    private int doubleCapacityLimit;

    public static <T, E extends ListInternal<T>> E copyTo(E source, E destination) {
        assert (destination.capacity() >= source.size());
        destination.addAll(source);
        return destination;
    }

    public static <T, E extends ListInternal<T>> E merge(E l1, E l2, E target) {
        assert (target.capacity() == l1.capacity() + l2.capacity());
        target.addAll(l1);
        target.addAll(l2);
        return target;
    }

    public static <T> void split(ListInternal<T> src, ListInternal<T> dst1, ListInternal<T> dst2, boolean alignRight) {
        assert (dst1.capacity() + dst2.capacity() == src.capacity());
        if (alignRight) {
            int splitIndex = src.size() - dst2.capacity();
            dst2.addSome(src, Math.max(0, splitIndex), Math.min(src.size(), dst2.capacity()));
            dst1.addSome(src, 0, splitIndex);
        } else {
            dst1.addSome(src, 0, Math.min(src.size(), dst1.capacity()));
            dst2.addSome(src, dst1.capacity(), src.size() - dst1.capacity());
        }
    }

    public ThriftyList() {
        this.sublists.addTail(new CircularListInternal(2));
        this.sublists.addTail(new CircularListInternal(4));
        this.sublists.addTail(new CircularListInternal(4));
        this.capacity = 10;
        this.smallSublistSizeExp = 1;
        this.largeSublistSizeExp = 2;
        this.halveCapacityLimit = 4;
        this.doubleCapacityLimit = 16;
        this.smallSublistCount = 1;
        this.size = 0;
        this.tailSublistIndex = 1;
        this.headSublistIndex = 1;
        this.freeCapacityHead = 6;
    }

    @Override
    public void add(int index, T item) {
        int largeListOffset;
        int sublistIndex;
        if (0 > index || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int projectedIndex = index + this.freeCapacityHead;
        int smallListCapacity = this.smallSublistCount << this.smallSublistSizeExp;
        int sublistOffset = projectedIndex < smallListCapacity ? ((sublistIndex = projectedIndex >>> this.smallSublistSizeExp) == this.headSublistIndex ? index : projectedIndex & (1 << this.smallSublistSizeExp) - 1) : ((sublistIndex = this.smallSublistCount + ((largeListOffset = projectedIndex - smallListCapacity) >>> this.largeSublistSizeExp)) == this.headSublistIndex ? index : largeListOffset & (1 << this.largeSublistSizeExp) - 1);
        this.addImpl(index, sublistIndex, sublistOffset, item);
    }

    @Override
    public boolean add(T item) {
        CircularListInternal<T> sublist = this.sublists.get(this.tailSublistIndex);
        if (sublist.isFull()) {
            if (this.tailSublistIndex != this.sublists.size() - 1 || this.growTail()) {
                ++this.tailSublistIndex;
            }
            sublist = this.sublists.get(this.tailSublistIndex);
        }
        sublist.addTail(item);
        if (this.tailSublistIndex == this.headSublistIndex) {
            --this.freeCapacityHead;
        }
        ++this.size;
        assert (this.checkListState(false, false));
        return true;
    }

    @Override
    public void addFirst(T item) {
        CircularListInternal<T> sublist = this.sublists.get(this.headSublistIndex);
        if (sublist.isFull()) {
            if (this.headSublistIndex == 0) {
                this.growHead();
            } else {
                --this.headSublistIndex;
            }
            sublist = this.sublists.get(this.headSublistIndex);
        }
        sublist.addHead(item);
        --this.freeCapacityHead;
        ++this.size;
        assert (this.checkListState(false, false));
    }

    protected void addImpl(int index, int sublistIndex, int sublistOffset, T item) {
        if (sublistIndex < this.headSublistIndex + (this.calculateSublistsUsed() >>> 1)) {
            if (index == 0) {
                this.addFirst(item);
            } else {
                CircularListInternal<T> prev = this.sublists.get(this.headSublistIndex);
                sublistOffset = sublistOffset == 0 ? this.sublists.get(--sublistIndex).size() - 1 : --sublistOffset;
                T carryItem = prev.removeHead();
                CircularListInternal<T> next = prev;
                for (int j = this.headSublistIndex + 1; j <= sublistIndex; ++j) {
                    next = this.sublists.get(j);
                    prev.addTail(next.removeHead());
                    prev = next;
                }
                next.add(sublistOffset, item);
                this.addFirst(carryItem);
            }
        } else if (index == this.size) {
            this.add(item);
        } else {
            CircularListInternal<T> prev = this.sublists.get(this.tailSublistIndex);
            T carryItem = prev.removeTail();
            CircularListInternal<T> next = prev;
            for (int j = this.tailSublistIndex - 1; j >= sublistIndex; --j) {
                next = this.sublists.get(j);
                prev.addHead(next.removeTail());
                prev = next;
            }
            next.add(sublistOffset, item);
            this.add(carryItem);
        }
    }

    @Override
    public void addLast(T item) {
        this.add(item);
    }

    protected int calculateFreeCapacityHead() {
        return this.headSublistIndex == 0 ? this.sublists.get(0).calculateFreeCapacity() : this.sublists.get(0).calculateFreeCapacity() + this.sublists.get(1).calculateFreeCapacity();
    }

    protected int calculateSublistsUsed() {
        return this.tailSublistIndex - this.headSublistIndex + 1;
    }

    protected void checkCapacity() {
        if (this.capacity >= this.doubleCapacityLimit) {
            assert (this.checkListState(false, true));
            ++this.largeSublistSizeExp;
            ++this.smallSublistSizeExp;
            this.halveCapacityLimit = this.doubleCapacityLimit;
            this.doubleCapacityLimit <<= 2;
            this.smallSublistCount = this.sublists.size();
        } else if (this.capacity < this.halveCapacityLimit) {
            assert (this.checkListState(true, false));
            --this.largeSublistSizeExp;
            --this.smallSublistSizeExp;
            this.doubleCapacityLimit = this.halveCapacityLimit;
            this.halveCapacityLimit >>>= 2;
            this.smallSublistCount = 0;
        }
    }

    private boolean checkListState(boolean checkAllSmall, boolean checkAllLarge) {
        if (checkAllLarge) {
            for (int j = 0; j < this.sublists.size(); ++j) {
                assert (this.sublists.get(j).capacity() == 1 << this.largeSublistSizeExp);
            }
        } else if (checkAllSmall) {
            for (int j = 0; j < this.sublists.size(); ++j) {
                assert (this.sublists.get(j).capacity() == 1 << this.smallSublistSizeExp);
            }
        } else {
            assert (this.headSublistIndex + 1 <= 2);
            assert (this.sublists.size() - this.tailSublistIndex <= 2);
            assert (this.sublists.size() >= this.sublists.capacity() >>> 2);
            assert (this.freeCapacityHead == this.calculateFreeCapacityHead());
            int localCapacity = 0;
            for (int j = 0; j < this.sublists.size(); ++j) {
                localCapacity += this.sublists.get(j).capacity();
                if (j < this.headSublistIndex || j > this.tailSublistIndex ? !$assertionsDisabled && !this.sublists.get(j).isEmpty() : this.size > 0 && (j == this.headSublistIndex || j == this.tailSublistIndex ? !$assertionsDisabled && this.sublists.get(j).isEmpty() : !$assertionsDisabled && this.sublists.get(j).calculateFreeCapacity() != 0)) {
                    throw new AssertionError();
                }
                if (j < this.smallSublistCount ? !$assertionsDisabled && this.sublists.get(j).capacity() != 1 << this.smallSublistSizeExp : !$assertionsDisabled && this.sublists.get(j).capacity() != 1 << this.largeSublistSizeExp) {
                    throw new AssertionError();
                }
            }
            assert (localCapacity == this.capacity);
        }
        return true;
    }

    @Override
    public void clear() {
        this.sublists = new FixedListInternal(4);
        this.sublists.addTail(new CircularListInternal(2));
        this.sublists.addTail(new CircularListInternal(4));
        this.sublists.addTail(new CircularListInternal(4));
        this.capacity = 10;
        this.smallSublistSizeExp = 1;
        this.largeSublistSizeExp = 2;
        this.halveCapacityLimit = 4;
        this.doubleCapacityLimit = 16;
        this.smallSublistCount = 1;
        this.size = 0;
        this.tailSublistIndex = 1;
        this.headSublistIndex = 1;
        this.freeCapacityHead = 6;
    }

    public Object clone() {
        try {
            ThriftyList result = (ThriftyList)super.clone();
            result.sublists = (FixedListInternal)this.sublists.clone();
            for (int j = 0; j < result.sublists.size(); ++j) {
                result.sublists.set(j, (CircularListInternal)result.sublists.get(j).clone());
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new ReverseIter(this.size - 1);
    }

    @Override
    public T element() {
        return this.getFirst();
    }

    @Override
    public T get(int index) {
        int largeListOffset;
        int sublistIndex;
        if (0 > index || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int projectedIndex = index + this.freeCapacityHead;
        int smallListCapacity = this.smallSublistCount << this.smallSublistSizeExp;
        int sublistOffset = projectedIndex < smallListCapacity ? ((sublistIndex = projectedIndex >>> this.smallSublistSizeExp) == this.headSublistIndex ? index : projectedIndex & (1 << this.smallSublistSizeExp) - 1) : ((sublistIndex = this.smallSublistCount + ((largeListOffset = projectedIndex - smallListCapacity) >>> this.largeSublistSizeExp)) == this.headSublistIndex ? index : largeListOffset & (1 << this.largeSublistSizeExp) - 1);
        return this.sublists.get(sublistIndex).get(sublistOffset);
    }

    @Override
    public T getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.sublists.get(this.headSublistIndex).getHead();
    }

    @Override
    public T getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.sublists.get(this.tailSublistIndex).getTail();
    }

    protected boolean growHead() {
        assert (this.sublists.getHead().isFull());
        this.mergeNextSmallSublists();
        this.checkCapacity();
        if (!this.sublists.getHead().isFull()) {
            return false;
        }
        if (this.sublists.isFull()) {
            this.sublists = ThriftyList.copyTo(this.sublists, new FixedListInternal(this.sublists.capacity() << 1));
        }
        int smallListSize = 1 << this.smallSublistSizeExp;
        this.sublists.addHead(new CircularListInternal(smallListSize));
        ++this.smallSublistCount;
        this.capacity += smallListSize;
        this.freeCapacityHead += smallListSize;
        ++this.tailSublistIndex;
        return true;
    }

    protected boolean growTail() {
        assert (this.sublists.getTail().isFull());
        this.mergeNextSmallSublists();
        this.checkCapacity();
        if (!this.sublists.getTail().isFull()) {
            return false;
        }
        if (this.sublists.isFull()) {
            this.sublists = ThriftyList.copyTo(this.sublists, new FixedListInternal(this.sublists.capacity() << 1));
        }
        int largeListSize = 1 << this.largeSublistSizeExp;
        this.sublists.addTail(new CircularListInternal(largeListSize));
        this.capacity += largeListSize;
        return true;
    }

    @Override
    public int indexOf(Object o) {
        int total = 0;
        for (int j = this.headSublistIndex; j <= this.tailSublistIndex; ++j) {
            CircularListInternal<T> next = this.sublists.get(j);
            int index = next.indexOf(o);
            if (index != -1) {
                return total + index;
            }
            total += next.size();
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter(0);
    }

    @Override
    public int lastIndexOf(Object o) {
        int total = 0;
        for (int j = this.tailSublistIndex; j >= this.headSublistIndex; --j) {
            CircularListInternal<T> next = this.sublists.get(j);
            total += next.size();
            int index = next.lastIndexOf(o);
            if (index == -1) continue;
            return this.size - total + index;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (0 > index || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return new Iter(index);
    }

    protected void mergeNextSmallSublists() {
        if (this.smallSublistCount >= 2) {
            CircularListInternal<T> small2 = this.sublists.remove(--this.smallSublistCount);
            CircularListInternal<T> small1 = this.sublists.get(--this.smallSublistCount);
            this.sublists.set(this.smallSublistCount, ThriftyList.merge(small1, small2, new CircularListInternal(small1.capacity() + small2.capacity())));
            if (this.sublists.size() <= this.sublists.capacity() >>> 2) {
                this.sublists = ThriftyList.copyTo(this.sublists, new FixedListInternal(this.sublists.capacity() >>> 1));
            }
            if (this.size > 0) {
                this.headSublistIndex = this.sublists.getHead().isEmpty() ? 1 : 0;
                this.tailSublistIndex = this.sublists.getTail().isEmpty() ? this.sublists.size() - 2 : this.sublists.size() - 1;
            } else {
                this.tailSublistIndex = 0;
                this.headSublistIndex = 0;
            }
            if (this.headSublistIndex == this.tailSublistIndex) {
                this.freeCapacityHead = this.calculateFreeCapacityHead();
            }
        } else if (this.smallSublistCount == 1) {
            CircularListInternal<T> small = this.sublists.get(--this.smallSublistCount);
            this.sublists.set(this.smallSublistCount, ThriftyList.copyTo(small, new CircularListInternal(small.capacity() << 1)));
            int smallSublistSize = 1 << this.smallSublistSizeExp;
            this.capacity += smallSublistSize;
            this.freeCapacityHead += smallSublistSize;
        }
    }

    @Override
    public boolean offer(T e) {
        return this.offerLast(e);
    }

    @Override
    public boolean offerFirst(T e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(T e) {
        this.add(e);
        return true;
    }

    @Override
    public T peek() {
        return this.peekFirst();
    }

    @Override
    public T peekFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.sublists.get(this.headSublistIndex).getHead();
    }

    @Override
    public T peekLast() {
        if (this.size == 0) {
            return null;
        }
        return this.sublists.get(this.tailSublistIndex).getTail();
    }

    @Override
    public T poll() {
        return this.pollFirst();
    }

    @Override
    public T pollFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public T pollLast() {
        if (this.size == 0) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public void push(T e) {
        this.addFirst(e);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.clear();
        int localSize = s.readInt();
        for (int j = 0; j < localSize; ++j) {
            this.add((T)s.readObject());
        }
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    @Override
    public T remove(int index) {
        int largeListOffset;
        int sublistIndex;
        if (0 > index || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int projectedIndex = index + this.freeCapacityHead;
        int smallListCapacity = this.smallSublistCount << this.smallSublistSizeExp;
        int sublistOffset = projectedIndex < smallListCapacity ? ((sublistIndex = projectedIndex >>> this.smallSublistSizeExp) == this.headSublistIndex ? index : projectedIndex & (1 << this.smallSublistSizeExp) - 1) : ((sublistIndex = this.smallSublistCount + ((largeListOffset = projectedIndex - smallListCapacity) >>> this.largeSublistSizeExp)) == this.headSublistIndex ? index : largeListOffset & (1 << this.largeSublistSizeExp) - 1);
        return this.removeImpl(sublistIndex, sublistOffset);
    }

    @Override
    public T removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.removeImpl(this.headSublistIndex, 0);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    protected T removeImpl(int sublistIndex, int sublistOffset) {
        T result;
        if (sublistIndex < this.headSublistIndex + (this.calculateSublistsUsed() >>> 1)) {
            CircularListInternal<T> prev = this.sublists.get(sublistIndex);
            result = prev.remove(sublistOffset);
            --this.size;
            for (int j = sublistIndex - 1; j >= this.headSublistIndex; --j) {
                CircularListInternal<T> next = this.sublists.get(j);
                prev.addHead(next.removeTail());
                prev = next;
            }
            ++this.freeCapacityHead;
            if (this.sublists.get(this.headSublistIndex).isEmpty()) {
                if (this.headSublistIndex < this.tailSublistIndex) {
                    ++this.headSublistIndex;
                    if (this.headSublistIndex == this.tailSublistIndex) {
                        this.freeCapacityHead += this.sublists.get(this.tailSublistIndex).calculateFreeCapacity();
                    }
                }
                this.shrinkHead();
            }
        } else {
            CircularListInternal<T> prev = this.sublists.get(sublistIndex);
            result = prev.remove(sublistOffset);
            --this.size;
            if (sublistIndex <= this.headSublistIndex) {
                ++this.freeCapacityHead;
            }
            for (int j = sublistIndex + 1; j <= this.tailSublistIndex; ++j) {
                CircularListInternal<T> next = this.sublists.get(j);
                prev.addTail(next.removeHead());
                prev = next;
            }
            if (this.sublists.get(this.tailSublistIndex).isEmpty()) {
                this.tailSublistIndex = Math.max(this.headSublistIndex, this.tailSublistIndex - 1);
                this.shrinkTail();
            }
        }
        assert (this.checkListState(false, false));
        return result;
    }

    @Override
    public T removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        CircularListInternal<T> sublist = this.sublists.get(this.tailSublistIndex);
        return this.removeImpl(this.tailSublistIndex, sublist.size() - 1);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        int index = this.lastIndexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public T set(int index, T item) {
        int largeListOffset;
        int sublistIndex;
        if (0 > index || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int projectedIndex = index + this.freeCapacityHead;
        int smallListCapacity = this.smallSublistCount << this.smallSublistSizeExp;
        int sublistOffset = projectedIndex < smallListCapacity ? ((sublistIndex = projectedIndex >>> this.smallSublistSizeExp) == this.headSublistIndex ? index : projectedIndex & (1 << this.smallSublistSizeExp) - 1) : ((sublistIndex = this.smallSublistCount + ((largeListOffset = projectedIndex - smallListCapacity) >>> this.largeSublistSizeExp)) == this.headSublistIndex ? index : largeListOffset & (1 << this.largeSublistSizeExp) - 1);
        return this.setImpl(sublistIndex, sublistOffset, item);
    }

    protected T setImpl(int sublistIndex, int sublistOffset, T item) {
        CircularListInternal<T> sublist = this.sublists.get(sublistIndex);
        return sublist.set(sublistOffset, item);
    }

    protected void shrinkHead() {
        while (this.headSublistIndex >= 2) {
            this.splitNextLargeSublist();
            CircularListInternal<T> head = this.sublists.removeHead();
            assert (head.isEmpty());
            if (this.sublists.size() <= this.sublists.capacity() >>> 2) {
                this.sublists = ThriftyList.copyTo(this.sublists, new FixedListInternal(this.sublists.capacity() >>> 1));
            }
            this.capacity -= head.capacity();
            this.headSublistIndex = Math.max(this.headSublistIndex - 1, 0);
            --this.tailSublistIndex;
            this.freeCapacityHead = this.calculateFreeCapacityHead();
            if (head.capacity() == 1 << this.smallSublistSizeExp) {
                --this.smallSublistCount;
            }
            this.checkCapacity();
            this.shrinkTail();
        }
    }

    protected void shrinkTail() {
        while (this.sublists.size() - this.tailSublistIndex > 2) {
            this.splitNextLargeSublist();
            CircularListInternal<T> tail = this.sublists.removeTail();
            assert (tail.isEmpty());
            if (this.sublists.size() <= this.sublists.capacity() >>> 2) {
                this.sublists = ThriftyList.copyTo(this.sublists, new FixedListInternal(this.sublists.capacity() >>> 1));
            }
            this.capacity -= tail.capacity();
            this.freeCapacityHead = this.calculateFreeCapacityHead();
            if (tail.capacity() == 1 << this.smallSublistSizeExp) {
                --this.smallSublistCount;
            }
            this.checkCapacity();
            this.shrinkHead();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void splitNextLargeSublist() {
        if (this.smallSublistCount < this.sublists.size()) {
            int firstLargeSublistIndex;
            if (this.sublists.isFull()) {
                this.sublists = ThriftyList.copyTo(this.sublists, new FixedListInternal(this.sublists.capacity() << 1));
            }
            boolean isHeadList = (firstLargeSublistIndex = this.smallSublistCount) <= this.headSublistIndex;
            boolean isTailList = firstLargeSublistIndex >= this.tailSublistIndex;
            CircularListInternal<T> large = this.sublists.get(firstLargeSublistIndex);
            assert (large.capacity() == 1 << this.largeSublistSizeExp);
            CircularListInternal small1 = new CircularListInternal(large.capacity() >>> 1);
            CircularListInternal small2 = new CircularListInternal(large.capacity() >>> 1);
            ThriftyList.split(large, small1, small2, isHeadList);
            if (isHeadList) {
                this.sublists.set(firstLargeSublistIndex, small2);
                this.sublists.add(firstLargeSublistIndex, small1);
                this.smallSublistCount += 2;
                if (small1.isEmpty()) {
                    ++this.headSublistIndex;
                }
                ++this.tailSublistIndex;
            } else if (isTailList) {
                this.sublists.set(firstLargeSublistIndex, small1);
                this.sublists.add(firstLargeSublistIndex + 1, small2);
                this.smallSublistCount += 2;
                if (!small2.isEmpty()) {
                    ++this.tailSublistIndex;
                }
            } else {
                this.sublists.set(firstLargeSublistIndex, small2);
                this.sublists.add(firstLargeSublistIndex, small1);
                this.smallSublistCount += 2;
                ++this.tailSublistIndex;
            }
        }
    }

    @Override
    public T[] toArray() {
        return this.toArray((U[])null);
    }

    @Override
    public <U> U[] toArray(U[] target) {
        if (target == null || target.length < this.size) {
            target = new Object[this.size];
        }
        int index = 0;
        for (int j = this.headSublistIndex; j <= this.tailSublistIndex; ++j) {
            CircularListInternal<U> sublist = this.sublists.get(j);
            sublist.fill(target, index, 0, sublist.size());
            index += sublist.size();
        }
        if (target.length > this.size) {
            target[this.size] = null;
        }
        return target;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int j = this.headSublistIndex; j <= this.tailSublistIndex; ++j) {
            builder.append(this.sublists.get(j).toString()).append(",");
        }
        builder.setCharAt(builder.length() - 1, ']');
        return builder.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size);
        for (T next : this) {
            s.writeObject(next);
        }
    }

    protected class ReverseIter
    extends IterBase {
        public ReverseIter(int index) {
            super(index);
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.index < ThriftyList.this.size - 1;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index + 1;
        }

        @Override
        protected void stepForward() {
            this.currentIndex = this.index--;
            this.currentSublistIndex = this.sublistIndex;
            this.currentSublistOffset = this.sublistOffset;
            if (this.sublistOffset == 0 && this.sublistIndex > 0) {
                --this.sublistIndex;
                this.sublistOffset = ((CircularListInternal)ThriftyList.this.sublists.get(this.sublistIndex)).size() - 1;
            } else {
                --this.sublistOffset;
            }
        }

        @Override
        protected void stepReverse() {
            ++this.index;
            ++this.sublistOffset;
            if (this.sublistOffset == ((CircularListInternal)ThriftyList.this.sublists.get(this.sublistIndex)).size() && this.sublistIndex < ThriftyList.this.sublists.size() - 1) {
                ++this.sublistIndex;
                this.sublistOffset = 0;
            }
            this.currentIndex = this.index;
            this.currentSublistIndex = this.sublistIndex;
            this.currentSublistOffset = this.sublistOffset;
        }
    }

    protected static interface ListInternal<T> {
        public void add(int var1, T var2);

        public void addAll(ListInternal<T> var1);

        public void addHead(T var1);

        public void addSome(ListInternal<T> var1, int var2, int var3);

        public void addTail(T var1);

        public int calculateFreeCapacity();

        public int capacity();

        public void clear();

        public void fill(T[] var1, int var2, int var3, int var4);

        public T get(int var1);

        public T getHead();

        public T getTail();

        public int indexOf(Object var1);

        public boolean isEmpty();

        public boolean isFull();

        public int lastIndexOf(Object var1);

        public T remove(int var1);

        public T removeHead();

        public T removeTail();

        public T set(int var1, T var2);

        public int size();
    }

    protected abstract class IterBase
    implements ListIterator<T> {
        protected int index;
        protected int sublistIndex;
        protected int sublistOffset;
        protected int currentIndex;
        protected int currentSublistIndex;
        protected int currentSublistOffset;

        public IterBase(int index) {
            this.index = index;
            this.currentIndex = -1;
            this.cursor();
        }

        @Override
        public void add(T item) {
            ThriftyList.this.addImpl(this.index, this.sublistIndex, this.sublistOffset, item);
            this.cursor();
            this.stepForward();
            this.currentIndex = -1;
        }

        protected void cursor() {
            int smallListCapacity;
            int projectedIndex = this.index + ThriftyList.this.freeCapacityHead;
            if (projectedIndex < (smallListCapacity = ThriftyList.this.smallSublistCount << ThriftyList.this.smallSublistSizeExp)) {
                this.sublistIndex = projectedIndex >>> ThriftyList.this.smallSublistSizeExp;
                this.sublistOffset = this.sublistIndex == ThriftyList.this.headSublistIndex ? this.index : projectedIndex & (1 << ThriftyList.this.smallSublistSizeExp) - 1;
            } else {
                int largeListOffset = projectedIndex - smallListCapacity;
                this.sublistIndex = ThriftyList.this.smallSublistCount + (largeListOffset >>> ThriftyList.this.largeSublistSizeExp);
                this.sublistOffset = this.sublistIndex == ThriftyList.this.headSublistIndex ? this.index : largeListOffset & (1 << ThriftyList.this.largeSublistSizeExp) - 1;
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = ((CircularListInternal)ThriftyList.this.sublists.get(this.sublistIndex)).get(this.sublistOffset);
            this.stepForward();
            return result;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.stepReverse();
            return ((CircularListInternal)ThriftyList.this.sublists.get(this.sublistIndex)).get(this.sublistOffset);
        }

        @Override
        public void remove() {
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            if (this.currentIndex < this.index) {
                this.stepReverse();
            }
            ThriftyList.this.removeImpl(this.currentSublistIndex, this.currentSublistOffset);
            this.cursor();
            this.currentIndex = -1;
        }

        @Override
        public void set(T e) {
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            ThriftyList.this.setImpl(this.currentSublistIndex, this.currentSublistOffset, e);
        }

        protected abstract void stepForward();

        protected abstract void stepReverse();
    }

    protected class Iter
    extends IterBase {
        public Iter(int index) {
            super(index);
        }

        @Override
        public boolean hasNext() {
            return this.index < ThriftyList.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        protected void stepForward() {
            this.currentIndex = this.index++;
            this.currentSublistIndex = this.sublistIndex;
            this.currentSublistOffset = this.sublistOffset++;
            if (this.sublistOffset == ((CircularListInternal)ThriftyList.this.sublists.get(this.sublistIndex)).size() && this.sublistIndex < ThriftyList.this.sublists.size() - 1) {
                ++this.sublistIndex;
                this.sublistOffset = 0;
            }
        }

        @Override
        protected void stepReverse() {
            --this.index;
            if (this.sublistOffset == 0 && this.sublistIndex > 0) {
                --this.sublistIndex;
                this.sublistOffset = ((CircularListInternal)ThriftyList.this.sublists.get(this.sublistIndex)).size() - 1;
            } else {
                --this.sublistOffset;
            }
            this.currentIndex = this.index;
            this.currentSublistIndex = this.sublistIndex;
            this.currentSublistOffset = this.sublistOffset;
        }
    }

    protected static class FixedListInternal<T>
    implements ListInternal<T>,
    Cloneable {
        protected Object[] array;
        protected int size;

        public FixedListInternal(int capacity) {
            assert ((capacity & capacity - 1) == 0);
            this.array = new Object[capacity];
            this.size = 0;
        }

        @Override
        public void add(int index, T item) {
            assert (0 <= index && index <= this.size);
            assert (this.size < this.capacity());
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
            this.array[index] = item;
            ++this.size;
        }

        @Override
        public void addAll(ListInternal<T> source) {
            this.addSome(source, 0, source.size());
        }

        @Override
        public void addHead(T item) {
            assert (this.size < this.capacity());
            this.add(0, item);
        }

        @Override
        public void addSome(ListInternal<T> source, int index, int count) {
            assert (this.size + count <= this.capacity());
            if (count < 0) {
                return;
            }
            source.fill(this.array, this.size, index, count);
            this.size += count;
        }

        @Override
        public void addTail(T item) {
            assert (this.size < this.capacity());
            this.add(this.size, item);
        }

        @Override
        public int calculateFreeCapacity() {
            return this.array.length - this.size;
        }

        @Override
        public int capacity() {
            return this.array.length;
        }

        @Override
        public void clear() {
            Arrays.fill(this.array, null);
            this.size = 0;
        }

        public Object clone() {
            try {
                FixedListInternal result = (FixedListInternal)super.clone();
                result.array = Arrays.copyOf(this.array, this.array.length);
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        @Override
        public void fill(T[] target, int targetIndex, int index, int count) {
            assert (target.length - targetIndex >= count);
            assert (count <= this.size);
            if (count == 0) {
                return;
            }
            System.arraycopy(this.array, index, target, targetIndex, count);
        }

        @Override
        public T get(int index) {
            assert (0 <= index && index < this.size);
            return (T)this.array[index];
        }

        @Override
        public T getHead() {
            assert (this.size > 0);
            return (T)this.array[0];
        }

        @Override
        public T getTail() {
            assert (this.size > 0);
            return (T)this.array[this.size - 1];
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int j = 0; j < this.size; ++j) {
                    if (this.get(j) != null) continue;
                    return j;
                }
            } else {
                for (int j = 0; j < this.size; ++j) {
                    if (!o.equals(this.get(j))) continue;
                    return j;
                }
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean isFull() {
            return this.size == this.array.length;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                for (int j = this.size - 1; j >= 0; --j) {
                    if (this.get(j) != null) continue;
                    return j;
                }
            } else {
                for (int j = this.size - 1; j >= 0; --j) {
                    if (!o.equals(this.get(j))) continue;
                    return j;
                }
            }
            return -1;
        }

        @Override
        public T remove(int index) {
            assert (0 <= index && index < this.size);
            Object result = this.array[index];
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
            --this.size;
            this.array[this.size] = null;
            return (T)result;
        }

        @Override
        public T removeHead() {
            assert (this.size > 0);
            return this.remove(0);
        }

        @Override
        public T removeTail() {
            assert (this.size > 0);
            return this.remove(this.size - 1);
        }

        @Override
        public T set(int index, T item) {
            assert (0 <= index && index < this.size);
            Object result = this.array[index];
            this.array[index] = item;
            return (T)result;
        }

        @Override
        public int size() {
            return this.size;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < this.size; ++j) {
                builder.append(this.get(j)).append(",");
            }
            return builder.length() == 0 ? "" : builder.substring(0, builder.length() - 1);
        }
    }

    protected static class CircularListInternal<T>
    implements ListInternal<T>,
    Cloneable {
        protected Object[] array;
        protected int head;
        protected int size;

        public CircularListInternal(int capacity) {
            assert ((capacity & capacity - 1) == 0);
            this.array = new Object[capacity];
            this.size = 0;
            this.head = 0;
        }

        @Override
        public void add(int index, T item) {
            assert (0 <= index && index <= this.size);
            assert (this.size < this.capacity());
            int mask = this.array.length - 1;
            if (index <= this.size >>> 1) {
                if (index == 0) {
                    this.addHead(item);
                } else {
                    int i = this.head - 1 + index & mask;
                    if (this.head <= i) {
                        if (this.head == 0) {
                            this.array[mask] = this.array[0];
                            System.arraycopy(this.array, 1, this.array, 0, index - 1);
                            this.head = mask;
                        } else {
                            System.arraycopy(this.array, this.head, this.array, this.head - 1, index);
                            --this.head;
                        }
                    } else {
                        int amount = this.array.length - this.head;
                        System.arraycopy(this.array, this.head, this.array, this.head - 1, amount);
                        this.array[mask] = this.array[0];
                        System.arraycopy(this.array, 1, this.array, 0, i);
                        --this.head;
                    }
                    this.array[i] = item;
                    ++this.size;
                }
            } else if (index == this.size) {
                this.addTail(item);
            } else {
                int i = this.head + index & mask;
                int tail = this.head + this.size & mask;
                if (i <= tail) {
                    System.arraycopy(this.array, i, this.array, i + 1, tail - i);
                    tail = tail + 1 & mask;
                } else {
                    System.arraycopy(this.array, 0, this.array, 1, tail);
                    this.array[0] = this.array[mask];
                    System.arraycopy(this.array, i, this.array, i + 1, mask - i);
                    ++tail;
                }
                this.array[i] = item;
                ++this.size;
            }
        }

        @Override
        public void addAll(ListInternal<T> source) {
            this.addSome(source, 0, source.size());
        }

        @Override
        public void addHead(T item) {
            assert (this.size < this.capacity());
            this.head = this.head - 1 & this.array.length - 1;
            this.array[this.head] = item;
            ++this.size;
        }

        @Override
        public void addSome(ListInternal<T> source, int index, int count) {
            assert (this.size + count <= this.capacity());
            int mask = this.array.length - 1;
            int tail = this.head + this.size & mask;
            while (count > 0) {
                int batch = Math.min(count, this.array.length - tail);
                source.fill(this.array, tail, index, batch);
                tail = tail + batch & mask;
                index += batch;
                count -= batch;
                this.size += batch;
            }
        }

        @Override
        public void addTail(T item) {
            assert (this.size < this.capacity());
            this.array[this.head + this.size & this.array.length - 1] = item;
            ++this.size;
        }

        @Override
        public int calculateFreeCapacity() {
            return this.array.length - this.size;
        }

        @Override
        public int capacity() {
            return this.array.length;
        }

        @Override
        public void clear() {
            Arrays.fill(this.array, null);
            this.size = 0;
            this.head = 0;
        }

        public Object clone() {
            try {
                CircularListInternal result = (CircularListInternal)super.clone();
                result.array = Arrays.copyOf(this.array, this.array.length);
                return result;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        @Override
        public void fill(T[] target, int targetIndex, int index, int count) {
            assert (target.length - targetIndex >= count);
            assert (count <= this.size);
            if (count == 0) {
                return;
            }
            int tail = index + count & this.array.length - 1;
            if ((index = this.head + index & this.array.length - 1) < tail) {
                System.arraycopy(this.array, index, target, targetIndex, count);
            } else {
                int c = this.array.length - index;
                System.arraycopy(this.array, index, target, targetIndex, c);
                System.arraycopy(this.array, 0, target, targetIndex += c, count -= c);
            }
        }

        @Override
        public T get(int index) {
            assert (0 <= index && index < this.size);
            return (T)this.array[this.head + index & this.array.length - 1];
        }

        @Override
        public T getHead() {
            assert (this.size > 0);
            return (T)this.array[this.head];
        }

        @Override
        public T getTail() {
            assert (this.size > 0);
            return (T)this.array[this.head + this.size - 1 & this.array.length - 1];
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int j = 0; j < this.size; ++j) {
                    if (this.get(j) != null) continue;
                    return j;
                }
            } else {
                for (int j = 0; j < this.size; ++j) {
                    if (!o.equals(this.get(j))) continue;
                    return j;
                }
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean isFull() {
            return this.size == this.array.length;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                for (int j = this.size - 1; j >= 0; --j) {
                    if (this.get(j) != null) continue;
                    return j;
                }
            } else {
                for (int j = this.size - 1; j >= 0; --j) {
                    if (!o.equals(this.get(j))) continue;
                    return j;
                }
            }
            return -1;
        }

        @Override
        public T remove(int index) {
            assert (0 <= index && index < this.size);
            int mask = this.array.length - 1;
            int i = this.head + index & mask;
            Object result = this.array[i];
            if (index < this.size >>> 1) {
                if (this.head <= i) {
                    System.arraycopy(this.array, this.head, this.array, this.head + 1, index);
                } else {
                    System.arraycopy(this.array, 0, this.array, 1, i);
                    this.array[0] = this.array[mask];
                    System.arraycopy(this.array, this.head, this.array, this.head + 1, mask - this.head);
                }
                this.array[this.head] = null;
                this.head = this.head + 1 & mask;
            } else {
                int tail = this.head + this.size & mask;
                if (i < tail) {
                    System.arraycopy(this.array, i + 1, this.array, i, tail - i - 1);
                    --tail;
                } else {
                    System.arraycopy(this.array, i + 1, this.array, i, mask - i);
                    this.array[mask] = this.array[0];
                    if (tail > 0) {
                        System.arraycopy(this.array, 1, this.array, 0, tail - 1);
                    }
                    tail = tail - 1 & mask;
                }
                this.array[tail] = null;
            }
            --this.size;
            return (T)result;
        }

        @Override
        public T removeHead() {
            assert (this.size > 0);
            Object result = this.array[this.head];
            this.array[this.head] = null;
            this.head = this.head + 1 & this.array.length - 1;
            --this.size;
            return (T)result;
        }

        @Override
        public T removeTail() {
            assert (this.size > 0);
            int tail = this.head + this.size - 1 & this.array.length - 1;
            Object result = this.array[tail];
            this.array[tail] = null;
            --this.size;
            return (T)result;
        }

        @Override
        public T set(int index, T item) {
            assert (0 <= index && index < this.size);
            int i = this.head + index & this.array.length - 1;
            Object result = this.array[i];
            this.array[i] = item;
            return (T)result;
        }

        @Override
        public int size() {
            return this.size;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < this.size; ++j) {
                builder.append(this.get(j)).append(",");
            }
            return builder.length() == 0 ? "" : builder.substring(0, builder.length() - 1);
        }
    }
}

