/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.jp2rt;

import it.unimi.di.jp2rt.MolecularDescriptorsWrapper;
import it.unimi.di.jp2rt.TSVLine;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;

public class MolecularDescriptorsCalculator {
    private MolecularDescriptorsCalculator() {
    }

    public static long numLines(String filename) throws IOException {
        byte[] buffer = new byte[8192];
        int count = 0;
        try (FileInputStream stream = new FileInputStream(filename);){
            int n;
            while ((n = stream.read(buffer)) > 0) {
                for (int i = 0; i < n; ++i) {
                    if (buffer[i] != 10) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static Stream<TSVLine> fromStream(Stream<String> stream, ProgressBarBuilder pbb) {
        Objects.requireNonNull(stream, "Stream cannot be null");
        return pbb == null ? stream.map(ThreadSafeCalculator::calculate) : ProgressBar.wrap(stream, pbb).map(ThreadSafeCalculator::calculate);
    }

    public static Stream<TSVLine> fromFile(String inPath, ProgressBarBuilder pbb) throws IOException {
        Path p = Paths.get(Objects.requireNonNull(inPath, "Input file cannot be null"), new String[0]);
        if (!p.toFile().isFile() || !p.toFile().canRead()) {
            throw new IllegalArgumentException("Input file does not exist or is not readable");
        }
        return MolecularDescriptorsCalculator.fromStream((Stream)Files.lines(p).parallel(), pbb);
    }

    public static Stream<TSVLine> fromFile(String inPath) throws IOException {
        ProgressBarBuilder pbb = new ProgressBarBuilder();
        pbb.setInitialMax(MolecularDescriptorsCalculator.numLines(inPath)).setTaskName("Computing");
        return MolecularDescriptorsCalculator.fromFile(inPath, pbb);
    }

    public static Stream<TSVLine> fromList(List<String> list, ProgressBarBuilder pbb) {
        Objects.requireNonNull(list, "List cannot be null");
        return MolecularDescriptorsCalculator.fromStream((Stream)list.stream().parallel(), pbb);
    }

    public static void toFile(Stream<TSVLine> stream, String outPath) throws IOException {
        Objects.requireNonNull(stream, "Stream cannot be null");
        try (PrintWriter ps = new PrintWriter(new BufferedOutputStream(new FileOutputStream(outPath)));){
            stream.forEach(ps::println);
        }
    }

    public static void main(String[] args) throws IOException {
        String help = "Usage: jp2rt --list-descriptors | -l, or DescriptorsCalculator <input file> <output file>";
        if (args.length == 1) {
            System.out.println(args[0].equals("--list-descriptors") || args[0].equals("-l") ? new MolecularDescriptorsWrapper() : "Usage: jp2rt --list-descriptors | -l, or DescriptorsCalculator <input file> <output file>");
            System.exit(0);
        } else if (args.length != 2) {
            System.err.println("Usage: jp2rt --list-descriptors | -l, or DescriptorsCalculator <input file> <output file>");
            System.exit(1);
        }
        MolecularDescriptorsCalculator.toFile(MolecularDescriptorsCalculator.fromFile(args[0]), args[1]);
    }

    private static class ThreadSafeCalculator {
        private static final ThreadLocal<MolecularDescriptorsWrapper> descriptorsHolder = new ThreadLocal<MolecularDescriptorsWrapper>(){

            @Override
            protected MolecularDescriptorsWrapper initialValue() {
                return new MolecularDescriptorsWrapper();
            }
        };

        private ThreadSafeCalculator() {
        }

        public static TSVLine calculate(String smiles) {
            return descriptorsHolder.get().calculate(new TSVLine(smiles));
        }
    }
}

