/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.di.jp2rt;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class TSVLine {
    private final String[] extra;
    private final String smiles;
    private DoubleStream descriptors = null;

    public TSVLine(String line) {
        String[] fields = Objects.requireNonNull(line, "The line parameter must not be null").split("\t");
        this.extra = Arrays.copyOfRange(fields, 0, fields.length - 1);
        this.smiles = fields[fields.length - 1];
        if (this.smiles.isBlank()) {
            throw new IllegalArgumentException("The SMILES string (last field on the line) must not be blank");
        }
    }

    public List<String> extra() {
        return Arrays.asList(this.extra);
    }

    public String smiles() {
        return this.smiles;
    }

    public double[] descriptors() {
        return this.descriptors.toArray();
    }

    public TSVLine descriptors(DoubleStream values) {
        this.descriptors = Objects.requireNonNull(values, "The values parameter must not be null");
        return this;
    }

    public String toString() {
        return (String)(this.extra.length > 0 ? String.join((CharSequence)"\t", this.extra) + "\t" : "") + this.smiles + (String)(this.descriptors != null ? "\t" + this.descriptors.mapToObj(Double::toString).collect(Collectors.joining("\t")) : "");
    }
}

