/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.openscience.cdk.Polymer;
import org.openscience.cdk.Strand;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IStrand;

public class BioPolymer
extends Polymer
implements Serializable,
IBioPolymer {
    private static final long serialVersionUID = -5001873073769634393L;
    private final Map<String, IStrand> strands = new Hashtable<String, IStrand>();

    @Override
    public void addAtom(IAtom oAtom, IStrand oStrand) {
        int atomCount = super.getAtomCount();
        super.addAtom(oAtom);
        if (atomCount != super.getAtomCount() && oStrand != null) {
            oStrand.addAtom(oAtom);
            if (!this.strands.containsKey(oStrand.getStrandName())) {
                this.strands.put(oStrand.getStrandName(), oStrand);
            }
        }
    }

    @Override
    public void addAtom(IAtom oAtom, IMonomer oMonomer, IStrand oStrand) {
        int atomCount = super.getAtomCount();
        super.addAtom(oAtom);
        if (atomCount != super.getAtomCount() && oStrand != null) {
            oStrand.addAtom(oAtom, oMonomer);
            if (!this.strands.containsKey(oStrand.getStrandName())) {
                this.strands.put(oStrand.getStrandName(), oStrand);
            }
        }
    }

    @Override
    public int getMonomerCount() {
        Iterator<String> keys = this.strands.keySet().iterator();
        int number = 0;
        if (!keys.hasNext()) {
            return super.getMonomerCount();
        }
        while (keys.hasNext()) {
            Strand tmp = (Strand)this.strands.get(keys.next());
            number += tmp.getMonomers().size() - 1;
        }
        return number;
    }

    @Override
    public IMonomer getMonomer(String monName, String strandName) {
        Strand strand = (Strand)this.strands.get(strandName);
        if (strand != null) {
            return strand.getMonomer(monName);
        }
        return null;
    }

    @Override
    public Collection<String> getMonomerNames() {
        Iterator<String> keys = this.strands.keySet().iterator();
        Hashtable<String, IMonomer> monomers = new Hashtable<String, IMonomer>();
        if (!keys.hasNext()) {
            return super.getMonomerNames();
        }
        while (keys.hasNext()) {
            Strand oStrand = (Strand)this.strands.get(keys.next());
            monomers.putAll(oStrand.getMonomers());
        }
        return monomers.keySet();
    }

    @Override
    public int getStrandCount() {
        return this.strands.size();
    }

    @Override
    public IStrand getStrand(String cName) {
        return this.strands.get(cName);
    }

    @Override
    public Collection<String> getStrandNames() {
        return this.strands.keySet();
    }

    @Override
    public void removeStrand(String name) {
        if (this.strands.containsKey(name)) {
            Strand strand = (Strand)this.strands.get(name);
            this.remove(strand);
            this.strands.remove(name);
        }
    }

    @Override
    public Map<String, IStrand> getStrands() {
        return this.strands;
    }

    @Override
    public String toString() {
        StringBuilder stringContent = new StringBuilder();
        stringContent.append("BioPolymer(");
        stringContent.append(this.hashCode()).append(", ");
        stringContent.append(super.toString());
        stringContent.append(')');
        return stringContent.toString();
    }

    @Override
    public IBioPolymer clone() throws CloneNotSupportedException {
        BioPolymer clone = (BioPolymer)super.clone();
        clone.strands.clear();
        for (String value : clone.getStrandNames()) {
            Strand strand = (Strand)clone.getStrand(value.toString()).clone();
            for (String s : strand.getMonomerNames()) {
                IMonomer monomer = strand.getMonomer(s.toString());
                for (IAtom iAtom : monomer.atoms()) {
                    clone.addAtom(iAtom, monomer, strand);
                }
            }
        }
        return clone;
    }
}

