/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.charges.IChargeCalculator;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.HOSECodeGenerator;

public class AtomTypeCharges
implements IChargeCalculator {
    final HOSECodeGenerator hcg = new HOSECodeGenerator(1);
    final Pattern pOC = Pattern.compile("O-[1][-];=?+C[(]=?+O.*+");
    final Pattern pOP = Pattern.compile("O-[1][-];=?+P.*+");
    final Pattern pOS = Pattern.compile("O-[1][-];=?+S.*+");
    final Pattern p_p = Pattern.compile("[A-Za-z]{1,2}+[-][0-6].?+[+].*+");
    final Pattern p_n = Pattern.compile("[A-Za-z]{1,2}+[-][0-6].?+[-].*+");

    AtomTypeCharges() {
    }

    public IAtomContainer setCharges(IAtomContainer atomContainer) throws Exception {
        atomContainer = this.setInitialCharges(atomContainer);
        return atomContainer;
    }

    private String removeAromaticityFlagsFromHoseCode(String hoseCode) {
        String hosecode = "";
        for (int i = 0; i < hoseCode.length(); ++i) {
            if (hoseCode.charAt(i) == '*') continue;
            hosecode = hosecode + hoseCode.charAt(i);
        }
        return hosecode;
    }

    private IAtomContainer setInitialCharges(IAtomContainer ac) throws CDKException {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            String hoseCode;
            try {
                hoseCode = this.hcg.getHOSECode(ac, ac.getAtom(i), 3);
            }
            catch (CDKException ex1) {
                throw new CDKException("Could not build HOSECode from atom " + i + " due to " + ex1, ex1);
            }
            hoseCode = this.removeAromaticityFlagsFromHoseCode(hoseCode);
            Matcher matOC = this.pOC.matcher(hoseCode);
            Matcher matOP = this.pOP.matcher(hoseCode);
            Matcher matOS = this.pOS.matcher(hoseCode);
            Matcher mat_p = this.p_p.matcher(hoseCode);
            Matcher mat_n = this.p_n.matcher(hoseCode);
            if (matOC.matches()) {
                ac.getAtom(i).setCharge(-0.5);
                continue;
            }
            if (matOP.matches()) {
                ac.getAtom(i).setCharge(-0.666);
                continue;
            }
            if (matOS.matches()) {
                ac.getAtom(i).setCharge(-0.5);
                continue;
            }
            if (mat_p.matches()) {
                ac.getAtom(i).setCharge(1.0);
                continue;
            }
            if (mat_n.matches()) {
                ac.getAtom(i).setCharge(-1.0);
                continue;
            }
            ac.getAtom(i).setCharge(new Double(ac.getAtom(i).getFormalCharge().intValue()));
        }
        return ac;
    }

    @Override
    public void calculateCharges(IAtomContainer container) throws CDKException {
        try {
            this.setInitialCharges(container);
        }
        catch (Exception exception) {
            throw new CDKException("Could not calculate Gasteiger-Marsili PEPE charges: " + exception.getMessage(), exception);
        }
    }
}

