/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import org.openscience.cdk.config.BODRIsotope;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Isotopes
extends IsotopeFactory {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Isotopes.class);
    private static Isotopes myself = null;

    public static Isotopes getInstance() throws IOException {
        if (myself == null) {
            myself = new Isotopes();
        }
        return myself;
    }

    private Isotopes() throws IOException {
        String configFile = "org/openscience/cdk/config/data/isotopes.dat";
        try (InputStream ins = this.getClass().getClassLoader().getResourceAsStream(configFile);){
            if (ins == null) {
                throw new IllegalStateException("Could not load isotope data");
            }
            int streamSize = ins.available();
            try (ReadableByteChannel fcIn = Channels.newChannel(ins);){
                ByteBuffer bin = ByteBuffer.allocate(streamSize);
                fcIn.read(bin);
                ((Buffer)bin).position(0);
                int isotopeCount = bin.getInt();
                for (int i = 0; i < isotopeCount; ++i) {
                    byte atomicNum = bin.get();
                    short massNum = bin.getShort();
                    double exactMass = bin.getDouble();
                    double natAbund = bin.get() == 1 ? bin.getDouble() : 0.0;
                    BODRIsotope isotope = new BODRIsotope(PeriodicTable.getSymbol(atomicNum), Integer.valueOf(atomicNum), Integer.valueOf(massNum), exactMass, natAbund);
                    this.add(isotope);
                }
            }
        }
    }

    private static boolean isMajor(IIsotope atom) {
        Integer mass = atom.getMassNumber();
        if (mass == null) {
            return false;
        }
        try {
            Isotopes instance = Isotopes.getInstance();
            IIsotope major = instance.getMajorIsotope(atom.getAtomicNumber());
            if (major == null) {
                return false;
            }
            return major.getMassNumber().equals(mass);
        }
        catch (IOException e) {
            logger.error("Could not load Isotope data: ", e.getMessage());
            return false;
        }
    }

    public static void clearMajorIsotopes(IAtomContainer mol) {
        for (IAtom atom : mol.atoms()) {
            if (!Isotopes.isMajor(atom)) continue;
            atom.setMassNumber(null);
            atom.setExactMass(null);
            atom.setNaturalAbundance(null);
        }
    }

    public static void clearMajorIsotopes(IMolecularFormula formula) {
        ArrayList majorIsotopes = new ArrayList();
        formula.isotopes().forEach(i -> {
            if (Isotopes.isMajor(i)) {
                majorIsotopes.add(i);
            }
        });
        for (IIsotope iso : majorIsotopes) {
            int count = formula.getIsotopeCount(iso);
            formula.removeIsotope(iso);
            iso.setMassNumber(null);
            if (iso.getMassNumber() != null) {
                iso = formula.getBuilder().newInstance(IIsotope.class, iso.getSymbol());
                iso.setAtomicNumber(iso.getAtomicNumber());
            }
            iso.setExactMass(null);
            iso.setNaturalAbundance(null);
            formula.addIsotope(iso, count);
        }
    }
}

