/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Iterator;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.formula.AdductFormula;
import org.openscience.cdk.interfaces.IAdductFormula;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugAdductFormula
extends AdductFormula
implements IAdductFormula {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugAdductFormula.class);

    public DebugAdductFormula() {
    }

    public DebugAdductFormula(IMolecularFormula formula) {
        super(formula);
    }

    @Override
    public boolean contains(IIsotope isotope) {
        this.logger.debug("Contains Isotope?: ", isotope);
        return super.contains(isotope);
    }

    @Override
    public Integer getCharge() {
        Integer charge = super.getCharge();
        this.logger.debug("Getting charge: ", charge);
        return charge;
    }

    @Override
    public int getIsotopeCount(IIsotope isotope) {
        this.logger.debug("Getting isotope count for: ", isotope);
        return super.getIsotopeCount(isotope);
    }

    @Override
    public int getIsotopeCount() {
        this.logger.debug("Getting isotope count: ", super.getIsotopeCount());
        return super.getIsotopeCount();
    }

    @Override
    public Iterable<IIsotope> isotopes() {
        this.logger.debug("Getting isotope iterator..");
        return super.isotopes();
    }

    @Override
    public void setCharge(Integer charge) {
        this.logger.debug("Setting the charge to: ", charge);
        super.setCharge(charge);
    }

    @Override
    public void add(IMolecularFormulaSet formulaSet) {
        this.logger.debug("Adding a formula set: ", formulaSet);
        super.add(formulaSet);
    }

    @Override
    public void addMolecularFormula(IMolecularFormula formula) {
        this.logger.debug("Adding formula: ", formula);
        super.addMolecularFormula(formula);
    }

    @Override
    public boolean contains(IMolecularFormula formula) {
        this.logger.debug("Contains formula?: ", formula);
        return super.contains(formula);
    }

    @Override
    public IMolecularFormula getMolecularFormula(int position) {
        this.logger.debug("Getting formula at: ", position);
        return super.getMolecularFormula(position);
    }

    @Override
    public Iterator<IMolecularFormula> iterator() {
        this.logger.debug("Getting molecular formula iterator...");
        return super.iterator();
    }

    @Override
    public Iterable<IMolecularFormula> molecularFormulas() {
        this.logger.debug("Getting molecular formula iterable...");
        return super.molecularFormulas();
    }

    @Override
    public void removeAllMolecularFormulas() {
        this.logger.debug("Removing all formulas...");
        super.removeAllMolecularFormulas();
    }

    @Override
    public void removeMolecularFormula(IMolecularFormula formula) {
        this.logger.debug("Removing this formula: ", formula);
        super.removeMolecularFormula(formula);
    }

    @Override
    public void removeMolecularFormula(int position) {
        this.logger.debug("Removing the formula at position: ", position);
        super.removeMolecularFormula(position);
    }

    @Override
    public int size() {
        this.logger.debug("Getting the size of this adduct: " + super.size());
        return super.size();
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }
}

