/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.AtomContainerSet;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ISubstance;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class DebugSubstance
extends AtomContainerSet
implements ISubstance {
    private static final long serialVersionUID = 7729610512495602788L;
    final ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugSubstance.class);

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public <T> T getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flagType, boolean flagValue) {
        this.logger.debug("Setting flag: ", flagType + "=" + flagValue);
        super.setFlag(flagType, flagValue);
    }

    @Override
    public boolean getFlag(int flagType) {
        this.logger.debug("Setting flag: ", flagType + "=" + super.getFlag(flagType));
        return super.getFlag(flagType);
    }

    @Override
    public void addProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.addProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public void addAtomContainer(IAtomContainer atomContainer) {
        this.logger.debug("Adding atom container: ", atomContainer);
        super.addAtomContainer(atomContainer);
    }

    @Override
    public void removeAtomContainer(IAtomContainer atomContainer) {
        this.logger.debug("Removing atom container: ", atomContainer);
        super.removeAtomContainer(atomContainer);
    }

    @Override
    public void removeAllAtomContainers() {
        this.logger.debug("Removing all atom containers");
        super.removeAllAtomContainers();
    }

    @Override
    public void removeAtomContainer(int pos) {
        this.logger.debug("Removing atom container at pos: ", pos);
        super.removeAtomContainer(pos);
    }

    @Override
    public void replaceAtomContainer(int position, IAtomContainer container) {
        this.logger.debug("Replacing atom container at pos: ", position);
        super.replaceAtomContainer(position, container);
    }

    @Override
    public boolean setMultiplier(IAtomContainer container, Double multiplier) {
        this.logger.debug("Setting multiplier for atomcontainer: ", container, "" + multiplier);
        return super.setMultiplier(container, multiplier);
    }

    @Override
    public void setMultiplier(int position, Double multiplier) {
        this.logger.debug("Setting multiplier for atomcontainer at pos: ", "" + position, "" + multiplier);
        super.setMultiplier(position, multiplier);
    }

    @Override
    public Double[] getMultipliers() {
        this.logger.debug("Getting multipliers array: ", super.getMultipliers().length);
        return super.getMultipliers();
    }

    @Override
    public boolean setMultipliers(Double[] newMultipliers) {
        this.logger.debug("Setting multipliers array: ", newMultipliers.length);
        return super.setMultipliers(newMultipliers);
    }

    @Override
    public void addAtomContainer(IAtomContainer atomContainer, double multiplier) {
        this.logger.debug("Adding atom container with multiplier: ", "" + multiplier, atomContainer);
        super.addAtomContainer(atomContainer, multiplier);
    }

    @Override
    public void add(IAtomContainerSet atomContainerSet) {
        this.logger.debug("Adding set of atom containers: ", atomContainerSet);
        super.add(atomContainerSet);
    }

    @Override
    public Iterable<IAtomContainer> atomContainers() {
        this.logger.debug("Getting AtomContainer iterator");
        return super.atomContainers();
    }

    @Override
    public IAtomContainer getAtomContainer(int number) {
        this.logger.debug("Getting atom container at: ", number);
        return super.getAtomContainer(number);
    }

    @Override
    public Double getMultiplier(int number) {
        this.logger.debug("Getting multiplier at: ", number);
        return super.getMultiplier(number);
    }

    @Override
    public Double getMultiplier(IAtomContainer container) {
        this.logger.debug("Getting multiplier for atom container: ", container);
        return super.getMultiplier(container);
    }

    @Override
    public int getAtomContainerCount() {
        this.logger.debug("Getting atom container count: ", super.getAtomContainerCount());
        return super.getAtomContainerCount();
    }

    @Override
    public boolean isEmpty() {
        this.logger.debug("Checking if the atom container set empty: ", this.atomContainerCount == 0);
        return this.atomContainerCount == 0;
    }
}

