/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.AbstractFingerprinter;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.fingerprint.ICountFingerprint;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.fingerprint.IntArrayCountFingerprint;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class Fingerprinter
extends AbstractFingerprinter
implements IFingerprinter {
    private static final int DEFAULT_PATH_LIMIT = 42000;
    public static final int DEFAULT_SIZE = 1024;
    public static final int DEFAULT_SEARCH_DEPTH = 7;
    private final int size;
    private final int searchDepth;
    private int pathLimit = 42000;
    private boolean hashPseudoAtoms = false;
    static int debugCounter = 0;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Fingerprinter.class);

    public Fingerprinter() {
        this(1024, 7);
    }

    public Fingerprinter(int size) {
        this(size, 7);
    }

    public Fingerprinter(int size, int searchDepth) {
        this.size = size;
        this.searchDepth = searchDepth;
    }

    @Override
    protected List<Map.Entry<String, String>> getParameters() {
        return Arrays.asList(new AbstractMap.SimpleImmutableEntry<String, String>("searchDepth", Integer.toString(this.searchDepth)), new AbstractMap.SimpleImmutableEntry<String, String>("pathLimit", Integer.toString(this.pathLimit)), new AbstractMap.SimpleImmutableEntry<String, String>("hashPseudoAtoms", Boolean.toString(this.hashPseudoAtoms)));
    }

    public IBitFingerprint getBitFingerprint(IAtomContainer container, AllRingsFinder ringFinder) throws CDKException {
        logger.debug("Entering Fingerprinter");
        logger.debug("Starting Aromaticity Detection");
        long before = System.currentTimeMillis();
        if (!Fingerprinter.hasPseudoAtom(container.atoms())) {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
            Aromaticity.cdkLegacy().apply(container);
        }
        long after = System.currentTimeMillis();
        logger.debug("time for aromaticity calculation: " + (after - before) + " milliseconds");
        logger.debug("Finished Aromaticity Detection");
        BitSet bitSet = new BitSet(this.size);
        this.encodePaths(container, this.searchDepth, bitSet, this.size);
        return new BitSetFingerprint(bitSet);
    }

    @Override
    public IBitFingerprint getBitFingerprint(IAtomContainer container) throws CDKException {
        return this.getBitFingerprint(container, null);
    }

    @Override
    public Map<String, Integer> getRawFingerprint(IAtomContainer container) throws CDKException {
        if (!Fingerprinter.hasPseudoAtom(container.atoms())) {
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
            Aromaticity.cdkLegacy().apply(container);
        }
        HashMap<String, Integer> rawFp = new HashMap<String, Integer>();
        BitSet bitSet = new BitSet(this.size);
        State state = new State(container, bitSet, this.size, this.searchDepth + 1);
        state.setFeatureMap(rawFp);
        for (IAtom atom : container.atoms()) {
            state.numPaths = 0;
            state.visit(atom);
            this.traversePaths(state, atom, null);
            state.unvisit(atom);
        }
        return rawFp;
    }

    @Override
    public ICountFingerprint getCountFingerprint(IAtomContainer container) throws CDKException {
        return new IntArrayCountFingerprint(this.getRawFingerprint(container));
    }

    private IBond findBond(List<IBond> bonds, IAtom beg, IAtom end) {
        for (IBond bond : bonds) {
            if (!bond.contains(beg) || !bond.contains(end)) continue;
            return bond;
        }
        return null;
    }

    private String encodePath(IAtomContainer mol, List<IAtom> path, StringBuilder buffer) {
        buffer.setLength(0);
        IAtom prev = path.get(0);
        buffer.append(Fingerprinter.getAtomSymbol(prev));
        for (int i = 1; i < path.size(); ++i) {
            IAtom next = path.get(i);
            List<IBond> bonds = mol.getConnectedBondsList(prev);
            IBond bond = this.findBond(bonds, next, prev);
            if (bond == null) {
                throw new IllegalStateException("FATAL - Atoms in patch were connected?");
            }
            buffer.append(this.getBondSymbol(bond));
            buffer.append(Fingerprinter.getAtomSymbol(next));
            prev = next;
        }
        return buffer.toString();
    }

    private String encodePath(List<IAtom> apath, List<IBond> bpath, StringBuilder buffer) {
        buffer.setLength(0);
        IAtom prev = apath.get(0);
        buffer.append(Fingerprinter.getAtomSymbol(prev));
        for (int i = 1; i < apath.size(); ++i) {
            IAtom next = apath.get(i);
            IBond bond = bpath.get(i - 1);
            buffer.append(this.getBondSymbol(bond));
            buffer.append(Fingerprinter.getAtomSymbol(next));
        }
        return buffer.toString();
    }

    private String encodeRevPath(List<IAtom> apath, List<IBond> bpath, StringBuilder buffer) {
        buffer.setLength(0);
        int len = apath.size();
        IAtom prev = apath.get(len - 1);
        buffer.append(Fingerprinter.getAtomSymbol(prev));
        for (int i = len - 2; i >= 0; --i) {
            IAtom next = apath.get(i);
            IBond bond = bpath.get(i);
            buffer.append(this.getBondSymbol(bond));
            buffer.append(Fingerprinter.getAtomSymbol(next));
        }
        return buffer.toString();
    }

    private static int appendHash(int hash, String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            hash = 31 * hash + str.charAt(0);
        }
        return hash;
    }

    private int hashPath(List<IAtom> apath, List<IBond> bpath) {
        int hash = 0;
        hash = Fingerprinter.appendHash(hash, Fingerprinter.getAtomSymbol(apath.get(0)));
        for (int i = 1; i < apath.size(); ++i) {
            IAtom next = apath.get(i);
            IBond bond = bpath.get(i - 1);
            hash = Fingerprinter.appendHash(hash, this.getBondSymbol(bond));
            hash = Fingerprinter.appendHash(hash, Fingerprinter.getAtomSymbol(next));
        }
        return hash;
    }

    private int hashRevPath(List<IAtom> apath, List<IBond> bpath) {
        int hash = 0;
        int last = apath.size() - 1;
        hash = Fingerprinter.appendHash(hash, Fingerprinter.getAtomSymbol(apath.get(last)));
        for (int i = last - 1; i >= 0; --i) {
            IAtom next = apath.get(i);
            IBond bond = bpath.get(i);
            hash = Fingerprinter.appendHash(hash, this.getBondSymbol(bond));
            hash = Fingerprinter.appendHash(hash, Fingerprinter.getAtomSymbol(next));
        }
        return hash;
    }

    private void traversePaths(State state, IAtom beg, IBond prev) throws CDKException {
        if (!this.hashPseudoAtoms && Fingerprinter.isPseudo(beg)) {
            return;
        }
        state.push(beg, prev);
        state.storePath();
        if (state.numPaths > this.pathLimit) {
            throw new CDKException("Too many paths! Structure is likely a cage, reduce path length or increase path limit");
        }
        if (state.apath.size() < state.maxDepth) {
            for (IBond bond : state.getBonds(beg)) {
                IAtom nbr;
                if (bond.equals(prev) || !state.visit(nbr = bond.getOther(beg))) continue;
                this.traversePaths(state, nbr, bond);
                state.unvisit(nbr);
            }
        }
        state.pop();
    }

    @Deprecated
    protected int[] findPathes(IAtomContainer container, int searchDepth) throws CDKException {
        HashSet<Integer> hashes = new HashSet<Integer>();
        StringBuilder buffer = new StringBuilder();
        for (IAtom startAtom : container.atoms()) {
            List<List<IAtom>> p = PathTools.getLimitedPathsOfLengthUpto(container, startAtom, searchDepth, this.pathLimit);
            for (List<IAtom> path : p) {
                if (!this.hashPseudoAtoms && Fingerprinter.hasPseudoAtom(path)) continue;
                hashes.add(this.encodeUniquePath(container, path, buffer));
            }
        }
        int pos = 0;
        int[] result = new int[hashes.size()];
        for (Integer hash : hashes) {
            result[pos++] = hash;
        }
        return result;
    }

    protected void encodePaths(IAtomContainer mol, int depth, BitSet fp, int size) throws CDKException {
        State state = new State(mol, fp, size, depth + 1);
        for (IAtom atom : mol.atoms()) {
            state.numPaths = 0;
            state.visit(atom);
            this.traversePaths(state, atom, null);
            state.unvisit(atom);
        }
    }

    private static boolean isPseudo(IAtom a) {
        return Fingerprinter.getElem(a) == 0;
    }

    private static boolean hasPseudoAtom(Iterable<IAtom> path) {
        for (IAtom atom : path) {
            if (!Fingerprinter.isPseudo(atom)) continue;
            return true;
        }
        return false;
    }

    private int encodeUniquePath(IAtomContainer container, List<IAtom> path, StringBuilder buffer) {
        if (path.size() == 1) {
            return Fingerprinter.getAtomSymbol(path.get(0)).hashCode();
        }
        String forward = this.encodePath(container, path, buffer);
        Collections.reverse(path);
        String reverse = this.encodePath(container, path, buffer);
        Collections.reverse(path);
        int x = reverse.compareTo(forward) < 0 ? forward.hashCode() : reverse.hashCode();
        return x;
    }

    private static int compare(IAtom a, IAtom b) {
        int elemB;
        int elemA = Fingerprinter.getElem(a);
        if (elemA == (elemB = Fingerprinter.getElem(b))) {
            return 0;
        }
        return Fingerprinter.getAtomSymbol(a).compareTo(Fingerprinter.getAtomSymbol(b));
    }

    private int compare(IBond a, IBond b) {
        return this.getBondSymbol(a).compareTo(this.getBondSymbol(b));
    }

    private int compare(List<IAtom> apath, List<IBond> bpath) {
        int i = 0;
        int len = apath.size();
        int j = len - 1;
        int cmp = Fingerprinter.compare(apath.get(i), apath.get(j));
        if (cmp != 0) {
            return cmp;
        }
        ++i;
        --j;
        while (j != 0) {
            cmp = this.compare(bpath.get(i - 1), bpath.get(j));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Fingerprinter.compare(apath.get(i), apath.get(j));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
            --j;
        }
        return 0;
    }

    private static int getElem(IAtom atom) {
        Integer elem = atom.getAtomicNumber();
        if (elem == null) {
            elem = 0;
        }
        return elem;
    }

    private static String getAtomSymbol(IAtom atom) {
        switch (Fingerprinter.getElem(atom)) {
            case 0: {
                return "*";
            }
            case 6: {
                return "C";
            }
            case 7: {
                return "N";
            }
            case 8: {
                return "O";
            }
            case 17: {
                return "X";
            }
            case 35: {
                return "Z";
            }
            case 14: {
                return "Y";
            }
            case 33: {
                return "D";
            }
            case 3: {
                return "L";
            }
            case 34: {
                return "E";
            }
            case 11: {
                return "G";
            }
            case 20: {
                return "J";
            }
            case 13: {
                return "A";
            }
        }
        return atom.getSymbol();
    }

    protected String getBondSymbol(IBond bond) {
        if (bond.isAromatic()) {
            return ":";
        }
        switch (bond.getOrder()) {
            case SINGLE: {
                return "-";
            }
            case DOUBLE: {
                return "=";
            }
            case TRIPLE: {
                return "#";
            }
        }
        return "";
    }

    public void setPathLimit(int limit) {
        this.pathLimit = limit;
    }

    public void setHashPseudoAtoms(boolean value) {
        this.hashPseudoAtoms = value;
    }

    public int getSearchDepth() {
        return this.searchDepth;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final class State {
        private int numPaths = 0;
        private final Random rand = new Random();
        private final BitSet fp;
        private Map<String, Integer> feats;
        private final IAtomContainer mol;
        private final Set<IAtom> visited = new HashSet<IAtom>();
        private final List<IAtom> apath = new ArrayList<IAtom>();
        private final List<IBond> bpath = new ArrayList<IBond>();
        private final int maxDepth;
        private final int fpsize;
        public final StringBuilder buffer = new StringBuilder();

        public State(IAtomContainer mol, BitSet fp, int fpsize, int maxDepth) {
            this.mol = mol;
            this.fp = fp;
            this.fpsize = fpsize;
            this.maxDepth = maxDepth;
        }

        public void setFeatureMap(Map<String, Integer> feats) {
            this.feats = feats;
        }

        List<IBond> getBonds(IAtom atom) {
            return this.mol.getConnectedBondsList(atom);
        }

        boolean visit(IAtom a) {
            return this.visited.add(a);
        }

        boolean unvisit(IAtom a) {
            return this.visited.remove(a);
        }

        void push(IAtom atom, IBond bond) {
            this.apath.add(atom);
            if (bond != null) {
                this.bpath.add(bond);
            }
        }

        void pop() {
            if (!this.apath.isEmpty()) {
                this.apath.remove(this.apath.size() - 1);
            }
            if (!this.bpath.isEmpty()) {
                this.bpath.remove(this.bpath.size() - 1);
            }
        }

        void addHash(int x) {
            ++this.numPaths;
            this.rand.setSeed(x);
            this.fp.set(this.rand.nextInt(this.fpsize));
        }

        private void storeFeat(String path) {
            if (this.feats == null) {
                return;
            }
            this.feats.compute(path, (k, v) -> v == null ? 1 : v + 1);
        }

        private void storeForward() {
            this.addHash(Fingerprinter.this.hashPath(this.apath, this.bpath));
            if (this.feats != null) {
                this.storeFeat(Fingerprinter.this.encodePath(this.apath, this.bpath, this.buffer));
            }
        }

        private void storeReverse() {
            this.addHash(Fingerprinter.this.hashRevPath(this.apath, this.bpath));
            if (this.feats != null) {
                this.storeFeat(Fingerprinter.this.encodeRevPath(this.apath, this.bpath, this.buffer));
            }
        }

        public boolean isOrderedPath() {
            return System.identityHashCode(this.apath.get(0)) < System.identityHashCode(this.apath.get(this.apath.size() - 1));
        }

        public void storePath() {
            if (this.bpath.isEmpty()) {
                this.addHash(Fingerprinter.getAtomSymbol(this.apath.get(0)).hashCode());
                this.storeFeat(Fingerprinter.getAtomSymbol(this.apath.get(0)));
            } else {
                if (!this.isOrderedPath()) {
                    return;
                }
                if (Fingerprinter.this.compare(this.apath, this.bpath) >= 0) {
                    this.storeForward();
                } else {
                    this.storeReverse();
                }
            }
        }
    }
}

