/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.Comparator;
import java.util.List;
import org.openscience.cdk.formula.IsotopeContainer;
import org.openscience.cdk.formula.IsotopePattern;
import org.openscience.cdk.formula.IsotopePatternGenerator;
import org.openscience.cdk.tools.LoggingToolFactory;

public class IsotopePatternManipulator {
    public static IsotopePattern normalize(IsotopePattern isotopeP) {
        IsotopeContainer isoHighest = null;
        double biggestAbundance = 0.0;
        for (IsotopeContainer isoContainer : isotopeP.getIsotopes()) {
            double abundance = isoContainer.getIntensity();
            if (!(biggestAbundance < abundance)) continue;
            biggestAbundance = abundance;
            isoHighest = isoContainer;
        }
        if (isoHighest == null) {
            throw new IllegalStateException("No isotope had the largest abundance");
        }
        IsotopePattern isoNormalized = new IsotopePattern();
        for (IsotopeContainer isoContainer : isotopeP.getIsotopes()) {
            double inten = isoContainer.getIntensity() / isoHighest.getIntensity();
            try {
                IsotopeContainer icClone = (IsotopeContainer)isoContainer.clone();
                icClone.setIntensity(inten);
                if (isoHighest.equals(isoContainer)) {
                    isoNormalized.setMonoIsotope(icClone);
                    continue;
                }
                isoNormalized.addIsotope(icClone);
            }
            catch (CloneNotSupportedException e) {
                LoggingToolFactory.createLoggingTool(IsotopePatternGenerator.class).warn("Clone failed:", e);
            }
        }
        isoNormalized.setCharge(isotopeP.getCharge());
        return isoNormalized;
    }

    public static IsotopePattern sortAndNormalizedByIntensity(IsotopePattern isotopeP) {
        IsotopePattern isoNorma = IsotopePatternManipulator.normalize(isotopeP);
        return IsotopePatternManipulator.sortByIntensity(isoNorma);
    }

    public static IsotopePattern sortByIntensity(IsotopePattern isotopeP) {
        try {
            IsotopePattern isoSort = (IsotopePattern)isotopeP.clone();
            if (isoSort.getNumberOfIsotopes() == 0) {
                return isoSort;
            }
            List<IsotopeContainer> listISO = isoSort.getIsotopes();
            listISO.sort(new Comparator<IsotopeContainer>(){

                @Override
                public int compare(IsotopeContainer o1, IsotopeContainer o2) {
                    return Double.compare(o2.getIntensity(), o1.getIntensity());
                }
            });
            isoSort.setMonoIsotope(listISO.get(0));
            return isoSort;
        }
        catch (CloneNotSupportedException e) {
            LoggingToolFactory.createLoggingTool(IsotopePatternGenerator.class).warn("Clone failed:", e);
            return null;
        }
    }

    public static IsotopePattern sortByMass(IsotopePattern isotopeP) {
        try {
            IsotopePattern isoSort = (IsotopePattern)isotopeP.clone();
            if (isoSort.getNumberOfIsotopes() == 0) {
                return isoSort;
            }
            List<IsotopeContainer> listISO = isoSort.getIsotopes();
            listISO.sort(new Comparator<IsotopeContainer>(){

                @Override
                public int compare(IsotopeContainer o1, IsotopeContainer o2) {
                    return Double.compare(o1.getMass(), o2.getMass());
                }
            });
            isoSort.setMonoIsotope(listISO.get(0));
            return isoSort;
        }
        catch (CloneNotSupportedException e) {
            LoggingToolFactory.createLoggingTool(IsotopePatternManipulator.class).warn("Unexpected Error:", e);
            return null;
        }
    }
}

