/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fragment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fragment.FragmentUtils;
import org.openscience.cdk.fragment.IFragmenter;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ExhaustiveFragmenter
implements IFragmenter {
    private static final int DEFAULT_MIN_FRAG_SIZE = 6;
    final Map<String, IAtomContainer> fragMap;
    final SmilesGenerator smilesGenerator;
    String[] fragments = null;
    int minFragSize;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ExhaustiveFragmenter.class);

    public ExhaustiveFragmenter() {
        this(6);
    }

    public ExhaustiveFragmenter(int minFragSize) {
        this.minFragSize = minFragSize;
        this.fragMap = new HashMap<String, IAtomContainer>();
        this.smilesGenerator = SmilesGenerator.unique().aromatic();
    }

    public void setMinimumFragmentSize(int minFragSize) {
        this.minFragSize = minFragSize;
    }

    @Override
    public void generateFragments(IAtomContainer atomContainer) throws CDKException {
        this.fragMap.clear();
        this.run(atomContainer);
    }

    private List<IAtomContainer> run(IAtomContainer atomContainer) throws CDKException {
        String tmpSmiles;
        ArrayList<IAtomContainer> fragments = new ArrayList<IAtomContainer>();
        if (atomContainer.getBondCount() < 3) {
            return fragments;
        }
        List<IBond> splitableBonds = this.getSplitableBonds(atomContainer);
        if (splitableBonds.size() == 0) {
            return fragments;
        }
        logger.debug("Got " + splitableBonds.size() + " splittable bonds");
        for (IBond bond : splitableBonds) {
            List<IAtomContainer> parts = FragmentUtils.splitMolecule(atomContainer, bond);
            for (IAtomContainer partContainer : parts) {
                AtomContainerManipulator.clearAtomConfigurations(partContainer);
                for (IAtom atom : partContainer.atoms()) {
                    atom.setImplicitHydrogenCount(null);
                }
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(partContainer);
                CDKHydrogenAdder.getInstance(partContainer.getBuilder()).addImplicitHydrogens(partContainer);
                Aromaticity.cdkLegacy().apply(partContainer);
                tmpSmiles = this.smilesGenerator.create(partContainer);
                if (partContainer.getAtomCount() < this.minFragSize || this.fragMap.containsKey(tmpSmiles)) continue;
                fragments.add(partContainer);
                this.fragMap.put(tmpSmiles, partContainer);
            }
        }
        ArrayList<IAtomContainer> tmp = new ArrayList<IAtomContainer>(fragments);
        for (IAtomContainer fragment : fragments) {
            List<IAtomContainer> frags;
            if (fragment.getBondCount() < 3 || fragment.getAtomCount() < this.minFragSize || this.getSplitableBonds(fragment).size() == 0 || (frags = this.run(fragment)).size() == 0) continue;
            for (IAtomContainer frag : frags) {
                if (frag.getBondCount() < 3) continue;
                AtomContainerManipulator.clearAtomConfigurations(frag);
                for (IAtom atom : frag.atoms()) {
                    atom.setImplicitHydrogenCount(null);
                }
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(frag);
                CDKHydrogenAdder.getInstance(frag.getBuilder()).addImplicitHydrogens(frag);
                Aromaticity.cdkLegacy().apply(frag);
                tmpSmiles = this.smilesGenerator.create(frag);
                if (frag.getAtomCount() < this.minFragSize || this.fragMap.containsKey(tmpSmiles)) continue;
                tmp.add(frag);
                this.fragMap.put(tmpSmiles, frag);
            }
        }
        fragments = new ArrayList<IAtomContainer>(tmp);
        return fragments;
    }

    private List<IBond> getSplitableBonds(IAtomContainer atomContainer) throws CDKException {
        SpanningTree spanningTree = new SpanningTree(atomContainer);
        IRingSet allRings = spanningTree.getAllRings();
        ArrayList<IBond> splitableBonds = new ArrayList<IBond>();
        for (IBond bond : atomContainer.bonds()) {
            boolean isInRing = false;
            boolean isTerminal = false;
            IRingSet rings = allRings.getRings(bond);
            if (rings.getAtomContainerCount() != 0) {
                isInRing = true;
            }
            for (IAtom atom : bond.atoms()) {
                if (atomContainer.getConnectedBondsCount(atom) != 1) continue;
                isTerminal = true;
                break;
            }
            if (isInRing || isTerminal) continue;
            splitableBonds.add(bond);
        }
        return splitableBonds;
    }

    @Override
    public String[] getFragments() {
        return new ArrayList<String>(this.fragMap.keySet()).toArray(new String[0]);
    }

    @Override
    public IAtomContainer[] getFragmentsAsContainers() {
        return new ArrayList<IAtomContainer>(this.fragMap.values()).toArray(new IAtomContainer[0]);
    }
}

