/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry;

import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

public class AtomTools {
    public static final double TETRAHEDRAL_ANGLE = 2.0 * Math.acos(1.0 / Math.sqrt(3.0));
    static final Vector3d XV = new Vector3d(1.0, 0.0, 0.0);
    static final Vector3d YV = new Vector3d(0.0, 1.0, 0.0);

    public static void add3DCoordinates1(IAtomContainer atomContainer) {
        IAtomContainer noCoords = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer refAtoms = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            IAtom refAtom;
            List<IAtom> connectedAtoms;
            IAtom atom = atomContainer.getAtom(i);
            if (atom.getPoint3d() != null || (connectedAtoms = atomContainer.getConnectedAtomsList(atom)).size() != 1 || (refAtom = connectedAtoms.get(0)).getPoint3d() == null) continue;
            refAtoms.addAtom(refAtom);
            noCoords.addAtom(atom);
            noCoords.addAtom(refAtom);
            noCoords.addBond(atomContainer.getBuilder().newInstance(IBond.class, new Object[]{atom, refAtom, IBond.Order.SINGLE}));
        }
        double length = 1.0;
        double angle = TETRAHEDRAL_ANGLE;
        for (int i = 0; i < refAtoms.getAtomCount(); ++i) {
            int nLigands;
            IAtom refAtom = refAtoms.getAtom(i);
            List<IAtom> noCoordLigands = noCoords.getConnectedAtomsList(refAtom);
            int nwanted = nLigands = noCoordLigands.size();
            String elementType = refAtom.getSymbol();
            if (elementType.equals("N") || elementType.equals("O") || elementType.equals("S")) {
                nwanted = 3;
            }
            Point3d[] newPoints = AtomTools.calculate3DCoordinatesForLigands(atomContainer, refAtom, nwanted, length, angle);
            for (int j = 0; j < nLigands; ++j) {
                IAtom ligand = noCoordLigands.get(j);
                Point3d newPoint = AtomTools.rescaleBondLength(refAtom, ligand, newPoints[j]);
                ligand.setPoint3d(newPoint);
            }
        }
    }

    public static Point3d rescaleBondLength(IAtom atom1, IAtom atom2, Point3d point2) {
        Point3d point1 = atom1.getPoint3d();
        double d1 = atom1.getCovalentRadius();
        double d2 = atom2.getCovalentRadius();
        double distance = d1 < 0.1 || d2 < 0.1 ? 1.0 : atom1.getCovalentRadius() + atom2.getCovalentRadius();
        Vector3d vect = new Vector3d(point2);
        vect.sub(point1);
        vect.normalize();
        vect.scale(distance);
        Point3d newPoint = new Point3d(point1);
        newPoint.add(vect);
        return newPoint;
    }

    public static Point3d[] calculate3DCoordinatesForLigands(IAtomContainer atomContainer, IAtom refAtom, int nwanted, double length, double angle) {
        Point3d bPoint;
        Point3d[] newPoints = new Point3d[]{};
        Point3d aPoint = refAtom.getPoint3d();
        List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(refAtom);
        if (connectedAtoms == null) {
            return newPoints;
        }
        int nligands = connectedAtoms.size();
        IAtomContainer ligandsWithCoords = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtom ligand : connectedAtoms) {
            if (ligand.getPoint3d() == null) continue;
            ligandsWithCoords.addAtom(ligand);
        }
        int nwithCoords = ligandsWithCoords.getAtomCount();
        if (nwithCoords > 3) {
            return newPoints;
        }
        if (nwithCoords == 0) {
            newPoints = AtomTools.calculate3DCoordinates0(refAtom.getPoint3d(), nwanted, length);
        } else if (nwithCoords == 1) {
            IAtom bAtom = ligandsWithCoords.getAtom(0);
            connectedAtoms = ligandsWithCoords.getConnectedAtomsList(bAtom);
            IAtom jAtom = null;
            for (IAtom connectedAtom : connectedAtoms) {
                if (connectedAtom.equals(refAtom)) continue;
                jAtom = connectedAtom;
                break;
            }
            newPoints = AtomTools.calculate3DCoordinates1(aPoint, bAtom.getPoint3d(), jAtom != null ? jAtom.getPoint3d() : null, nwanted, length, angle);
        } else if (nwithCoords == 2) {
            bPoint = ligandsWithCoords.getAtom(0).getPoint3d();
            Point3d cPoint = ligandsWithCoords.getAtom(1).getPoint3d();
            newPoints = AtomTools.calculate3DCoordinates2(aPoint, bPoint, cPoint, nwanted, length, angle);
        } else if (nwithCoords == 3) {
            bPoint = ligandsWithCoords.getAtom(0).getPoint3d();
            Point3d cPoint = ligandsWithCoords.getAtom(1).getPoint3d();
            Point3d dPoint = ligandsWithCoords.getAtom(2).getPoint3d();
            newPoints = new Point3d[]{AtomTools.calculate3DCoordinates3(aPoint, bPoint, cPoint, dPoint, length)};
        }
        return newPoints;
    }

    public static Point3d[] calculate3DCoordinates0(Point3d aPoint, int nwanted, double length) {
        Point3d[] points;
        if (nwanted == 1) {
            points = new Point3d[]{new Point3d(aPoint)};
            points[0].add(new Vector3d(length, 0.0, 0.0));
        } else if (nwanted == 2) {
            points = new Point3d[2];
            points[0] = new Point3d(aPoint);
            points[0].add(new Vector3d(length, 0.0, 0.0));
            points[1] = new Point3d(aPoint);
            points[1].add(new Vector3d(-length, 0.0, 0.0));
        } else if (nwanted == 3) {
            points = new Point3d[3];
            points[0] = new Point3d(aPoint);
            points[0].add(new Vector3d(length, 0.0, 0.0));
            points[1] = new Point3d(aPoint);
            points[1].add(new Vector3d(-length * 0.5, -length * 0.5 * Math.sqrt(3.0), 0.0));
            points[2] = new Point3d(aPoint);
            points[2].add(new Vector3d(-length * 0.5, length * 0.5 * Math.sqrt(3.0), 0.0));
        } else if (nwanted == 4) {
            points = new Point3d[4];
            double dx = length / Math.sqrt(3.0);
            points[0] = new Point3d(aPoint);
            points[0].add(new Vector3d(dx, dx, dx));
            points[1] = new Point3d(aPoint);
            points[1].add(new Vector3d(dx, -dx, -dx));
            points[2] = new Point3d(aPoint);
            points[2].add(new Vector3d(-dx, -dx, dx));
            points[3] = new Point3d(aPoint);
            points[3].add(new Vector3d(-dx, dx, -dx));
        } else {
            points = new Point3d[]{};
        }
        return points;
    }

    public static Point3d[] calculate3DCoordinates1(Point3d aPoint, Point3d bPoint, Point3d cPoint, int nwanted, double length, double angle) {
        Point3d[] points = new Point3d[nwanted];
        Vector3d ba = new Vector3d(aPoint);
        ba.sub(bPoint);
        ba.normalize();
        if (cPoint == null) {
            Vector3d cVector = AtomTools.getNonColinearVector(ba);
            cPoint = new Point3d(cVector);
        }
        Vector3d cb = new Vector3d(bPoint);
        cb.sub(cPoint);
        cb.normalize();
        double cbdotba = cb.dot(ba);
        if (cbdotba > 0.999999) {
            Vector3d cVector = AtomTools.getNonColinearVector(ba);
            cPoint = new Point3d(cVector);
            cb = new Vector3d(bPoint);
            cb.sub(cPoint);
        }
        Vector3d cbxba = new Vector3d();
        cbxba.cross(cb, ba);
        cbxba.normalize();
        Vector3d ax = new Vector3d();
        ax.cross(cbxba, ba);
        ax.normalize();
        double drot = Math.PI * 2 / (double)nwanted;
        for (int i = 0; i < nwanted; ++i) {
            double rot = (double)i * drot;
            points[i] = new Point3d(aPoint);
            Vector3d vx = new Vector3d(ba);
            vx.scale(-Math.cos(angle) * length);
            Vector3d vy = new Vector3d(ax);
            vy.scale(Math.cos(rot) * length);
            Vector3d vz = new Vector3d(cbxba);
            vz.scale(Math.sin(rot) * length);
            points[i].add(vx);
            points[i].add(vy);
            points[i].add(vz);
        }
        return points;
    }

    public static Point3d[] calculate3DCoordinates2(Point3d aPoint, Point3d bPoint, Point3d cPoint, int nwanted, double length, double angle) {
        Point3d[] newPoints = new Point3d[]{};
        double ang2 = angle / 2.0;
        Vector3d ba = new Vector3d(aPoint);
        ba.sub(bPoint);
        Vector3d ca = new Vector3d(aPoint);
        ca.sub(cPoint);
        Vector3d baxca = new Vector3d();
        baxca.cross(ba, ca);
        if (!(baxca.length() < 1.0E-8)) {
            if (nwanted == 1) {
                newPoints = new Point3d[1];
                Vector3d ax = new Vector3d(ba);
                ax.add(ca);
                ax.normalize();
                ax.scale(length);
                newPoints[0] = new Point3d(aPoint);
                newPoints[0].add(ax);
            } else if (nwanted == 2) {
                newPoints = new Point3d[2];
                Vector3d ax = new Vector3d(ba);
                ax.add(ca);
                ax.normalize();
                baxca.normalize();
                baxca.scale(Math.sin(ang2) * length);
                ax.scale(Math.cos(ang2) * length);
                newPoints[0] = new Point3d(aPoint);
                newPoints[0].add(ax);
                newPoints[0].add(baxca);
                newPoints[1] = new Point3d(aPoint);
                newPoints[1].add(ax);
                newPoints[1].sub(baxca);
            }
        }
        return newPoints;
    }

    public static Point3d calculate3DCoordinates3(Point3d focus, Point3d aNbor, Point3d bNbor, Point3d cNbor, double length) {
        Vector3d v1 = new Vector3d(focus);
        v1.sub(aNbor);
        Vector3d v2 = new Vector3d(focus);
        v2.sub(bNbor);
        Vector3d v3 = new Vector3d(focus);
        v3.sub(cNbor);
        Vector3d v = new Vector3d(v1);
        v.add(v2);
        v.add(v3);
        if (v.length() < 1.0E-5) {
            return null;
        }
        v.normalize();
        v.scale(length);
        Point3d point = new Point3d(focus);
        point.add(v);
        return point;
    }

    private static Vector3d getNonColinearVector(Vector3d ab) {
        Vector3d cr = new Vector3d();
        cr.cross(ab, XV);
        if (cr.length() > 1.0E-5) {
            return XV;
        }
        return YV;
    }
}

