/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Objects;
import org.openscience.cdk.graph.GreedyBasis;
import org.openscience.cdk.graph.InitialCycles;

public final class MinimumCycleBasis {
    private final GreedyBasis basis;
    final int[][] graph;

    public MinimumCycleBasis(int[][] graph) {
        this(new InitialCycles(Objects.requireNonNull(graph, "No graph provided")));
    }

    MinimumCycleBasis(InitialCycles initial) {
        this(initial, false);
    }

    MinimumCycleBasis(InitialCycles initial, boolean connected) {
        Objects.requireNonNull(initial, "No InitialCycles provided");
        this.graph = initial.graph();
        this.basis = new GreedyBasis(initial.numberOfCycles(), initial.numberOfEdges());
        int lim = connected ? initial.numberOfEdges() - this.graph.length + 1 : Integer.MAX_VALUE;
        for (InitialCycles.Cycle cycle : initial.cycles()) {
            if (this.basis.size() >= lim || !this.basis.isIndependent(cycle)) continue;
            this.basis.add(cycle);
        }
    }

    public int[][] paths() {
        int[][] paths = new int[this.size()][0];
        int i = 0;
        for (InitialCycles.Cycle c : this.basis.members()) {
            paths[i++] = c.path();
        }
        return paths;
    }

    public int size() {
        return this.basis.size();
    }
}

