/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openscience.cdk.group.IntegerInvariant;
import org.openscience.cdk.group.IntegerListInvariant;
import org.openscience.cdk.group.Invariant;
import org.openscience.cdk.group.Partition;
import org.openscience.cdk.group.Refinable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

class AtomRefinable
implements Refinable {
    private final IAtomContainer atomContainer;
    private int[][] connectionTable;
    private int[][] bondOrders;
    private final boolean ignoreElements;
    private final boolean ignoreBondOrders;
    private int maxBondOrder;

    public AtomRefinable(IAtomContainer atomContainer) {
        this(atomContainer, false, false);
    }

    public AtomRefinable(IAtomContainer atomContainer, boolean ignoreElements, boolean ignoreBondOrders) {
        this.atomContainer = atomContainer;
        this.ignoreElements = ignoreElements;
        this.ignoreBondOrders = ignoreBondOrders;
        this.setupConnectionTable(atomContainer);
    }

    @Override
    public Invariant neighboursInBlock(Set<Integer> block, int vertexIndex) {
        if (this.ignoreBondOrders || this.maxBondOrder == 1) {
            return this.getSimpleInvariant(block, vertexIndex);
        }
        return this.getMultipleInvariant(block, vertexIndex);
    }

    private Invariant getSimpleInvariant(Set<Integer> block, int vertexIndex) {
        int neighbours = 0;
        for (int connected : this.getConnectedIndices(vertexIndex)) {
            if (!block.contains(connected)) continue;
            ++neighbours;
        }
        return new IntegerInvariant(neighbours);
    }

    private Invariant getMultipleInvariant(Set<Integer> block, int vertexIndex) {
        int[] bondOrderCounts = new int[this.maxBondOrder];
        for (int connected : this.getConnectedIndices(vertexIndex)) {
            if (!block.contains(connected)) continue;
            int bondOrder = this.getConnectivity(vertexIndex, connected);
            int n = bondOrder - 1;
            bondOrderCounts[n] = bondOrderCounts[n] + 1;
        }
        return new IntegerListInvariant(bondOrderCounts);
    }

    @Override
    public int getVertexCount() {
        return this.atomContainer.getAtomCount();
    }

    @Override
    public int getConnectivity(int vertexI, int vertexJ) {
        int indexInRow;
        int maxRowIndex = this.connectionTable[vertexI].length;
        for (indexInRow = 0; indexInRow < maxRowIndex && this.connectionTable[vertexI][indexInRow] != vertexJ; ++indexInRow) {
        }
        if (this.ignoreBondOrders) {
            if (indexInRow < maxRowIndex) {
                return 1;
            }
            return 0;
        }
        if (indexInRow < maxRowIndex) {
            return this.bondOrders[vertexI][indexInRow];
        }
        return 0;
    }

    private int[] getConnectedIndices(int vertexIndex) {
        return this.connectionTable[vertexIndex];
    }

    @Override
    public Partition getInitialPartition() {
        if (this.ignoreElements) {
            int n = this.atomContainer.getAtomCount();
            return Partition.unit(n);
        }
        HashMap cellMap = new HashMap();
        int numberOfAtoms = this.atomContainer.getAtomCount();
        for (int atomIndex = 0; atomIndex < numberOfAtoms; ++atomIndex) {
            SortedSet<Integer> cell;
            String symbol = this.atomContainer.getAtom(atomIndex).getSymbol();
            if (cellMap.containsKey(symbol)) {
                cell = (SortedSet)cellMap.get(symbol);
            } else {
                cell = new TreeSet();
                cellMap.put(symbol, cell);
            }
            cell.add(atomIndex);
        }
        ArrayList atomSymbols = new ArrayList(cellMap.keySet());
        Collections.sort(atomSymbols);
        Partition elementPartition = new Partition();
        for (String key : atomSymbols) {
            SortedSet cell = (SortedSet)cellMap.get(key);
            elementPartition.addCell(cell);
        }
        return elementPartition;
    }

    private void setupConnectionTable(IAtomContainer atomContainer) {
        int atomCount = atomContainer.getAtomCount();
        this.connectionTable = new int[atomCount][];
        if (!this.ignoreBondOrders) {
            this.bondOrders = new int[atomCount][];
        }
        for (int atomIndex = 0; atomIndex < atomCount; ++atomIndex) {
            IAtom atom = atomContainer.getAtom(atomIndex);
            List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
            int numConnAtoms = connectedAtoms.size();
            this.connectionTable[atomIndex] = new int[numConnAtoms];
            if (!this.ignoreBondOrders) {
                this.bondOrders[atomIndex] = new int[numConnAtoms];
            }
            int i = 0;
            for (IAtom connected : connectedAtoms) {
                int index;
                this.connectionTable[atomIndex][i] = index = atomContainer.indexOf(connected);
                if (!this.ignoreBondOrders) {
                    int orderNumber;
                    IBond bond = atomContainer.getBond(atom, connected);
                    boolean isArom = bond.isAromatic();
                    this.bondOrders[atomIndex][i] = orderNumber = isArom ? 5 : bond.getOrder().numeric();
                    if (orderNumber > this.maxBondOrder) {
                        this.maxBondOrder = orderNumber;
                    }
                }
                ++i;
            }
        }
    }
}

