/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import org.openscience.cdk.hash.AbstractHashGenerator;
import org.openscience.cdk.hash.AtomEncoder;
import org.openscience.cdk.hash.AtomHashGenerator;
import org.openscience.cdk.hash.AtomSuppression;
import org.openscience.cdk.hash.Pseudorandom;
import org.openscience.cdk.hash.Suppressed;
import org.openscience.cdk.hash.Xorshift;
import org.openscience.cdk.interfaces.IAtomContainer;

final class SeedGenerator
extends AbstractHashGenerator
implements AtomHashGenerator {
    private final AtomEncoder encoder;
    private final AtomSuppression suppression;

    public SeedGenerator(AtomEncoder encoder) {
        this(encoder, new Xorshift(), AtomSuppression.unsuppressed());
    }

    public SeedGenerator(AtomEncoder encoder, AtomSuppression suppression) {
        this(encoder, new Xorshift(), suppression);
    }

    SeedGenerator(AtomEncoder encoder, Pseudorandom pseudorandom, AtomSuppression suppression) {
        super(pseudorandom);
        if (encoder == null) {
            throw new NullPointerException("encoder cannot be null");
        }
        if (suppression == null) {
            throw new NullPointerException("suppression cannot be null, use AtomSuppression.unsuppressed()");
        }
        this.encoder = encoder;
        this.suppression = suppression;
    }

    @Override
    public long[] generate(IAtomContainer container) {
        Suppressed suppressed = this.suppression.suppress(container);
        int n = container.getAtomCount();
        int m = n - suppressed.count();
        long seed = m > 1 ? (long)(9803 % m) : 1L;
        long[] hashes = new long[n];
        for (int i = 0; i < n; ++i) {
            int atomHash = this.encoder.encode(container.getAtom(i), container);
            hashes[i] = this.distribute(seed * (long)atomHash & Integer.MAX_VALUE);
        }
        return hashes;
    }
}

