/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiInputFromInchiOutput;
import io.github.dan2097.jnainchi.InchiOptions;
import io.github.dan2097.jnainchi.InchiStatus;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.InchiStereoType;
import io.github.dan2097.jnainchi.JnaInchi;
import java.util.HashMap;
import java.util.List;
import net.sf.jniinchi.INCHI_RET;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.inchi.InChIOptionParser;
import org.openscience.cdk.inchi.JniInchiSupport;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.ExtendedCisTrans;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class InChIToStructure {
    protected InchiInputFromInchiOutput output;
    protected InchiOptions options;
    protected IAtomContainer molecule;
    private static final int ISOTOPIC_SHIFT_FLAG = 10000;
    private static final int ISOTOPIC_SHIFT_THRESHOLD = 9900;
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(InChIToStructure.class);
    private static final int[] defaultElemMass = new int[]{0, 1, 4, 7, 9, 11, 12, 14, 16, 19, 20, 23, 24, 27, 28, 31, 32, 35, 40, 39, 40, 45, 48, 51, 52, 55, 56, 59, 59, 64, 65, 70, 73, 75, 79, 80, 84, 85, 88, 89, 91, 93, 96, 98, 101, 103, 106, 108, 112, 115, 119, 122, 128, 127, 131, 133, 137, 139, 140, 141, 144, 145, 150, 152, 157, 159, 163, 165, 167, 169, 173, 175, 178, 181, 184, 186, 190, 192, 195, 197, 201, 204, 207, 209, 209, 210, 222, 223, 226, 227, 232, 231, 238, 237, 244, 243, 247, 247, 251, 252, 257, 258, 259, 260, 261, 270, 269, 270, 270, 278, 281, 281, 285, 278, 289, 289, 293, 297, 294};

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, InchiOptions options) throws CDKException {
        if (inchi == null) {
            throw new IllegalArgumentException("Null InChI string provided");
        }
        if (options == null) {
            throw new IllegalArgumentException("Null options provided");
        }
        this.output = JnaInchi.getInchiInputFromInchi(inchi);
        this.options = options;
        this.generateAtomContainerFromInchi(builder);
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder) throws CDKException {
        this(inchi, builder, new InchiOptions.InchiOptionsBuilder().build());
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, String options) throws CDKException {
        this(inchi, builder, InChIOptionParser.parseString(options));
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, List<String> options) throws CDKException {
        this(inchi, builder, InChIOptionParser.parseStrings(options));
    }

    private void flip(IBond bond) {
        bond.setAtoms(new IAtom[]{bond.getEnd(), bond.getBegin()});
    }

    protected void generateAtomContainerFromInchi(IChemObjectBuilder builder) throws CDKException {
        InchiInput input = this.output.getInchiInput();
        this.molecule = builder.newInstance(IAtomContainer.class, new Object[0]);
        HashMap<Object, IAtom> inchiCdkAtomMap = new HashMap<Object, IAtom>();
        List<InchiAtom> atoms = input.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            InchiAtom iAt = atoms.get(i);
            IAtom cAt = builder.newInstance(IAtom.class, new Object[0]);
            inchiCdkAtomMap.put(iAt, cAt);
            cAt.setID("a" + i);
            int elem = Elements.ofString(iAt.getElName()).number();
            cAt.setAtomicNumber(elem);
            cAt.setFormalCharge(iAt.getCharge());
            cAt.setImplicitHydrogenCount(iAt.getImplicitHydrogen());
            int isotopicMass = iAt.getIsotopicMass();
            if (isotopicMass != 0) {
                if (isotopicMass > 9900) {
                    int delta = isotopicMass - 10000;
                    if (elem > 0 && elem < defaultElemMass.length) {
                        cAt.setMassNumber(defaultElemMass[elem] + delta);
                    } else {
                        this.logger.error("Cannot set mass delta for element {}, no base mass?", elem);
                    }
                } else {
                    cAt.setMassNumber(isotopicMass);
                }
            }
            this.molecule.addAtom(cAt);
            cAt = this.molecule.getAtom(this.molecule.getAtomCount() - 1);
            this.addHydrogenIsotopes(builder, cAt, 2, iAt.getImplicitDeuterium());
            this.addHydrogenIsotopes(builder, cAt, 3, iAt.getImplicitTritium());
        }
        List<InchiBond> bonds = input.getBonds();
        for (InchiBond iBo : bonds) {
            IBond cBo = builder.newInstance(IBond.class, new Object[0]);
            IAtom atO = (IAtom)inchiCdkAtomMap.get(iBo.getStart());
            IAtom atT = (IAtom)inchiCdkAtomMap.get(iBo.getEnd());
            cBo.setAtoms(new IAtom[]{atO, atT});
            InchiBondType type = iBo.getType();
            switch (type) {
                case SINGLE: {
                    cBo.setOrder(IBond.Order.SINGLE);
                    break;
                }
                case DOUBLE: {
                    cBo.setOrder(IBond.Order.DOUBLE);
                    break;
                }
                case TRIPLE: {
                    cBo.setOrder(IBond.Order.TRIPLE);
                    break;
                }
                case ALTERN: {
                    cBo.setIsInRing(true);
                    break;
                }
                default: {
                    throw new CDKException("Unknown bond type: " + (Object)((Object)type));
                }
            }
            InchiBondStereo stereo = iBo.getStereo();
            switch (stereo) {
                case NONE: {
                    cBo.setStereo(IBond.Stereo.NONE);
                    break;
                }
                case SINGLE_1DOWN: {
                    cBo.setStereo(IBond.Stereo.DOWN);
                    break;
                }
                case SINGLE_1UP: {
                    cBo.setStereo(IBond.Stereo.UP);
                    break;
                }
                case SINGLE_2DOWN: {
                    cBo.setStereo(IBond.Stereo.DOWN_INVERTED);
                    break;
                }
                case SINGLE_2UP: {
                    cBo.setStereo(IBond.Stereo.UP_INVERTED);
                    break;
                }
                case SINGLE_1EITHER: {
                    cBo.setStereo(IBond.Stereo.UP_OR_DOWN);
                    break;
                }
                case SINGLE_2EITHER: {
                    cBo.setStereo(IBond.Stereo.UP_OR_DOWN_INVERTED);
                }
            }
            this.molecule.addBond(cBo);
        }
        List<InchiStereo> stereos = input.getStereos();
        for (InchiStereo stereo0d : stereos) {
            if (stereo0d.getType() == InchiStereoType.Tetrahedral || stereo0d.getType() == InchiStereoType.Allene) {
                ITetrahedralChirality.Stereo stereo;
                InchiAtom central = stereo0d.getCentralAtom();
                InchiAtom[] neighbours = stereo0d.getAtoms();
                IAtom focus = (IAtom)inchiCdkAtomMap.get(central);
                IAtom[] neighbors = new IAtom[]{(IAtom)inchiCdkAtomMap.get(neighbours[0]), (IAtom)inchiCdkAtomMap.get(neighbours[1]), (IAtom)inchiCdkAtomMap.get(neighbours[2]), (IAtom)inchiCdkAtomMap.get(neighbours[3])};
                if (stereo0d.getParity() == InchiStereoParity.ODD) {
                    stereo = ITetrahedralChirality.Stereo.ANTI_CLOCKWISE;
                } else {
                    if (stereo0d.getParity() != InchiStereoParity.EVEN) continue;
                    stereo = ITetrahedralChirality.Stereo.CLOCKWISE;
                }
                IStereoElement stereoElement = null;
                if (stereo0d.getType() == InchiStereoType.Tetrahedral) {
                    stereoElement = builder.newInstance(ITetrahedralChirality.class, new Object[]{focus, neighbors, stereo});
                } else if (stereo0d.getType() == InchiStereoType.Allene) {
                    IAtom[] terminals;
                    IAtom[] peripherals = neighbors;
                    for (IAtom terminal : terminals = ExtendedTetrahedral.findTerminalAtoms(this.molecule, focus)) {
                        if (peripherals[1].equals(terminal)) {
                            peripherals[1] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[0]);
                            continue;
                        }
                        if (peripherals[2].equals(terminal)) {
                            peripherals[2] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[3]);
                            continue;
                        }
                        if (peripherals[0].equals(terminal)) {
                            peripherals[0] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[1]);
                            continue;
                        }
                        if (!peripherals[3].equals(terminal)) continue;
                        peripherals[3] = InChIToStructure.findOtherSinglyBonded(this.molecule, terminal, peripherals[2]);
                    }
                    stereoElement = new ExtendedTetrahedral(focus, peripherals, stereo);
                }
                assert (stereoElement != null);
                this.molecule.addStereoElement(stereoElement);
                continue;
            }
            if (stereo0d.getType() != InchiStereoType.DoubleBond) continue;
            boolean extended = false;
            InchiAtom[] neighbors = stereo0d.getAtoms();
            IAtom x = (IAtom)inchiCdkAtomMap.get(neighbors[0]);
            IAtom a = (IAtom)inchiCdkAtomMap.get(neighbors[1]);
            IAtom b = (IAtom)inchiCdkAtomMap.get(neighbors[2]);
            IAtom y = (IAtom)inchiCdkAtomMap.get(neighbors[3]);
            IBond stereoBond = this.molecule.getBond(a, b);
            if (stereoBond == null) {
                extended = true;
                Object tmp = null;
                stereoBond = ExtendedCisTrans.findCentralBond(this.molecule, a);
                if (stereoBond == null) continue;
                IAtom[] ends = ExtendedCisTrans.findTerminalAtoms(this.molecule, stereoBond);
                assert (ends != null);
                if (ends[0] != a) {
                    this.flip(stereoBond);
                }
            } else if (!stereoBond.getBegin().equals(a)) {
                this.flip(stereoBond);
            }
            int config = 2;
            if (stereo0d.getParity() == InchiStereoParity.EVEN) {
                config = 1;
            }
            if (extended) {
                this.molecule.addStereoElement(new ExtendedCisTrans(stereoBond, new IBond[]{this.molecule.getBond(x, a), this.molecule.getBond(b, y)}, config));
                continue;
            }
            this.molecule.addStereoElement(new DoubleBondStereochemistry(stereoBond, new IBond[]{this.molecule.getBond(x, a), this.molecule.getBond(b, y)}, config));
        }
    }

    private void addHydrogenIsotopes(IChemObjectBuilder builder, IAtom cAt, int mass, int count) {
        for (int j = 0; j < count; ++j) {
            IAtom deut = builder.newInstance(IAtom.class, new Object[0]);
            deut.setAtomicNumber(1);
            deut.setSymbol("H");
            deut.setMassNumber(mass);
            deut.setImplicitHydrogenCount(0);
            this.molecule.addAtom(deut);
            deut = this.molecule.getAtom(this.molecule.getAtomCount() - 1);
            IBond bond = builder.newInstance(IBond.class, new Object[]{cAt, deut, IBond.Order.SINGLE});
            this.molecule.addBond(bond);
        }
    }

    private static IAtom findOtherSinglyBonded(IAtomContainer container, IAtom atom, IAtom exclude) {
        for (IBond bond : container.getConnectedBondsList(atom)) {
            if (!IBond.Order.SINGLE.equals((Object)bond.getOrder()) || bond.contains(exclude)) continue;
            return bond.getOther(atom);
        }
        return atom;
    }

    public IAtomContainer getAtomContainer() {
        return this.molecule;
    }

    @Deprecated
    public INCHI_RET getReturnStatus() {
        return JniInchiSupport.toJniStatus(this.output.getStatus());
    }

    public InchiStatus getStatus() {
        return this.output.getStatus();
    }

    public String getMessage() {
        return this.output.getMessage();
    }

    public String getLog() {
        return this.output.getLog();
    }

    public long[][] getWarningFlags() {
        return this.output.getWarningFlags();
    }
}

