/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.MDLValence;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV3000Format;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.stereo.StereoElementFactory;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class MDLV3000Reader
extends DefaultChemObjectReader {
    private BooleanIOSetting optForce3d;
    private BooleanIOSetting optHydIso;
    private BooleanIOSetting optStereoPerc;
    private BooleanIOSetting optStereo0d;
    BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLV3000Reader.class);
    private final Pattern keyValueTuple;
    private final Pattern keyValueTuple2;
    private int lineNumber;

    public MDLV3000Reader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(Reader in, IChemObjectReader.Mode mode) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
        this.mode = mode;
        this.keyValueTuple = Pattern.compile("\\s*(\\w+)=([^\\s]*)(.*)");
        this.keyValueTuple2 = Pattern.compile("\\s*(\\w+)=\\(([^\\)]*)\\)(.*)");
        this.lineNumber = 0;
    }

    public MDLV3000Reader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLV3000Reader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLV3000Reader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return MDLV3000Format.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        this.lineNumber = 0;
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IAtomContainer) {
            return (T)this.readMolecule(object.getBuilder());
        }
        throw new CDKException("Only supports AtomContainer objects.");
    }

    public IAtomContainer readMolecule(IChemObjectBuilder builder) throws CDKException {
        return this.readConnectionTable(builder);
    }

    public IAtomContainer readConnectionTable(IChemObjectBuilder builder) throws CDKException {
        IAtomContainer readData;
        logger.info("Reading CTAB block");
        ReadState state = new ReadState();
        state.mol = readData = builder.newAtomContainer();
        state.chiral = false;
        boolean foundEND = false;
        String lastLine = this.readHeader(state);
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(lastLine);
            logger.debug("command found: " + command);
            if ("END CTAB".equals(command)) {
                foundEND = true;
            } else if (!"BEGIN CTAB".equals(command)) {
                if (command.startsWith("COUNTS ")) {
                    String[] counts = command.split(" ");
                    state.chiral = counts.length >= 6 && counts[5].equals("1");
                } else if ("BEGIN ATOM".equals(command)) {
                    this.readAtomBlock(state);
                } else if ("BEGIN BOND".equals(command)) {
                    this.readBondBlock(state);
                } else if ("BEGIN SGROUP".equals(command)) {
                    this.readSGroup(state);
                } else if ("BEGIN COLLECTION".equals(command)) {
                    this.readCollection(state);
                } else {
                    logger.warn("Unrecognized command: " + command);
                }
            }
            lastLine = this.readLine();
        }
        this.finalizeMol(state);
        return readData;
    }

    private void finalizeMol(ReadState state) {
        this.finalizeDimensions(state);
        IAtomContainer readData = state.mol;
        boolean isQuery = readData instanceof IQueryAtomContainer;
        for (IAtom atom : readData.atoms()) {
            int valence = 0;
            for (IBond bond : readData.getConnectedBondsList(atom)) {
                if (bond instanceof IQueryBond || bond.getOrder() == IBond.Order.UNSET) {
                    valence = -1;
                    break;
                }
                valence += bond.getOrder().numeric().intValue();
            }
            if (valence < 0) {
                isQuery = true;
                logger.warn("Cannot set valence for atom with query bonds");
                continue;
            }
            int unpaired = readData.getConnectedSingleElectronsCount(atom);
            this.applyMDLValenceModel(atom, valence + unpaired, unpaired);
        }
        if (!isQuery) {
            this.finalizeStereochemistry(state, readData);
        }
    }

    private void finalizeStereochemistry(ReadState state, IAtomContainer readData) {
        block11: {
            block12: {
                if (!this.optStereoPerc.isSet()) break block11;
                if (state.dimensions == 3) {
                    readData.setStereoElements(StereoElementFactory.using3DCoordinates(readData).createAll());
                } else if (state.dimensions == 2) {
                    readData.setStereoElements(StereoElementFactory.using2DCoordinates(readData).createAll());
                } else if (state.dimensions == 0 && this.optStereo0d.isSet()) {
                    for (Map.Entry entry : state.stereo0d.entrySet()) {
                        IStereoElement<IAtom, IAtom> stereoElement = MDLV2000Reader.createStereo0d(state.mol, (IAtom)entry.getKey(), (Integer)entry.getValue());
                        if (stereoElement == null) continue;
                        state.mol.addStereoElement(stereoElement);
                    }
                }
                if (state.stereoflags == null || state.stereoflags.isEmpty()) break block12;
                int defaultRacGrp = 0;
                if (!state.chiral) {
                    int n;
                    boolean bl = false;
                    for (Integer val : state.stereoflags.values()) {
                        int num;
                        if ((val & 0x30000) != 65536 || (num = val >>> 18) <= n) continue;
                        n = num;
                    }
                    defaultRacGrp = 0x10000 | n + true << 18;
                }
                for (IStereoElement se : readData.stereoElements()) {
                    IAtom focus;
                    if (se.getConfigClass() != 16896 || (focus = (IAtom)se.getFocus()).getID() == null) continue;
                    int idx = Integer.parseInt(focus.getID());
                    Integer grpinfo = state.stereoflags.get(idx);
                    if (grpinfo != null) {
                        se.setGroupInfo(grpinfo);
                        continue;
                    }
                    if (state.chiral) continue;
                    se.setGroupInfo(defaultRacGrp);
                }
                break block11;
            }
            if (state.chiral) break block11;
            for (IStereoElement iStereoElement : readData.stereoElements()) {
                if (iStereoElement.getConfigClass() != 16896) continue;
                iStereoElement.setGroupInfo(327680);
            }
        }
    }

    private void finalizeDimensions(ReadState state) {
        block7: {
            Point3d p3d;
            int dimensions;
            block6: {
                if (state.dimensions == 3 || this.optForce3d.isSet()) {
                    return;
                }
                dimensions = 0;
                for (IAtom atom : state.mol.atoms()) {
                    p3d = atom.getPoint3d();
                    if (p3d.z != 0.0) {
                        dimensions = 3;
                        break;
                    }
                    if (dimensions != 0 || p3d.x == 0.0 || p3d.y == 0.0) continue;
                    dimensions = 2;
                }
                if (dimensions == 0) {
                    dimensions = state.dimensions;
                }
                state.dimensions = dimensions;
                if (dimensions != 0) break block6;
                for (IAtom atom : state.mol.atoms()) {
                    atom.setPoint3d(null);
                }
                break block7;
            }
            if (dimensions != 2) break block7;
            for (IAtom atom : state.mol.atoms()) {
                p3d = atom.getPoint3d();
                atom.setPoint2d(new Point2d(p3d.x, p3d.y));
                atom.setPoint3d(null);
            }
        }
    }

    boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private void parseStereoGroup(Map<Integer, Integer> flags, String str, int type) {
        char ch;
        int i;
        int len = str.length();
        int num = 0;
        for (i = "MDLV30/STE???".length(); i < len && this.isDigit(ch = str.charAt(i)); ++i) {
            num = 10 * num + (ch - 48);
        }
        type |= num << 18;
        while (i < len && str.charAt(i) == ' ') {
            ++i;
        }
        if (str.startsWith("ATOMS=(", i)) {
            i += "ATOMS=(".length();
        }
        while (i < len && this.isDigit(str.charAt(i))) {
            ++i;
        }
        while (i < len && str.charAt(i) == ' ') {
            ++i;
        }
        while (i < len) {
            int val = 0;
            while (i < len && this.isDigit(ch = str.charAt(i))) {
                val = 10 * val + (ch - 48);
                ++i;
            }
            if (val > 0) {
                flags.put(val, type);
            }
            while (i < len && str.charAt(i) == ' ') {
                ++i;
            }
            if (i >= len || str.charAt(i) != ')') continue;
            break;
        }
    }

    private void readCollection(ReadState state) throws CDKException {
        String command;
        String line;
        if (state.stereoflags == null) {
            state.stereoflags = new HashMap<Integer, Integer>();
        }
        while ((line = this.readLine()) != null && !(command = this.readCommand(line)).startsWith("END COLLECTION")) {
            if (command.startsWith("MDLV30/STERAC")) {
                this.parseStereoGroup(state.stereoflags, command, 65536);
                continue;
            }
            if (command.startsWith("MDLV30/STEREL")) {
                this.parseStereoGroup(state.stereoflags, command, 131072);
                continue;
            }
            if (!command.startsWith("MDLV30/STEABS")) continue;
            this.parseStereoGroup(state.stereoflags, command, 0);
        }
    }

    private static int parseDimensions(String info) {
        if (info.startsWith("2D", 20)) {
            return 2;
        }
        if (info.startsWith("3D", 20)) {
            return 3;
        }
        return 0;
    }

    public String readHeader(ReadState state) throws CDKException {
        String line4;
        String line1 = this.readLine();
        if (line1 == null) {
            throw new CDKException("Expected a header line, but found nothing.");
        }
        if (line1.length() > 0) {
            if (line1.startsWith("M  V30")) {
                return line1;
            }
            state.mol.setTitle(line1);
        }
        String infoLine = this.readLine();
        state.dimensions = MDLV3000Reader.parseDimensions(infoLine);
        String line3 = this.readLine();
        if (line3.length() > 0) {
            state.mol.setProperty("cdk:Comment", line3);
        }
        if (!(line4 = this.readLine()).contains("3000")) {
            throw new CDKException("This file is not a MDL V3000 molfile.");
        }
        return this.readLine();
    }

    public void readAtomBlock(ReadState state) throws CDKException {
        IAtomContainer readData = state.mol;
        logger.info("Reading ATOM block");
        int RGroupCounter = 1;
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String id;
            String command = this.readCommand(this.readLine());
            if ("END ATOM".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug("Parsing atom from: " + command);
            IAtom atom = readData.getBuilder().newAtom();
            StringTokenizer tokenizer = new StringTokenizer(command);
            try {
                id = tokenizer.nextToken();
            }
            catch (Exception exception) {
                String error = "Error while parsing atom index";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            String element = tokenizer.nextToken();
            Elements e = Elements.ofString(element);
            if (e != Elements.Unknown) {
                atom.setAtomicNumber(e.number());
            } else if ("D".equals(element) && this.optHydIso.isSet()) {
                atom.setMassNumber(2);
                atom.setAtomicNumber(1);
            } else if ("T".equals(element) && this.optHydIso.isSet()) {
                atom.setMassNumber(3);
                atom.setAtomicNumber(1);
            } else if ("A".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("Q".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("*".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("LP".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if ("L".equals(element)) {
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else if (element.length() > 0 && element.charAt(0) == 'R') {
                logger.debug("Atom ", element, " is not an regular element. Creating a PseudoAtom.");
                String[] rGroup = element.split("^R");
                if (rGroup.length > 1) {
                    int Rnumber;
                    try {
                        RGroupCounter = Rnumber = Integer.parseInt(rGroup[rGroup.length - 1]);
                    }
                    catch (Exception ex) {
                        Rnumber = RGroupCounter++;
                    }
                    element = "R" + Rnumber;
                }
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
            } else {
                if (this.mode == IChemObjectReader.Mode.STRICT) {
                    throw new CDKException("Invalid element type. Must be an existing element, or one in: A, Q, L, LP, *.");
                }
                atom = readData.getBuilder().newInstance(IPseudoAtom.class, element);
                atom.setSymbol(element);
            }
            try {
                String xString = tokenizer.nextToken();
                String yString = tokenizer.nextToken();
                String zString = tokenizer.nextToken();
                double x = Double.parseDouble(xString);
                double y = Double.parseDouble(yString);
                double z = Double.parseDouble(zString);
                atom.setPoint3d(new Point3d(x, y, z));
            }
            catch (Exception exception) {
                String error = "Error while parsing atom coordinates";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            String mapping = tokenizer.nextToken();
            if (!mapping.equals("0")) {
                logger.warn("Skipping atom-atom mapping: " + mapping);
            }
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block25: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        switch (key) {
                            case "CFG": {
                                int cfg = Integer.parseInt(value);
                                if (cfg == 0) continue block25;
                                atom.setStereoParity(cfg);
                                state.stereo0d.put(atom, cfg);
                                break;
                            }
                            case "CHG": {
                                int charge = Integer.parseInt(value);
                                if (charge == 0) continue block25;
                                atom.setFormalCharge(charge);
                                break;
                            }
                            case "RAD": {
                                MDLV2000Writer.SPIN_MULTIPLICITY spinMultiplicity = MDLV2000Writer.SPIN_MULTIPLICITY.ofValue(Integer.parseInt(value));
                                int numElectons = spinMultiplicity.getSingleElectrons();
                                atom.setProperty("cdk:SpinMultiplicity", (Object)spinMultiplicity);
                                while (numElectons-- > 0) {
                                    readData.addSingleElectron(readData.getBuilder().newInstance(ISingleElectron.class, atom));
                                }
                                continue block25;
                            }
                            case "MASS": {
                                atom.setMassNumber(Integer.parseInt(value));
                                break;
                            }
                            case "VAL": {
                                if (!(atom instanceof IPseudoAtom)) {
                                    try {
                                        int valence = Integer.parseInt(value);
                                        if (valence == 0) continue block25;
                                        if (valence == 15) {
                                            atom.setValency(0);
                                            break;
                                        }
                                        atom.setValency(valence);
                                    }
                                    catch (Exception exception) {
                                        this.handleError("Could not parse valence information field", this.lineNumber, 0, 0, exception);
                                    }
                                    break;
                                }
                                logger.error("Cannot set valence information for a non-element!");
                                break;
                            }
                            default: {
                                logger.warn("Not parsing key: " + key);
                            }
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error(error);
                        logger.debug(exception);
                        throw new CDKException(error, exception);
                    }
                }
            }
            atom.setID(id);
            readData.addAtom(atom);
            state.addAtom(Integer.parseInt(id), readData.getAtom(readData.getAtomCount() - 1));
            logger.debug("Added atom: " + atom);
        }
    }

    public void readBondBlock(ReadState state) throws CDKException {
        IAtomContainer readData = state.mol;
        logger.info("Reading BOND block");
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String error;
            String command = this.readCommand(this.readLine());
            if ("END BOND".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug("Parsing bond from: " + command);
            StringTokenizer tokenizer = new StringTokenizer(command);
            IBond bond = readData.getBuilder().newBond();
            try {
                String indexString = tokenizer.nextToken();
                bond.setID(indexString);
            }
            catch (Exception exception) {
                error = "Error while parsing bond index";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            try {
                String orderString = tokenizer.nextToken();
                int order = Integer.parseInt(orderString);
                if (order >= 4) {
                    bond.setOrder(IBond.Order.UNSET);
                    logger.warn("Query order types are not supported (yet). File a bug if you need it");
                } else {
                    bond.setOrder(BondManipulator.createBondOrder(order));
                }
            }
            catch (Exception exception) {
                error = "Error while parsing bond index";
                logger.error(error);
                logger.debug(exception);
                throw new CDKException(error, exception);
            }
            try {
                String indexAtom1String = tokenizer.nextToken();
                int indexAtom1 = Integer.parseInt(indexAtom1String);
                IAtom atom1 = state.getAtom(indexAtom1);
                bond.setAtom(atom1, 0);
            }
            catch (Exception exception) {
                String error2 = "Error while parsing index atom 1 in bond";
                logger.error(error2);
                logger.debug(exception);
                throw new CDKException(error2, exception);
            }
            try {
                String indexAtom2String = tokenizer.nextToken();
                int indexAtom2 = Integer.parseInt(indexAtom2String);
                IAtom atom2 = state.getAtom(indexAtom2);
                bond.setAtom(atom2, 1);
            }
            catch (Exception exception) {
                String error3 = "Error while parsing index atom 2 in bond";
                logger.error(error3);
                logger.debug(exception);
                throw new CDKException(error3, exception);
            }
            ArrayList<IAtom> endpts = new ArrayList<IAtom>();
            String attach = null;
            if (command.indexOf(61) != -1) {
                Map<String, String> options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
                block21: for (String key : options.keySet()) {
                    String value = options.get(key);
                    try {
                        switch (key) {
                            case "CFG": {
                                int configuration = Integer.parseInt(value);
                                if (configuration == 0) {
                                    bond.setStereo(IBond.Stereo.NONE);
                                    break;
                                }
                                if (configuration == 1) {
                                    bond.setStereo(IBond.Stereo.UP);
                                    break;
                                }
                                if (configuration == 2) {
                                    bond.setStereo(IBond.Stereo.UP_OR_DOWN);
                                    break;
                                }
                                if (configuration != 3) continue block21;
                                bond.setStereo(IBond.Stereo.DOWN);
                                break;
                            }
                            case "ENDPTS": {
                                String[] endptStr = value.split(" ");
                                for (int i = 1; i < endptStr.length; ++i) {
                                    endpts.add(readData.getAtom(Integer.parseInt(endptStr[i]) - 1));
                                }
                                continue block21;
                            }
                            case "ATTACH": {
                                attach = value;
                                break;
                            }
                            default: {
                                logger.warn("Not parsing key: " + key);
                            }
                        }
                    }
                    catch (Exception exception) {
                        String error4 = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error(error4);
                        logger.debug(exception);
                        throw new CDKException(error4, exception);
                    }
                }
            }
            readData.addBond(bond);
            state.addBond(Integer.parseInt(bond.getID()), readData.getBond(readData.getBondCount() - 1));
            if ("ANY".equals(attach)) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtMulticenter);
                sgroup.addAtom(bond.getBegin());
                sgroup.addBond(bond);
                for (IAtom endpt : endpts) {
                    sgroup.addAtom(endpt);
                }
                ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)readData.getProperty("cdk:CtabSgroups");
                if (sgroups == null) {
                    sgroups = new ArrayList<Sgroup>(4);
                    readData.setProperty("cdk:CtabSgroups", sgroups);
                }
                sgroups.add(sgroup);
            }
            logger.debug("Added bond: " + bond);
        }
    }

    public void readSGroup(ReadState state) throws CDKException {
        IAtomContainer readData = state.mol;
        boolean foundEND = false;
        while (this.isReady() && !foundEND) {
            String command = this.readCommand(this.readLine());
            if ("END SGROUP".equals(command)) {
                foundEND = true;
                continue;
            }
            logger.debug("Parsing Sgroup line: " + command);
            StringTokenizer tokenizer = new StringTokenizer(command);
            String indexString = tokenizer.nextToken();
            logger.warn("Skipping external index: " + indexString);
            String type = tokenizer.nextToken();
            String externalIndexString = tokenizer.nextToken();
            logger.warn("Skipping external index: " + externalIndexString);
            Map<Object, Object> options = new Hashtable();
            if (command.indexOf(61) != -1) {
                options = this.parseOptions(this.exhaustStringTokenizer(tokenizer));
            }
            Sgroup sgroup = new Sgroup();
            if (type.startsWith("SUP")) {
                sgroup.setType(SgroupType.CtabAbbreviation);
                Iterator<Object> keys = options.keySet().iterator();
                String label = "";
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = (String)options.get(key);
                    try {
                        int nExpected;
                        if (key.equals("ATOMS")) {
                            StringTokenizer atomsTokenizer = new StringTokenizer(value);
                            nExpected = Integer.parseInt(atomsTokenizer.nextToken());
                            while (atomsTokenizer.hasMoreTokens()) {
                                sgroup.addAtom(state.getAtom(Integer.parseInt(atomsTokenizer.nextToken())));
                            }
                        } else if (key.equals("XBONDS")) {
                            StringTokenizer xbonds = new StringTokenizer(value);
                            nExpected = Integer.parseInt(xbonds.nextToken());
                            while (xbonds.hasMoreTokens()) {
                                sgroup.addBond(state.getBond(Integer.parseInt(xbonds.nextToken())));
                            }
                        } else if (key.equals("LABEL")) {
                            label = value;
                        } else {
                            logger.warn("Not parsing key: " + key);
                        }
                    }
                    catch (Exception exception) {
                        String error = "Error while parsing key/value " + key + "=" + value + ": " + exception.getMessage();
                        logger.error(error);
                        logger.debug(exception);
                        throw new CDKException(error, exception);
                    }
                    if (sgroup.getAtoms().isEmpty() || label.length() <= 0) continue;
                    sgroup.setSubscript(label);
                }
                ArrayList<Sgroup> sgroups = (ArrayList<Sgroup>)readData.getProperty("cdk:CtabSgroups");
                if (sgroups == null) {
                    sgroups = new ArrayList<Sgroup>();
                }
                sgroups.add(sgroup);
                readData.setProperty("cdk:CtabSgroups", sgroups);
                continue;
            }
            logger.warn("Skipping unrecognized SGROUP type: " + type);
        }
    }

    private String readCommand(String line) throws CDKException {
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand(this.readLine());
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    private Map<String, String> parseOptions(String string) throws CDKException {
        Hashtable<String, String> keyValueTuples = new Hashtable<String, String>();
        while (string.length() >= 3) {
            logger.debug("Matching remaining option string: " + string);
            Matcher tuple1Matcher = this.keyValueTuple2.matcher(string);
            if (tuple1Matcher.matches()) {
                String key = tuple1Matcher.group(1);
                String value = tuple1Matcher.group(2);
                string = tuple1Matcher.group(3);
                logger.debug("Found key: " + key);
                logger.debug("Found value: " + value);
                keyValueTuples.put(key, value);
                continue;
            }
            Matcher tuple2Matcher = this.keyValueTuple.matcher(string);
            if (tuple2Matcher.matches()) {
                String key = tuple2Matcher.group(1);
                String value = tuple2Matcher.group(2);
                string = tuple2Matcher.group(3);
                logger.debug("Found key: " + key);
                logger.debug("Found value: " + value);
                keyValueTuples.put(key, value);
                continue;
            }
            logger.warn("Quiting; could not parse: " + string + ".");
            string = "";
        }
        return keyValueTuples;
    }

    public String exhaustStringTokenizer(StringTokenizer tokenizer) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(' ');
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken());
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public String readLine() throws CDKException {
        String line;
        try {
            line = this.input.readLine();
            ++this.lineNumber;
            logger.debug("read line " + this.lineNumber + ":", line);
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        return line;
    }

    public boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
        this.optForce3d = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("ForceReadAs3DCoordinates", IOSetting.Importance.LOW, "Should coordinates always be read as 3D?", "false"));
        this.optHydIso = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("InterpretHydrogenIsotopes", IOSetting.Importance.LOW, "Should D and T be interpreted as hydrogen isotopes?", "true"));
        this.optStereoPerc = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("AddStereoElements", IOSetting.Importance.LOW, "Detect and create IStereoElements for the input.", "true"));
        this.optStereo0d = (BooleanIOSetting)this.addSetting(new BooleanIOSetting("AddStereo0d", IOSetting.Importance.LOW, "Allow stereo created from parity value when no coordinates", "true"));
    }

    private void applyMDLValenceModel(IAtom atom, int explicitValence, int unpaired) {
        if (atom.getValency() != null) {
            if (atom.getValency() >= explicitValence) {
                atom.setImplicitHydrogenCount(atom.getValency() - (explicitValence - unpaired));
            } else {
                atom.setImplicitHydrogenCount(0);
            }
        } else {
            int implicitValence;
            Integer charge;
            Integer element = atom.getAtomicNumber();
            if (element == null) {
                element = 0;
            }
            if ((charge = atom.getFormalCharge()) == null) {
                charge = 0;
            }
            if ((implicitValence = MDLValence.implicitValence(element, charge, explicitValence)) < explicitValence) {
                atom.setValency(explicitValence);
                atom.setImplicitHydrogenCount(0);
            } else {
                atom.setValency(implicitValence);
                atom.setImplicitHydrogenCount(implicitValence - explicitValence);
            }
        }
    }

    private static final class ReadState {
        IAtomContainer mol;
        int dimensions = 0;
        boolean chiral;
        Map<Integer, Integer> stereoflags = null;
        final Map<IAtom, Integer> stereo0d = new HashMap<IAtom, Integer>();
        IAtom[] atomById = new IAtom[64];
        IBond[] bondById = new IBond[64];

        private ReadState() {
        }

        <T> T[] grow(T[] arr, int req) {
            int cap = arr.length;
            return Arrays.copyOf(arr, Math.max(cap + cap >> 1, req + 1));
        }

        void addAtom(int id, IAtom atom) {
            if (id >= this.atomById.length) {
                this.atomById = this.grow(this.atomById, id);
            }
            this.atomById[id] = atom;
        }

        void addBond(int id, IBond bond) {
            if (id >= this.bondById.length) {
                this.bondById = this.grow(this.bondById, id);
            }
            this.bondById[id] = bond;
        }

        public IAtom getAtom(int i) {
            return this.atomById[i];
        }

        public IBond getBond(int i) {
            return this.bondById[i];
        }
    }
}

