/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.util.HashMap;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

final class MDLValence {
    private MDLValence() {
    }

    static IAtomContainer apply(IAtomContainer container) {
        int n = container.getAtomCount();
        int[] valences = new int[n];
        HashMap<IAtom, Integer> atomToIndex = new HashMap<IAtom, Integer>(2 * n);
        for (IAtom atom : container.atoms()) {
            atomToIndex.put(atom, atomToIndex.size());
        }
        for (IBond bond : container.bonds()) {
            int u = (Integer)atomToIndex.get(bond.getBegin());
            int v = (Integer)atomToIndex.get(bond.getEnd());
            int bondOrder = bond.getOrder().numeric();
            int n2 = u;
            valences[n2] = valences[n2] + bondOrder;
            int n3 = v;
            valences[n3] = valences[n3] + bondOrder;
        }
        for (int i = 0; i < n; ++i) {
            IAtom atom;
            atom = container.getAtom(i);
            Integer charge = atom.getFormalCharge();
            Integer element = atom.getAtomicNumber();
            if (element == null) continue;
            charge = charge == null ? 0 : charge;
            int explicit = valences[i];
            if (atom.getValency() != null) {
                atom.setImplicitHydrogenCount(atom.getValency() - explicit);
                continue;
            }
            int implicit = MDLValence.implicitValence(element, charge, valences[i]);
            atom.setImplicitHydrogenCount(implicit - explicit);
            atom.setValency(implicit);
        }
        return container;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static int implicitValence(int elem, int q, int val) {
        switch (elem) {
            case 1: 
            case 3: 
            case 11: 
            case 19: 
            case 37: 
            case 55: 
            case 87: {
                if (q != 0 || val > 1) return val;
                return 1;
            }
            case 4: 
            case 12: 
            case 20: 
            case 38: 
            case 56: 
            case 88: {
                switch (q) {
                    case 0: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 1: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 5: {
                switch (q) {
                    case -4: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case -3: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 6: {
                switch (q) {
                    case -3: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case -2: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 7: {
                switch (q) {
                    case -2: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case -1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 8: {
                switch (q) {
                    case -1: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case 0: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 9: {
                switch (q) {
                    case 0: {
                        if (val > 1) return val;
                        return 1;
                    }
                    case 1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 13: {
                switch (q) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 1: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 14: {
                switch (q) {
                    case -3: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 15: {
                switch (q) {
                    case -2: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 16: {
                switch (q) {
                    case -1: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 17: {
                switch (q) {
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 2) return val;
                        return 2;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 31: {
                switch (q) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 32: {
                switch (q) {
                    case -3: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 33: {
                switch (q) {
                    case -2: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 34: {
                switch (q) {
                    case -1: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 35: {
                switch (q) {
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 49: {
                switch (q) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 2: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 50: 
            case 82: {
                switch (q) {
                    case -3: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 1: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 3: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 51: 
            case 83: {
                switch (q) {
                    case -2: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 0: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 2: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 4: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 52: 
            case 84: {
                switch (q) {
                    case -1: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 0: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 1: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 2: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 3: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 5: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 53: 
            case 85: {
                switch (q) {
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case 1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case 2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case 3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 4: {
                        if (val > 3) return val;
                        return 3;
                    }
                    case 6: {
                        if (val > 1) return val;
                        return 1;
                    }
                }
                return val;
            }
            case 81: {
                switch (q) {
                    case -4: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val <= 3) {
                            return 3;
                        }
                        if (val <= 5) {
                            return 5;
                        }
                        if (val > 7) return val;
                        return 7;
                    }
                    case -3: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val <= 4) {
                            return 4;
                        }
                        if (val > 6) return val;
                        return 6;
                    }
                    case -2: {
                        if (val <= 3) {
                            return 3;
                        }
                        if (val > 5) return val;
                        return 5;
                    }
                    case -1: {
                        if (val <= 2) {
                            return 2;
                        }
                        if (val > 4) return val;
                        return 4;
                    }
                    case 0: {
                        if (val <= 1) {
                            return 1;
                        }
                        if (val > 3) return val;
                        return 3;
                    }
                }
            }
        }
        return val;
    }
}

