/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.FormatFactory;
import org.openscience.cdk.io.ISimpleChemObjectReader;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class ReaderFactory {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ReaderFactory.class);
    private FormatFactory formatFactory;
    private int headerLength;

    public ReaderFactory() {
        this(8192);
    }

    public ReaderFactory(int headerLength) {
        this.formatFactory = new FormatFactory(headerLength);
        this.headerLength = headerLength;
    }

    public void registerFormat(IChemFormatMatcher format) {
        this.formatFactory.registerFormat(format);
    }

    public List<IChemFormatMatcher> getFormats() {
        return this.formatFactory.getFormats();
    }

    public ISimpleChemObjectReader createReader(InputStream input) throws IOException {
        ISimpleChemObjectReader reader;
        if (input instanceof GZIPInputStream) {
            IChemFormat format = this.formatFactory.guessFormat(input);
            reader = this.createReader(format);
            if (reader != null) {
                try {
                    reader.setReader(input);
                }
                catch (CDKException e1) {
                    IOException wrapper = new IOException("Exception while setting the InputStream: " + e1.getMessage());
                    wrapper.initCause(e1);
                    throw wrapper;
                }
            }
        } else {
            IChemFormat format;
            BufferedInputStream bistream;
            BufferedInputStream istreamToRead = bistream = new BufferedInputStream(input, this.headerLength);
            bistream.mark(5);
            byte[] abMagic = new byte[4];
            int countRead = bistream.read(abMagic, 0, 4);
            bistream.reset();
            if (countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117) {
                istreamToRead = new BufferedInputStream(new GZIPInputStream(bistream));
            }
            if ((reader = this.createReader(format = this.formatFactory.guessFormat(istreamToRead))) != null) {
                try {
                    reader.setReader(istreamToRead);
                }
                catch (CDKException e1) {
                    IOException wrapper = new IOException("Exception while setting the InputStream: " + e1.getMessage());
                    wrapper.initCause(e1);
                    throw wrapper;
                }
            }
        }
        return reader;
    }

    public ISimpleChemObjectReader createReader(IChemFormat format) {
        block6: {
            if (format != null) {
                String readerClassName = format.getReaderClassName();
                if (readerClassName != null) {
                    try {
                        return (ISimpleChemObjectReader)this.getClass().getClassLoader().loadClass(readerClassName).newInstance();
                    }
                    catch (ClassNotFoundException exception) {
                        logger.error("Could not find this ChemObjectReader: ", readerClassName);
                        logger.debug(exception);
                        break block6;
                    }
                    catch (IllegalAccessException | InstantiationException exception) {
                        logger.error("Could not create this ChemObjectReader: ", readerClassName);
                        logger.debug(exception);
                        break block6;
                    }
                }
                logger.warn("ChemFormat is recognized, but no reader is available.");
            } else {
                logger.warn("ChemFormat is not recognized.");
            }
        }
        return null;
    }

    public ISimpleChemObjectReader createReader(Reader input) throws IOException {
        if (!(input instanceof BufferedReader)) {
            input = new BufferedReader(input);
        }
        IChemFormat chemFormat = this.formatFactory.guessFormat(input);
        ISimpleChemObjectReader coReader = this.createReader(chemFormat);
        try {
            coReader.setReader(input);
        }
        catch (Exception exception) {
            logger.error("Could not set the Reader source: ", exception.getMessage());
            logger.debug(exception);
        }
        return coReader;
    }
}

