/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.XYZFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class XYZReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(XYZReader.class);

    public XYZReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public XYZReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public XYZReader() {
        this(new StringReader(""));
    }

    @Override
    public IResourceFormat getFormat() {
        return XYZFormat.getInstance();
    }

    @Override
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IChemFile.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IChemFile.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile file) {
        IChemSequence chemSequence = file.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t ,;");
                String token = tokenizer.nextToken();
                int number_of_atoms = Integer.parseInt(token);
                String info = this.input.readLine();
                IChemModel chemModel = file.getBuilder().newInstance(IChemModel.class, new Object[0]);
                IAtomContainerSet setOfMolecules = file.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                IAtomContainer m = file.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                m.setTitle(info);
                for (int i = 0; i < number_of_atoms && (line = this.input.readLine()) != null; ++i) {
                    if (line.startsWith("#") && line.length() > 1) {
                        Object comment = m.getProperty("cdk:Comment");
                        if (comment == null) {
                            comment = "";
                        }
                        comment = comment + line.substring(1).trim();
                        m.setProperty("cdk:Comment", comment);
                        logger.debug("Found and set comment: ", comment);
                        --i;
                        continue;
                    }
                    double charge = 0.0;
                    tokenizer = new StringTokenizer(line, "\t ,;");
                    int fields = tokenizer.countTokens();
                    if (fields < 4) continue;
                    String atomtype = tokenizer.nextToken();
                    double x = new Double(tokenizer.nextToken());
                    double y = new Double(tokenizer.nextToken());
                    double z = new Double(tokenizer.nextToken());
                    if (fields == 8) {
                        charge = new Double(tokenizer.nextToken());
                    }
                    IAtom atom = file.getBuilder().newInstance(IAtom.class, atomtype, new Point3d(x, y, z));
                    atom.setCharge(charge);
                    m.addAtom(atom);
                }
                setOfMolecules.addAtomContainer(m);
                chemModel.setMoleculeSet(setOfMolecules);
                chemSequence.addChemModel(chemModel);
                line = this.input.readLine();
            }
            file.addChemSequence(chemSequence);
        }
        catch (IOException e) {
            file = null;
            logger.error("Error while reading file: ", e.getMessage());
            logger.debug(e);
        }
        return file;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

