/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.Hashtable;
import java.util.Map;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLModuleStack;
import org.openscience.cdk.io.cml.CMLReactionModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.io.cml.JMOLANIMATIONConvention;
import org.openscience.cdk.io.cml.MDLMolConvention;
import org.openscience.cdk.io.cml.OtherNamespace;
import org.openscience.cdk.io.cml.PDBConvention;
import org.openscience.cdk.io.cml.PMPConvention;
import org.openscience.cdk.io.cml.QSARConvention;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class CMLHandler
extends DefaultHandler {
    private ICMLModule conv;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLHandler.class);
    private final boolean debug = true;
    private final Map<String, ICMLModule> userConventions;
    private final CMLStack xpath;
    private final CMLStack conventionStack;
    private final CMLModuleStack moduleStack;

    public CMLHandler(IChemFile chemFile) {
        this.conv = new CMLCoreModule(chemFile);
        this.userConventions = new Hashtable<String, ICMLModule>();
        this.xpath = new CMLStack();
        this.conventionStack = new CMLStack();
        this.moduleStack = new CMLModuleStack();
    }

    public void registerConvention(String convention, ICMLModule conv) {
        this.userConventions.put(convention, conv);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        logger.debug(new String(ch, start, length));
        this.conv.characterData(this.xpath, ch, start, length);
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {
    }

    @Override
    public void endDocument() {
        this.conv.endDocument();
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        logger.debug("</" + raw + ">");
        this.conv.endElement(this.xpath, uri, local, raw);
        this.xpath.pop();
        this.conventionStack.pop();
        this.moduleStack.pop();
        this.conv = this.moduleStack.current();
    }

    @Override
    public void startDocument() {
        this.conv.startDocument();
        this.conventionStack.push("CML");
        this.moduleStack.push(this.conv);
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes atts) {
        this.xpath.push(local);
        logger.debug("<", raw, "> -> ", this.xpath);
        if (local.startsWith("reaction")) {
            logger.info("Detected CRML module");
            if (!this.conventionStack.current().equals("CMLR")) {
                this.conv = new CMLReactionModule(this.conv);
            }
            this.conventionStack.push("CMLR");
        } else if (uri == null || uri.length() == 0 || uri.startsWith("http://www.xml-cml.org/")) {
            String convName = "";
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("convention")) continue;
                convName = atts.getValue(i);
            }
            if (convName.length() > 0) {
                if (convName.equals(this.conventionStack.current())) {
                    logger.debug("Same convention as parent");
                } else {
                    logger.info("New Convention: ", convName);
                    if (!convName.equals("CML")) {
                        if (convName.equals("PDB")) {
                            this.conv = new PDBConvention(this.conv);
                        } else if (convName.equals("PMP")) {
                            this.conv = new PMPConvention(this.conv);
                        } else if (convName.equals("MDLMol")) {
                            logger.debug("MDLMolConvention instantiated...");
                            this.conv = new MDLMolConvention(this.conv);
                        } else if (convName.equals("JMOL-ANIMATION")) {
                            this.conv = new JMOLANIMATIONConvention(this.conv);
                        } else if (convName.equals("qsar:DescriptorValue")) {
                            this.conv = new QSARConvention(this.conv);
                        } else if (this.userConventions.containsKey(convName)) {
                            ICMLModule newconv = this.userConventions.get(convName);
                            newconv.inherit(this.conv);
                            this.conv = newconv;
                        } else {
                            logger.warn("Detected unknown convention: ", convName);
                        }
                    }
                }
                this.conventionStack.push(convName);
            } else {
                this.conventionStack.push(this.conventionStack.current());
            }
        } else {
            this.conv = new OtherNamespace();
            this.conventionStack.push("Other");
        }
        this.moduleStack.push(this.conv);
        logger.debug("ConventionStack: ", this.conventionStack);
        this.conv.startElement(this.xpath, uri, local, raw, atts);
    }
}

