/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryChemObject;

public class QueryAtomContainer
extends QueryChemObject
implements IQueryAtomContainer {
    private static final long serialVersionUID = -1876912362585898476L;
    protected int atomCount;
    protected int bondCount;
    protected int lonePairCount;
    protected int singleElectronCount;
    protected int growArraySize = 10;
    protected IAtom[] atoms;
    protected IBond[] bonds;
    protected ILonePair[] lonePairs;
    protected ISingleElectron[] singleElectrons;
    protected final List<IStereoElement> stereoElements;

    @Override
    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("QueryAtomContainer(");
        s.append(this.hashCode());
        s.append(", #A:").append(this.getAtomCount());
        s.append(", #EC:").append(this.getElectronContainerCount());
        for (i = 0; i < this.getAtomCount(); ++i) {
            s.append(", ").append(this.getAtom(i).toString());
        }
        for (i = 0; i < this.getBondCount(); ++i) {
            s.append(", ").append(this.getBond(i).toString());
        }
        for (i = 0; i < this.getLonePairCount(); ++i) {
            s.append(", ").append(this.getLonePair(i).toString());
        }
        for (i = 0; i < this.getSingleElectronCount(); ++i) {
            s.append(", ").append(this.getSingleElectron(i).toString());
        }
        s.append(')');
        return s.toString();
    }

    public QueryAtomContainer(IChemObjectBuilder builder) {
        this(10, 10, 0, 0, builder);
    }

    public QueryAtomContainer(IAtomContainer container, IChemObjectBuilder builder) {
        super(builder);
        int f;
        this.atomCount = container.getAtomCount();
        this.bondCount = container.getBondCount();
        this.lonePairCount = container.getLonePairCount();
        this.singleElectronCount = container.getSingleElectronCount();
        this.atoms = new IAtom[this.atomCount];
        this.bonds = new IBond[this.bondCount];
        this.lonePairs = new ILonePair[this.lonePairCount];
        this.singleElectrons = new ISingleElectron[this.singleElectronCount];
        this.stereoElements = new ArrayList<IStereoElement>(this.atomCount / 2);
        for (f = 0; f < container.getAtomCount(); ++f) {
            this.atoms[f] = container.getAtom(f);
            container.getAtom(f).addListener(this);
        }
        for (f = 0; f < this.bondCount; ++f) {
            this.bonds[f] = container.getBond(f);
            container.getBond(f).addListener(this);
        }
        for (f = 0; f < this.lonePairCount; ++f) {
            this.lonePairs[f] = container.getLonePair(f);
            container.getLonePair(f).addListener(this);
        }
        for (f = 0; f < this.singleElectronCount; ++f) {
            this.singleElectrons[f] = container.getSingleElectron(f);
            container.getSingleElectron(f).addListener(this);
        }
    }

    public QueryAtomContainer(int atomCount, int bondCount, int lpCount, int seCount, IChemObjectBuilder builder) {
        super(builder);
        this.atomCount = 0;
        this.bondCount = 0;
        this.lonePairCount = 0;
        this.singleElectronCount = 0;
        this.atoms = new IAtom[atomCount];
        this.bonds = new IBond[bondCount];
        this.lonePairs = new ILonePair[lpCount];
        this.singleElectrons = new ISingleElectron[seCount];
        this.stereoElements = new ArrayList<IStereoElement>(atomCount / 2);
    }

    @Override
    public void addStereoElement(IStereoElement element) {
        this.stereoElements.add(element);
    }

    @Override
    public Iterable<IStereoElement> stereoElements() {
        return new Iterable<IStereoElement>(){

            @Override
            public Iterator<IStereoElement> iterator() {
                return QueryAtomContainer.this.stereoElements.iterator();
            }
        };
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        for (IAtom atom : atoms) {
            atom.addListener(this);
        }
        this.atomCount = atoms.length;
        this.notifyChanged();
    }

    @Override
    public void setBonds(IBond[] bonds) {
        this.bonds = bonds;
        for (IBond bond : bonds) {
            bond.addListener(this);
        }
        this.bondCount = bonds.length;
    }

    @Override
    public void setAtom(int idx, IAtom atom) {
        if (idx >= this.atomCount) {
            throw new IndexOutOfBoundsException("No atom at index: " + idx);
        }
        int aidx = this.indexOf(atom);
        if (aidx >= 0) {
            throw new IllegalArgumentException("Atom already in container at index: " + idx);
        }
        IAtom oldAtom = this.atoms[idx];
        this.atoms[idx] = atom;
        atom.addListener(this);
        oldAtom.removeListener(this);
        for (IBond bond : this.bonds()) {
            for (int i = 0; i < bond.getAtomCount(); ++i) {
                if (!oldAtom.equals(bond.getAtom(i))) continue;
                bond.setAtom(atom, i);
            }
        }
        for (ISingleElectron ec : this.singleElectrons()) {
            if (!oldAtom.equals(ec.getAtom())) continue;
            ec.setAtom(atom);
        }
        for (ILonePair lp : this.lonePairs()) {
            if (!oldAtom.equals(lp.getAtom())) continue;
            lp.setAtom(atom);
        }
        ArrayList<IStereoElement> oldStereo = null;
        ArrayList<IStereoElement> newStereo = null;
        for (IStereoElement se : this.stereoElements()) {
            if (!se.contains(oldAtom)) continue;
            if (oldStereo == null) {
                oldStereo = new ArrayList<IStereoElement>();
                newStereo = new ArrayList<IStereoElement>();
            }
            oldStereo.add(se);
            Map<IAtom, IAtom> amap = Collections.singletonMap(oldAtom, atom);
            Map<IBond, IBond> bmap = Collections.emptyMap();
            newStereo.add(se.map(amap, bmap));
        }
        if (oldStereo != null) {
            this.stereoElements.removeAll(oldStereo);
            this.stereoElements.addAll(newStereo);
        }
        this.notifyChanged();
    }

    @Override
    public IAtom getAtom(int idx) {
        if (idx < 0 || idx >= this.atomCount) {
            throw new IndexOutOfBoundsException("Atom index out of bounds: 0 <= " + idx + " < " + this.atomCount);
        }
        return this.atoms[idx];
    }

    @Override
    public IBond getBond(int idx) {
        if (idx < 0 || idx >= this.bondCount) {
            throw new IndexOutOfBoundsException("Bond index out of bounds: 0 <= " + idx + " < " + this.bondCount);
        }
        return this.bonds[idx];
    }

    @Override
    public ILonePair getLonePair(int idx) {
        if (idx < 0 || idx >= this.lonePairCount) {
            throw new IndexOutOfBoundsException("Lone Pair index out of bounds: 0 <= " + idx + " < " + this.lonePairCount);
        }
        return this.lonePairs[idx];
    }

    @Override
    public ISingleElectron getSingleElectron(int idx) {
        if (idx < 0 || idx >= this.singleElectronCount) {
            throw new IndexOutOfBoundsException("Single Electrong index out of bounds: 0 <= " + idx + " < " + this.singleElectronCount);
        }
        return this.singleElectrons[idx];
    }

    @Override
    public Iterable<IAtom> atoms() {
        return () -> new AtomIterator();
    }

    @Override
    public Iterable<IBond> bonds() {
        return () -> new BondIterator();
    }

    @Override
    public Iterable<ILonePair> lonePairs() {
        return () -> new LonePairIterator();
    }

    @Override
    public Iterable<ISingleElectron> singleElectrons() {
        return () -> new SingleElectronIterator();
    }

    @Override
    public Iterable<IElectronContainer> electronContainers() {
        return () -> new ElectronContainerIterator();
    }

    @Override
    public IAtom getFirstAtom() {
        return this.atoms[0];
    }

    @Override
    public IAtom getLastAtom() {
        return this.getAtomCount() > 0 ? this.atoms[this.getAtomCount() - 1] : null;
    }

    @Override
    public int getAtomNumber(IAtom atom) {
        return this.indexOf(atom);
    }

    @Override
    public int getBondNumber(IAtom atom1, IAtom atom2) {
        return this.indexOf(this.getBond(atom1, atom2));
    }

    @Override
    public int getBondNumber(IBond bond) {
        return this.indexOf(bond);
    }

    @Override
    public int getLonePairNumber(ILonePair lonePair) {
        return this.indexOf(lonePair);
    }

    @Override
    public int getSingleElectronNumber(ISingleElectron singleElectron) {
        return this.indexOf(singleElectron);
    }

    @Override
    public int indexOf(IAtom atom) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!this.atoms[i].equals(atom)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(IBond bond) {
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].equals(bond)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(ISingleElectron electron) {
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (this.singleElectrons[i] != electron) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(ILonePair pair2) {
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (this.lonePairs[i] != pair2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public IElectronContainer getElectronContainer(int number) {
        if (number < this.bondCount) {
            return this.bonds[number];
        }
        if ((number -= this.bondCount) < this.lonePairCount) {
            return this.lonePairs[number];
        }
        if ((number -= this.lonePairCount) < this.singleElectronCount) {
            return this.singleElectrons[number];
        }
        return null;
    }

    @Override
    public IBond getBond(IAtom atom1, IAtom atom2) {
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (!this.bonds[i].contains(atom1) || !this.bonds[i].getOther(atom1).equals(atom2)) continue;
            return this.bonds[i];
        }
        return null;
    }

    @Override
    public int getAtomCount() {
        return this.atomCount;
    }

    @Override
    public int getBondCount() {
        return this.bondCount;
    }

    @Override
    public int getLonePairCount() {
        return this.lonePairCount;
    }

    @Override
    public int getSingleElectronCount() {
        return this.singleElectronCount;
    }

    @Override
    public int getElectronContainerCount() {
        return this.bondCount + this.lonePairCount + this.singleElectronCount;
    }

    @Override
    public List<IAtom> getConnectedAtomsList(IAtom atom) {
        ArrayList<IAtom> atomsList = new ArrayList<IAtom>();
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            atomsList.add(this.bonds[i].getOther(atom));
        }
        return atomsList;
    }

    @Override
    public List<IBond> getConnectedBondsList(IAtom atom) {
        ArrayList<IBond> bondsList = new ArrayList<IBond>();
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            bondsList.add(this.bonds[i]);
        }
        return bondsList;
    }

    @Override
    public List<ILonePair> getConnectedLonePairsList(IAtom atom) {
        ArrayList<ILonePair> lps = new ArrayList<ILonePair>();
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            lps.add(this.lonePairs[i]);
        }
        return lps;
    }

    @Override
    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom atom) {
        ArrayList<ISingleElectron> lps = new ArrayList<ISingleElectron>();
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            lps.add(this.singleElectrons[i]);
        }
        return lps;
    }

    @Override
    public List<IElectronContainer> getConnectedElectronContainersList(IAtom atom) {
        int i;
        ArrayList<IElectronContainer> lps = new ArrayList<IElectronContainer>();
        for (i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            lps.add(this.bonds[i]);
        }
        for (i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            lps.add(this.lonePairs[i]);
        }
        for (i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            lps.add(this.singleElectrons[i]);
        }
        return lps;
    }

    @Override
    public int getConnectedAtomsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getConnectedBondsCount(IAtom atom) {
        return this.getConnectedAtomsCount(atom);
    }

    @Override
    public int getConnectedBondsCount(int idx) {
        return this.getConnectedAtomsCount(this.atoms[idx]);
    }

    @Override
    public int getConnectedLonePairsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.lonePairCount; ++i) {
            if (!this.lonePairs[i].contains(atom)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getConnectedSingleElectronsCount(IAtom atom) {
        int count = 0;
        for (int i = 0; i < this.singleElectronCount; ++i) {
            if (!this.singleElectrons[i].contains(atom)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public double getBondOrderSum(IAtom atom) {
        double count = 0.0;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom)) continue;
            if (this.bonds[i].getOrder() == IBond.Order.SINGLE) {
                count += 1.0;
                continue;
            }
            if (this.bonds[i].getOrder() == IBond.Order.DOUBLE) {
                count += 2.0;
                continue;
            }
            if (this.bonds[i].getOrder() == IBond.Order.TRIPLE) {
                count += 3.0;
                continue;
            }
            if (this.bonds[i].getOrder() != IBond.Order.QUADRUPLE) continue;
            count += 4.0;
        }
        return count;
    }

    @Override
    public IBond.Order getMaximumBondOrder(IAtom atom) {
        IBond.Order max = IBond.Order.SINGLE;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom) || this.bonds[i].getOrder().ordinal() <= max.ordinal()) continue;
            max = this.bonds[i].getOrder();
        }
        return max;
    }

    @Override
    public IBond.Order getMinimumBondOrder(IAtom atom) {
        IBond.Order min = IBond.Order.QUADRUPLE;
        for (int i = 0; i < this.bondCount; ++i) {
            if (!this.bonds[i].contains(atom) || this.bonds[i].getOrder().ordinal() >= min.ordinal()) continue;
            min = this.bonds[i].getOrder();
        }
        return min;
    }

    @Override
    public void add(IAtomContainer atomContainer) {
        if (atomContainer instanceof QueryAtomContainer) {
            int f;
            for (f = 0; f < atomContainer.getAtomCount(); ++f) {
                if (this.contains(atomContainer.getAtom(f))) continue;
                this.addAtom(atomContainer.getAtom(f));
            }
            for (f = 0; f < atomContainer.getBondCount(); ++f) {
                if (this.contains(atomContainer.getBond(f))) continue;
                this.addBond(atomContainer.getBond(f));
            }
            for (f = 0; f < atomContainer.getLonePairCount(); ++f) {
                if (this.contains(atomContainer.getLonePair(f))) continue;
                this.addLonePair(atomContainer.getLonePair(f));
            }
            for (f = 0; f < atomContainer.getSingleElectronCount(); ++f) {
                if (this.contains(atomContainer.getSingleElectron(f))) continue;
                this.addSingleElectron(atomContainer.getSingleElectron(f));
            }
        } else {
            throw new IllegalArgumentException("AtomContainer is not of type QueryAtomContainer");
        }
        this.notifyChanged();
    }

    @Override
    public void addAtom(IAtom atom) {
        if (this.contains(atom)) {
            return;
        }
        if (this.atomCount + 1 >= this.atoms.length) {
            this.growAtomArray();
        }
        atom.addListener(this);
        this.atoms[this.atomCount] = atom;
        ++this.atomCount;
        this.notifyChanged();
    }

    @Override
    public void addBond(IBond bond) {
        if (this.bondCount >= this.bonds.length) {
            this.growBondArray();
        }
        this.bonds[this.bondCount] = bond;
        ++this.bondCount;
        this.notifyChanged();
    }

    @Override
    public void addLonePair(ILonePair lonePair) {
        if (this.lonePairCount >= this.lonePairs.length) {
            this.growLonePairArray();
        }
        this.lonePairs[this.lonePairCount] = lonePair;
        ++this.lonePairCount;
        this.notifyChanged();
    }

    @Override
    public void addSingleElectron(ISingleElectron singleElectron) {
        if (this.singleElectronCount >= this.singleElectrons.length) {
            this.growSingleElectronArray();
        }
        this.singleElectrons[this.singleElectronCount] = singleElectron;
        ++this.singleElectronCount;
        this.notifyChanged();
    }

    @Override
    public void addElectronContainer(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            this.addBond((IBond)electronContainer);
        }
        if (electronContainer instanceof ILonePair) {
            this.addLonePair((ILonePair)electronContainer);
        }
        if (electronContainer instanceof ISingleElectron) {
            this.addSingleElectron((ISingleElectron)electronContainer);
        }
    }

    @Override
    public void remove(IAtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            this.removeAtomOnly(atomContainer.getAtom(f));
        }
        for (f = 0; f < atomContainer.getBondCount(); ++f) {
            this.removeBond(atomContainer.getBond(f));
        }
        for (f = 0; f < atomContainer.getLonePairCount(); ++f) {
            this.removeLonePair(atomContainer.getLonePair(f));
        }
        for (f = 0; f < atomContainer.getSingleElectronCount(); ++f) {
            this.removeSingleElectron(atomContainer.getSingleElectron(f));
        }
    }

    @Override
    public void removeAtomOnly(int position) {
        this.atoms[position].removeListener(this);
        for (int i = position; i < this.atomCount - 1; ++i) {
            this.atoms[i] = this.atoms[i + 1];
        }
        this.atoms[this.atomCount - 1] = null;
        --this.atomCount;
        this.notifyChanged();
    }

    @Override
    public void removeAtomOnly(IAtom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            this.removeAtomOnly(position);
        }
    }

    @Override
    public IBond removeBond(int position) {
        IBond bond = this.bonds[position];
        bond.removeListener(this);
        for (int i = position; i < this.bondCount - 1; ++i) {
            this.bonds[i] = this.bonds[i + 1];
        }
        this.bonds[this.bondCount - 1] = null;
        --this.bondCount;
        this.notifyChanged();
        return bond;
    }

    @Override
    public IBond removeBond(IAtom atom1, IAtom atom2) {
        int pos = this.indexOf(this.getBond(atom1, atom2));
        IBond bond = null;
        if (pos != -1) {
            bond = this.bonds[pos];
            this.removeBond(pos);
        }
        return bond;
    }

    @Override
    public void removeBond(IBond bond) {
        int pos = this.getBondNumber(bond);
        if (pos != -1) {
            this.removeBond(pos);
        }
    }

    @Override
    public ILonePair removeLonePair(int position) {
        ILonePair lp = this.lonePairs[position];
        lp.removeListener(this);
        for (int i = position; i < this.lonePairCount - 1; ++i) {
            this.lonePairs[i] = this.lonePairs[i + 1];
        }
        this.lonePairs[this.lonePairCount - 1] = null;
        --this.lonePairCount;
        this.notifyChanged();
        return lp;
    }

    @Override
    public void removeLonePair(ILonePair lonePair) {
        int pos = this.indexOf(lonePair);
        if (pos != -1) {
            this.removeLonePair(pos);
        }
    }

    @Override
    public ISingleElectron removeSingleElectron(int position) {
        ISingleElectron se = this.singleElectrons[position];
        se.removeListener(this);
        for (int i = position; i < this.singleElectronCount - 1; ++i) {
            this.singleElectrons[i] = this.singleElectrons[i + 1];
        }
        this.singleElectrons[this.singleElectronCount - 1] = null;
        --this.singleElectronCount;
        this.notifyChanged();
        return se;
    }

    @Override
    public void removeSingleElectron(ISingleElectron singleElectron) {
        int pos = this.indexOf(singleElectron);
        if (pos != -1) {
            this.removeSingleElectron(pos);
        }
    }

    @Override
    public IElectronContainer removeElectronContainer(int number) {
        if (number < this.bondCount) {
            return this.removeBond(number);
        }
        if ((number -= this.bondCount) < this.lonePairCount) {
            return this.removeLonePair(number);
        }
        if ((number -= this.lonePairCount) < this.singleElectronCount) {
            return this.removeSingleElectron(number);
        }
        return null;
    }

    @Override
    public void removeElectronContainer(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            this.removeBond((IBond)electronContainer);
        } else if (electronContainer instanceof ILonePair) {
            this.removeLonePair((ILonePair)electronContainer);
        } else if (electronContainer instanceof ISingleElectron) {
            this.removeSingleElectron((ISingleElectron)electronContainer);
        }
    }

    @Override
    @Deprecated
    public void removeAtomAndConnectedElectronContainers(IAtom atom) {
        this.removeAtom(atom);
    }

    @Override
    public void removeAtom(IAtom atom) {
        int position = this.getAtomNumber(atom);
        if (position != -1) {
            int i;
            for (i = 0; i < this.bondCount; ++i) {
                if (!this.bonds[i].contains(atom)) continue;
                this.removeBond(i);
                --i;
            }
            for (i = 0; i < this.lonePairCount; ++i) {
                if (!this.lonePairs[i].contains(atom)) continue;
                this.removeLonePair(i);
                --i;
            }
            for (i = 0; i < this.singleElectronCount; ++i) {
                if (!this.singleElectrons[i].contains(atom)) continue;
                this.removeSingleElectron(i);
                --i;
            }
            this.removeAtomOnly(position);
        }
        this.notifyChanged();
    }

    @Override
    public void removeAtom(int pos) {
        this.removeAtom(this.getAtom(pos));
    }

    @Override
    public void removeAllElements() {
        this.removeAllElectronContainers();
        for (int f = 0; f < this.getAtomCount(); ++f) {
            this.getAtom(f).removeListener(this);
        }
        this.atoms = new IAtom[this.growArraySize];
        this.atomCount = 0;
        this.notifyChanged();
    }

    @Override
    public void removeAllElectronContainers() {
        int f;
        this.removeAllBonds();
        for (f = 0; f < this.getLonePairCount(); ++f) {
            this.getLonePair(f).removeListener(this);
        }
        for (f = 0; f < this.getSingleElectronCount(); ++f) {
            this.getSingleElectron(f).removeListener(this);
        }
        this.lonePairs = new ILonePair[this.growArraySize];
        this.singleElectrons = new ISingleElectron[this.growArraySize];
        this.lonePairCount = 0;
        this.singleElectronCount = 0;
        this.notifyChanged();
    }

    @Override
    public void removeAllBonds() {
        for (int f = 0; f < this.getBondCount(); ++f) {
            this.getBond(f).removeListener(this);
        }
        this.bonds = new IBond[this.growArraySize];
        this.bondCount = 0;
        this.notifyChanged();
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order, IBond.Stereo stereo) {
        IBond bond = this.getBuilder().newInstance(IBond.class, new Object[]{this.getAtom(atom1), this.getAtom(atom2), order, stereo});
        if (this.contains(bond)) {
            return;
        }
        if (this.bondCount >= this.bonds.length) {
            this.growBondArray();
        }
        this.addBond(bond);
    }

    @Override
    public void addBond(int atom1, int atom2, IBond.Order order) {
        IBond bond = this.getBuilder().newInstance(IBond.class, new Object[]{this.getAtom(atom1), this.getAtom(atom2), order});
        if (this.bondCount >= this.bonds.length) {
            this.growBondArray();
        }
        this.addBond(bond);
    }

    @Override
    public void addLonePair(int atomID) {
        ILonePair lonePair = this.getBuilder().newInstance(ILonePair.class, this.atoms[atomID]);
        lonePair.addListener(this);
        this.addLonePair(lonePair);
    }

    @Override
    public void addSingleElectron(int atomID) {
        ISingleElectron singleElectron = this.getBuilder().newInstance(ISingleElectron.class, this.atoms[atomID]);
        singleElectron.addListener(this);
        this.addSingleElectron(singleElectron);
    }

    @Override
    public boolean contains(IAtom atom) {
        for (int i = 0; i < this.getAtomCount(); ++i) {
            if (!this.atoms[i].equals(atom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IBond bond) {
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (!this.bonds[i].equals(bond)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ILonePair lonePair) {
        for (int i = 0; i < this.getLonePairCount(); ++i) {
            if (lonePair != this.lonePairs[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ISingleElectron singleElectron) {
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            if (singleElectron != this.singleElectrons[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(IElectronContainer electronContainer) {
        if (electronContainer instanceof IBond) {
            return this.contains((IBond)electronContainer);
        }
        if (electronContainer instanceof ILonePair) {
            return this.contains((ILonePair)electronContainer);
        }
        if (electronContainer instanceof ISingleElectron) {
            return this.contains((ISingleElectron)electronContainer);
        }
        return false;
    }

    @Override
    public IQueryAtomContainer clone() throws CloneNotSupportedException {
        IQueryAtomContainer clone = (IQueryAtomContainer)super.clone();
        clone.removeAllElements();
        for (int f = 0; f < this.getAtomCount(); ++f) {
            clone.addAtom(this.getAtom(f).clone());
        }
        for (int i = 0; i < this.getBondCount(); ++i) {
            IBond bond = this.getBond(i);
            IBond newBond = bond.clone();
            IAtom[] newAtoms = new IAtom[bond.getAtomCount()];
            for (int j = 0; j < bond.getAtomCount(); ++j) {
                newAtoms[j] = clone.getAtom(this.getAtomNumber(bond.getAtom(j)));
            }
            newBond.setAtoms(newAtoms);
            clone.addBond(newBond);
        }
        for (int i = 0; i < this.getLonePairCount(); ++i) {
            ILonePair lp = this.getLonePair(i);
            ILonePair newLp = (ILonePair)lp.clone();
            if (lp.getAtom() != null) {
                newLp.setAtom(clone.getAtom(this.getAtomNumber(lp.getAtom())));
            }
            clone.addLonePair(newLp);
        }
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            ISingleElectron se = this.getSingleElectron(i);
            ISingleElectron newSe = (ISingleElectron)se.clone();
            if (se.getAtom() != null) {
                newSe.setAtom(clone.getAtom(this.getAtomNumber(se.getAtom())));
            }
            clone.addSingleElectron(newSe);
        }
        return clone;
    }

    private void growAtomArray() {
        this.growArraySize = this.atoms.length < this.growArraySize ? this.growArraySize : this.atoms.length;
        IAtom[] newatoms = new IAtom[this.atoms.length + this.growArraySize];
        System.arraycopy(this.atoms, 0, newatoms, 0, this.atoms.length);
        this.atoms = newatoms;
    }

    private void growBondArray() {
        this.growArraySize = this.bonds.length < this.growArraySize ? this.growArraySize : this.bonds.length;
        IBond[] newBonds = new IBond[this.bonds.length + this.growArraySize];
        System.arraycopy(this.bonds, 0, newBonds, 0, this.bonds.length);
        this.bonds = newBonds;
    }

    private void growLonePairArray() {
        this.growArraySize = this.lonePairs.length < this.growArraySize ? this.growArraySize : this.lonePairs.length;
        ILonePair[] newLonePairs = new ILonePair[this.lonePairs.length + this.growArraySize];
        System.arraycopy(this.lonePairs, 0, newLonePairs, 0, this.lonePairs.length);
        this.lonePairs = newLonePairs;
    }

    private void growSingleElectronArray() {
        this.growArraySize = this.singleElectrons.length < this.growArraySize ? this.growArraySize : this.singleElectrons.length;
        ISingleElectron[] newSingleElectrons = new ISingleElectron[this.singleElectrons.length + this.growArraySize];
        System.arraycopy(this.singleElectrons, 0, newSingleElectrons, 0, this.singleElectrons.length);
        this.singleElectrons = newSingleElectrons;
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }

    @Override
    public boolean isEmpty() {
        return this.atomCount == 0;
    }

    @Override
    public String getTitle() {
        return (String)this.getProperty("cdk:Title");
    }

    @Override
    public void setTitle(String title) {
        this.setProperty("cdk:Title", title);
    }

    @Override
    public void setStereoElements(List<IStereoElement> elements) {
        this.stereoElements.clear();
        this.stereoElements.addAll(elements);
    }

    public static void create(IAtomContainer dst, IAtomContainer src, Expr.Type ... opts) {
        IStereoElement se;
        Expr expr;
        EnumSet<Expr.Type> optset = EnumSet.noneOf(Expr.Type.class);
        optset.addAll(Arrays.asList(opts));
        HashMap<IChemObject, IChemObject> mapping = new HashMap<IChemObject, IChemObject>();
        HashMap stereos = new HashMap();
        for (IStereoElement se2 : src.stereoElements()) {
            stereos.put(se2.getFocus(), se2);
        }
        ArrayList<IStereoElement> qstereo = new ArrayList<IStereoElement>();
        for (IAtom atom : src.atoms()) {
            if (atom instanceof IQueryAtom) {
                expr = ((QueryAtom)AtomRef.deref(atom)).getExpression();
                se = (IStereoElement)stereos.get(atom);
                if (se != null) {
                    qstereo.add(se);
                }
            } else {
                expr = new Expr();
                if (optset.contains((Object)Expr.Type.ISOTOPE) && atom.getMassNumber() != null) {
                    expr.and(new Expr(Expr.Type.ISOTOPE, atom.getMassNumber()));
                }
                if (atom.getAtomicNumber() != null && atom.getAtomicNumber() != 0) {
                    if (atom.isAromatic()) {
                        if (optset.contains((Object)Expr.Type.AROMATIC_ELEMENT)) {
                            expr.and(new Expr(Expr.Type.AROMATIC_ELEMENT, atom.getAtomicNumber()));
                        } else if (optset.contains((Object)Expr.Type.IS_AROMATIC)) {
                            if (optset.contains((Object)Expr.Type.ELEMENT)) {
                                expr.and(new Expr(Expr.Type.AROMATIC_ELEMENT, atom.getAtomicNumber()));
                            } else {
                                expr.and(new Expr(Expr.Type.IS_AROMATIC));
                            }
                        } else if (optset.contains((Object)Expr.Type.ELEMENT)) {
                            expr.and(new Expr(Expr.Type.ELEMENT, atom.getAtomicNumber()));
                        }
                    } else if (optset.contains((Object)Expr.Type.ALIPHATIC_ELEMENT)) {
                        expr.and(new Expr(Expr.Type.ALIPHATIC_ELEMENT, atom.getAtomicNumber()));
                    } else if (optset.contains((Object)Expr.Type.IS_ALIPHATIC)) {
                        if (optset.contains((Object)Expr.Type.ELEMENT)) {
                            expr.and(new Expr(Expr.Type.ALIPHATIC_ELEMENT, atom.getAtomicNumber()));
                        } else {
                            expr.and(new Expr(Expr.Type.IS_ALIPHATIC));
                        }
                    } else if (optset.contains((Object)Expr.Type.ELEMENT)) {
                        expr.and(new Expr(Expr.Type.ELEMENT, atom.getAtomicNumber()));
                    }
                }
                if (optset.contains((Object)Expr.Type.DEGREE)) {
                    expr.and(new Expr(Expr.Type.DEGREE, atom.getBondCount()));
                }
                if (optset.contains((Object)Expr.Type.TOTAL_DEGREE)) {
                    expr.and(new Expr(Expr.Type.TOTAL_DEGREE, atom.getBondCount() + atom.getImplicitHydrogenCount()));
                }
                if (optset.contains((Object)Expr.Type.IS_IN_RING) && atom.isInRing()) {
                    expr.and(new Expr(Expr.Type.IS_IN_RING));
                }
                if (optset.contains((Object)Expr.Type.IS_IN_CHAIN) && !atom.isInRing()) {
                    expr.and(new Expr(Expr.Type.IS_IN_CHAIN));
                }
                if (optset.contains((Object)Expr.Type.IMPL_H_COUNT)) {
                    expr.and(new Expr(Expr.Type.IMPL_H_COUNT, atom.getImplicitHydrogenCount()));
                }
                if (optset.contains((Object)Expr.Type.TOTAL_H_COUNT)) {
                    int hcount = atom.getImplicitHydrogenCount();
                    for (IBond bond : src.getConnectedBondsList(atom)) {
                        if (bond.getOther(atom).getAtomicNumber() != 1) continue;
                        ++hcount;
                    }
                    expr.and(new Expr(Expr.Type.TOTAL_H_COUNT, hcount));
                }
                if (optset.contains((Object)Expr.Type.RING_BOND_COUNT)) {
                    int rbonds = 0;
                    for (IBond bond : src.getConnectedBondsList(atom)) {
                        if (!bond.isInRing()) continue;
                        ++rbonds;
                    }
                    expr.and(new Expr(Expr.Type.RING_BOND_COUNT, rbonds));
                }
                if (optset.contains((Object)Expr.Type.FORMAL_CHARGE) && atom.getFormalCharge() != null) {
                    expr.and(new Expr(Expr.Type.FORMAL_CHARGE, atom.getFormalCharge()));
                }
                if ((se = (IStereoElement)stereos.get(atom)) != null && se.getConfigClass() == 16896 && optset.contains((Object)Expr.Type.STEREOCHEMISTRY)) {
                    expr.and(new Expr(Expr.Type.STEREOCHEMISTRY, se.getConfigOrder()));
                    qstereo.add(se);
                }
            }
            QueryAtom qatom = new QueryAtom(expr);
            qatom.setIsInRing(atom.isInRing());
            if (optset.contains((Object)Expr.Type.ELEMENT) || optset.contains((Object)Expr.Type.AROMATIC_ELEMENT) || optset.contains((Object)Expr.Type.ALIPHATIC_ELEMENT)) {
                qatom.setSymbol(atom.getSymbol());
                qatom.setAtomicNumber(atom.getAtomicNumber());
            }
            if (optset.contains((Object)Expr.Type.AROMATIC_ELEMENT) || optset.contains((Object)Expr.Type.IS_AROMATIC)) {
                qatom.setIsAromatic(atom.isAromatic());
            }
            mapping.put(atom, qatom);
            dst.addAtom(qatom);
        }
        for (IBond bond : src.bonds()) {
            if (bond instanceof IQueryBond) {
                expr = ((QueryBond)BondRef.deref(bond)).getExpression();
                se = (IStereoElement)stereos.get(bond);
                if (se != null) {
                    qstereo.add(se);
                }
            } else {
                expr = new Expr();
                if (bond.isAromatic() && (optset.contains((Object)Expr.Type.SINGLE_OR_AROMATIC) || optset.contains((Object)Expr.Type.DOUBLE_OR_AROMATIC) || optset.contains((Object)Expr.Type.IS_AROMATIC))) {
                    expr.and(new Expr(Expr.Type.IS_AROMATIC));
                } else if ((optset.contains((Object)Expr.Type.SINGLE_OR_AROMATIC) || optset.contains((Object)Expr.Type.DOUBLE_OR_AROMATIC) || optset.contains((Object)Expr.Type.ALIPHATIC_ORDER)) && !bond.isAromatic()) {
                    expr.and(new Expr(Expr.Type.ALIPHATIC_ORDER, bond.getOrder().numeric()));
                } else if (bond.isAromatic() && optset.contains((Object)Expr.Type.IS_ALIPHATIC)) {
                    expr.and(new Expr(Expr.Type.IS_ALIPHATIC));
                } else if (optset.contains((Object)Expr.Type.ORDER)) {
                    expr.and(new Expr(Expr.Type.ORDER, bond.getOrder().numeric()));
                }
                if (optset.contains((Object)Expr.Type.IS_IN_RING) && bond.isInRing()) {
                    expr.and(new Expr(Expr.Type.IS_IN_RING));
                } else if (optset.contains((Object)Expr.Type.IS_IN_CHAIN) && !bond.isInRing()) {
                    expr.and(new Expr(Expr.Type.IS_IN_CHAIN));
                }
                se = (IStereoElement)stereos.get(bond);
                if (se != null && optset.contains((Object)Expr.Type.STEREOCHEMISTRY)) {
                    expr.and(new Expr(Expr.Type.STEREOCHEMISTRY, se.getConfigOrder()));
                    qstereo.add(se);
                }
            }
            QueryBond qbond = new QueryBond((IAtom)mapping.get(bond.getBegin()), (IAtom)mapping.get(bond.getEnd()), expr);
            qbond.setIsInRing(bond.isInRing());
            if (optset.contains((Object)Expr.Type.ALIPHATIC_ORDER) || optset.contains((Object)Expr.Type.ORDER)) {
                qbond.setOrder(bond.getOrder());
            }
            if (optset.contains((Object)Expr.Type.SINGLE_OR_AROMATIC) || optset.contains((Object)Expr.Type.DOUBLE_OR_AROMATIC) || optset.contains((Object)Expr.Type.IS_AROMATIC)) {
                qbond.setIsAromatic(bond.isAromatic());
            }
            mapping.put(bond, qbond);
            dst.addBond(qbond);
        }
        for (IStereoElement se3 : qstereo) {
            dst.addStereoElement(se3.map(mapping));
        }
    }

    public static QueryAtomContainer create(IAtomContainer src, Expr.Type ... opts) {
        QueryAtomContainer dst = new QueryAtomContainer(src.getBuilder());
        QueryAtomContainer.create((IAtomContainer)dst, src, opts);
        return dst;
    }

    private class ElectronContainerIterator
    implements Iterator<IElectronContainer> {
        private int pointer = 0;

        private ElectronContainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < QueryAtomContainer.this.bondCount + QueryAtomContainer.this.lonePairCount + QueryAtomContainer.this.singleElectronCount;
        }

        @Override
        public IElectronContainer next() {
            if (this.pointer < QueryAtomContainer.this.bondCount) {
                return QueryAtomContainer.this.bonds[this.pointer++];
            }
            if (this.pointer < QueryAtomContainer.this.bondCount + QueryAtomContainer.this.lonePairCount) {
                return QueryAtomContainer.this.lonePairs[this.pointer++ - QueryAtomContainer.this.bondCount];
            }
            if (this.pointer < QueryAtomContainer.this.bondCount + QueryAtomContainer.this.lonePairCount + QueryAtomContainer.this.singleElectronCount) {
                return QueryAtomContainer.this.singleElectrons[this.pointer++ - QueryAtomContainer.this.bondCount - QueryAtomContainer.this.lonePairCount];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.pointer <= QueryAtomContainer.this.bondCount) {
                QueryAtomContainer.this.removeBond(--this.pointer);
            } else if (this.pointer <= QueryAtomContainer.this.bondCount + QueryAtomContainer.this.lonePairCount) {
                QueryAtomContainer.this.removeLonePair(--this.pointer - QueryAtomContainer.this.bondCount);
            } else if (this.pointer <= QueryAtomContainer.this.bondCount + QueryAtomContainer.this.lonePairCount + QueryAtomContainer.this.singleElectronCount) {
                QueryAtomContainer.this.removeSingleElectron(--this.pointer - QueryAtomContainer.this.bondCount - QueryAtomContainer.this.lonePairCount);
            }
        }
    }

    private class SingleElectronIterator
    implements Iterator<ISingleElectron> {
        private int pointer = 0;

        private SingleElectronIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < QueryAtomContainer.this.singleElectronCount;
        }

        @Override
        public ISingleElectron next() {
            if (this.pointer >= QueryAtomContainer.this.singleElectronCount) {
                throw new NoSuchElementException();
            }
            return QueryAtomContainer.this.singleElectrons[this.pointer++];
        }

        @Override
        public void remove() {
            QueryAtomContainer.this.removeSingleElectron(--this.pointer);
        }
    }

    private class LonePairIterator
    implements Iterator<ILonePair> {
        private int pointer = 0;

        private LonePairIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < QueryAtomContainer.this.lonePairCount;
        }

        @Override
        public ILonePair next() {
            if (this.pointer >= QueryAtomContainer.this.lonePairCount) {
                throw new NoSuchElementException();
            }
            return QueryAtomContainer.this.lonePairs[this.pointer++];
        }

        @Override
        public void remove() {
            QueryAtomContainer.this.removeLonePair(--this.pointer);
        }
    }

    private class BondIterator
    implements Iterator<IBond> {
        private int pointer = 0;

        private BondIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < QueryAtomContainer.this.bondCount;
        }

        @Override
        public IBond next() {
            if (this.pointer >= QueryAtomContainer.this.bondCount) {
                throw new NoSuchElementException();
            }
            return QueryAtomContainer.this.bonds[this.pointer++];
        }

        @Override
        public void remove() {
            QueryAtomContainer.this.removeBond(--this.pointer);
        }
    }

    private class AtomIterator
    implements Iterator<IAtom> {
        private int pointer = 0;

        private AtomIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < QueryAtomContainer.this.atomCount;
        }

        @Override
        public IAtom next() {
            if (this.pointer >= QueryAtomContainer.this.atomCount) {
                throw new NoSuchElementException();
            }
            return QueryAtomContainer.this.atoms[this.pointer++];
        }

        @Override
        public void remove() {
            QueryAtomContainer.this.removeAtomOnly(--this.pointer);
        }
    }
}

