/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.BondRef;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.isomorphism.matchers.QueryChemObject;

public class QueryBond
extends QueryChemObject
implements IQueryBond {
    protected IBond.Order order = (IBond.Order)((Object)CDKConstants.UNSET);
    protected int atomCount;
    protected IAtom[] atoms;
    protected IBond.Stereo stereo;
    private Expr expr = new Expr(Expr.Type.TRUE);
    protected Integer electronCount;

    public QueryBond(IAtom beg, IAtom end, Expr expr) {
        this(beg, end, null, IBond.Stereo.NONE, beg.getBuilder());
        this.expr.set(expr);
        this.atomCount = 2;
    }

    public QueryBond(IAtom beg, IAtom end, Expr.Type type) {
        this(beg, end, null, IBond.Stereo.NONE, beg.getBuilder());
        this.expr.setPrimitive(type);
        this.atomCount = 2;
    }

    public QueryBond(IAtom beg, IAtom end, Expr.Type type, int val) {
        this(beg, end, null, IBond.Stereo.NONE, beg.getBuilder());
        this.expr.setPrimitive(type, val);
        this.atomCount = 2;
    }

    public QueryBond(IChemObjectBuilder builder) {
        this(null, null, null, IBond.Stereo.NONE, builder);
        this.atomCount = 0;
    }

    public QueryBond(IAtom atom1, IAtom atom2, IChemObjectBuilder builder) {
        this(atom1, atom2, IBond.Order.SINGLE, IBond.Stereo.NONE, builder);
    }

    public QueryBond(IAtom atom1, IAtom atom2, IBond.Order order, IChemObjectBuilder builder) {
        this(atom1, atom2, order, IBond.Stereo.NONE, builder);
    }

    public QueryBond(IAtom[] atoms, IChemObjectBuilder builder) {
        super(builder);
        this.atoms = new IAtom[atoms.length];
        System.arraycopy(atoms, 0, this.atoms, 0, atoms.length);
        this.atomCount = this.atoms.length;
    }

    public QueryBond(IAtom[] atoms, IBond.Order order, IChemObjectBuilder builder) {
        super(builder);
        this.atoms = new IAtom[atoms.length];
        System.arraycopy(atoms, 0, this.atoms, 0, atoms.length);
        this.atomCount = this.atoms.length;
        this.order = order;
    }

    public QueryBond(IAtom atom1, IAtom atom2, IBond.Order order, IBond.Stereo stereo, IChemObjectBuilder builder) {
        super(builder);
        this.atoms = new IAtom[2];
        this.atoms[0] = atom1;
        this.atoms[1] = atom2;
        this.order = order;
        this.stereo = stereo;
        this.atomCount = 2;
    }

    @Override
    public Iterable<IAtom> atoms() {
        return () -> new AtomsIterator();
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public IAtomContainer getContainer() {
        return null;
    }

    @Override
    public void setAtoms(IAtom[] atoms) {
        this.atoms = atoms;
        this.atomCount = atoms.length;
        this.notifyChanged();
    }

    @Override
    public int getAtomCount() {
        return this.atomCount;
    }

    @Override
    public IAtom getAtom(int position) {
        if (this.atoms == null) {
            return null;
        }
        return this.atoms[position];
    }

    @Override
    public IAtom getBegin() {
        return this.atoms[0];
    }

    @Override
    public IAtom getEnd() {
        return this.atoms[1];
    }

    @Override
    public IAtom getOther(IAtom atom) {
        if (this.atoms[0].equals(atom)) {
            return this.atoms[1];
        }
        if (this.atoms[1].equals(atom)) {
            return this.atoms[0];
        }
        return null;
    }

    @Override
    public IAtom getConnectedAtom(IAtom atom) {
        return this.getOther(atom);
    }

    @Override
    public IAtom[] getConnectedAtoms(IAtom atom) {
        if (this.atomCount < 1) {
            return null;
        }
        IAtom[] connected = new IAtom[this.atomCount - 1];
        int j = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].equals(atom)) continue;
            if (j >= connected.length) {
                return null;
            }
            connected[j++] = this.atoms[i];
        }
        return connected;
    }

    @Override
    public boolean contains(IAtom atom) {
        if (this.atoms == null) {
            return false;
        }
        for (IAtom localAtom : this.atoms) {
            if (!localAtom.equals(atom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setAtom(IAtom atom, int position) {
        if (this.atoms[position] == null && atom != null) {
            ++this.atomCount;
        }
        if (this.atoms[position] != null && atom == null) {
            --this.atomCount;
        }
        this.atoms[position] = atom;
        this.notifyChanged();
    }

    @Override
    public IBond.Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IBond.Order order) {
        this.order = order;
        this.notifyChanged();
    }

    @Override
    public IBond.Stereo getStereo() {
        return this.stereo;
    }

    @Override
    public void setStereo(IBond.Stereo stereo) {
        this.stereo = stereo;
        this.notifyChanged();
    }

    @Override
    public IBond.Display getDisplay() {
        return null;
    }

    @Override
    public void setDisplay(IBond.Display display) {
    }

    @Override
    public Point2d get2DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        for (IAtom atom : this.atoms) {
            xOfCenter += atom.getPoint2d().x;
            yOfCenter += atom.getPoint2d().y;
        }
        return new Point2d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount());
    }

    @Override
    public Point3d get3DCenter() {
        double xOfCenter = 0.0;
        double yOfCenter = 0.0;
        double zOfCenter = 0.0;
        for (IAtom atom : this.atoms) {
            xOfCenter += atom.getPoint3d().x;
            yOfCenter += atom.getPoint3d().y;
            zOfCenter += atom.getPoint3d().z;
        }
        return new Point3d(xOfCenter / (double)this.getAtomCount(), yOfCenter / (double)this.getAtomCount(), zOfCenter / (double)this.getAtomCount());
    }

    @Override
    public boolean compare(Object object) {
        if (object instanceof IQueryBond) {
            QueryBond queryBond = (QueryBond)object;
            for (IAtom atom : this.atoms) {
                if (queryBond.contains(atom)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnectedTo(IBond bond) {
        for (IAtom atom : this.atoms) {
            if (!bond.contains(atom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IQueryBond clone() throws CloneNotSupportedException {
        QueryBond clone = (QueryBond)super.clone();
        if (this.atoms != null) {
            clone.atoms = new IAtom[this.atoms.length];
            for (int f = 0; f < this.atoms.length; ++f) {
                if (this.atoms[f] == null) continue;
                clone.atoms[f] = this.atoms[f].clone();
            }
        }
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder resultString = new StringBuilder(32);
        resultString.append("Bond(").append(this.hashCode());
        if (this.getOrder() != null) {
            resultString.append(", #O:").append((Object)this.getOrder());
        }
        resultString.append(", #S:").append((Object)this.getStereo());
        if (this.getAtomCount() > 0) {
            resultString.append(", #A:").append(this.getAtomCount());
            for (int i = 0; i < this.atomCount; ++i) {
                resultString.append(", ").append(this.atoms[i] == null ? "null" : this.atoms[i].toString());
            }
        }
        resultString.append(", ").append(super.toString());
        resultString.append(')');
        return resultString.toString();
    }

    @Override
    public Integer getElectronCount() {
        return this.electronCount;
    }

    @Override
    public boolean isAromatic() {
        return this.getFlag(32);
    }

    @Override
    public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    @Override
    public boolean isInRing() {
        return this.getFlag(2);
    }

    @Override
    public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    @Override
    public void setElectronCount(Integer electronCount) {
        this.electronCount = electronCount;
        this.notifyChanged();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BondRef) {
            return super.equals(((BondRef)obj).deref());
        }
        return super.equals(obj);
    }

    public Expr getExpression() {
        return this.expr;
    }

    public void setExpression(Expr expr) {
        this.expr = expr;
    }

    @Override
    public boolean matches(IBond bond) {
        return this.expr.matches(bond);
    }

    private class AtomsIterator
    implements Iterator<IAtom> {
        private int pointer = 0;

        private AtomsIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < QueryBond.this.atomCount;
        }

        @Override
        public IAtom next() {
            if (this.pointer >= QueryBond.this.atomCount) {
                throw new NoSuchElementException();
            }
            ++this.pointer;
            return QueryBond.this.atoms[this.pointer - 1];
        }

        @Override
        public void remove() {
        }
    }
}

