/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import javax.vecmath.Point2d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

final class Congestion {
    private static final double MIN_DIST = 1.0E-5;
    private static final double MAX_SCORE = 100000.0;
    final double[][] contribution;
    double score;
    final IAtom[] atoms;

    Congestion(IAtomContainer mol, int[][] adjList) {
        int numAtoms = mol.getAtomCount();
        this.contribution = new double[numAtoms][numAtoms];
        this.atoms = AtomContainerManipulator.getAtomArray(mol);
        for (int v = 0; v < numAtoms; ++v) {
            for (int w : adjList[v]) {
                this.contribution[v][w] = -1.0;
                this.contribution[v][v] = -1.0;
            }
        }
        this.score = this.initScore();
    }

    private double initScore() {
        double score = 0.0;
        int n = this.atoms.length;
        for (int i = 0; i < n; ++i) {
            Point2d p1 = this.atoms[i].getPoint2d();
            for (int j = i + 1; j < n; ++j) {
                double contrib;
                if (this.contribution[i][j] < 0.0) continue;
                Point2d p2 = this.atoms[j].getPoint2d();
                double x = p1.x - p2.x;
                double y = p1.y - p2.y;
                double dist2 = x * x + y * y;
                double d = contrib = dist2 > 1.0E-5 ? 1.0 / dist2 : 100000.0;
                this.contribution[i][j] = d;
                this.contribution[j][i] = d;
                score += d;
            }
        }
        return score;
    }

    void update(boolean[] visit, int[] vs, int n) {
        int len = this.atoms.length;
        double subtract = 0.0;
        for (int i = 0; i < n; ++i) {
            int v = vs[i];
            Point2d p1 = this.atoms[v].getPoint2d();
            for (int w = 0; w < len; ++w) {
                double contrib;
                if (visit[w] || this.contribution[v][w] < 0.0) continue;
                subtract += this.contribution[v][w];
                Point2d p2 = this.atoms[w].getPoint2d();
                double x = p1.x - p2.x;
                double y = p1.y - p2.y;
                double dist2 = x * x + y * y;
                double d = contrib = dist2 > 1.0E-5 ? 1.0 / dist2 : 100000.0;
                this.contribution[v][w] = d;
                this.contribution[w][v] = d;
                this.score += d;
            }
        }
        this.score -= subtract;
    }

    void update(int[] vs, int n) {
        int len = this.atoms.length;
        double subtract = 0.0;
        for (int i = 0; i < n; ++i) {
            int v = vs[i];
            Point2d p1 = this.atoms[v].getPoint2d();
            for (int w = 0; w < len; ++w) {
                if (this.contribution[v][w] < 0.0) continue;
                subtract += this.contribution[v][w];
                Point2d p2 = this.atoms[w].getPoint2d();
                double x = p1.x - p2.x;
                double y = p1.y - p2.y;
                double dist2 = x * x + y * y;
                double contrib = dist2 > 1.0E-5 ? 1.0 / dist2 : 100000.0;
                double d = 1.0 / contrib;
                this.contribution[v][w] = d;
                this.contribution[w][v] = d;
                this.score += d;
            }
        }
        this.score -= subtract;
    }

    double score() {
        return this.score;
    }

    double contribution(int i, int j) {
        return this.contribution[i][j];
    }
}

