/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.libio.cml;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.dict.DictRef;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.interfaces.IMolecularFormulaSet;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IPDBPolymer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.libio.cml.ICMLCustomizer;
import org.openscience.cdk.tools.IDCreator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSchemeManipulator;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBond;
import org.xmlcml.cml.element.CMLBondStereo;
import org.xmlcml.cml.element.CMLBondType;
import org.xmlcml.cml.element.CMLCml;
import org.xmlcml.cml.element.CMLCrystal;
import org.xmlcml.cml.element.CMLFormula;
import org.xmlcml.cml.element.CMLIdentifier;
import org.xmlcml.cml.element.CMLList;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLMoleculeList;
import org.xmlcml.cml.element.CMLProduct;
import org.xmlcml.cml.element.CMLProductList;
import org.xmlcml.cml.element.CMLReactant;
import org.xmlcml.cml.element.CMLReactantList;
import org.xmlcml.cml.element.CMLReaction;
import org.xmlcml.cml.element.CMLReactionList;
import org.xmlcml.cml.element.CMLReactionScheme;
import org.xmlcml.cml.element.CMLReactionStep;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.cml.element.CMLSubstance;
import org.xmlcml.cml.element.CMLSubstanceList;

public class Convertor {
    public static final String NS_CML = "http://www.xml-cml.org/schema";
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Convertor.class);
    private static final String CUSTOMIZERS_LIST = "libio-cml-customizers.set";
    private Map<String, ICMLCustomizer> customizers = null;
    private final boolean useCMLIDs;
    private String prefix;

    public Convertor(boolean useCMLIDs, String prefix) {
        this.useCMLIDs = useCMLIDs;
        this.prefix = prefix;
        this.setupCustomizers();
    }

    public void registerCustomizer(ICMLCustomizer customizer) {
        if (this.customizers == null) {
            this.customizers = new HashMap<String, ICMLCustomizer>();
        }
        if (!this.customizers.containsKey(customizer.getClass().getName())) {
            this.customizers.put(customizer.getClass().getName(), customizer);
            logger.info("Registered Customizer: ", customizer.getClass().getName());
        } else {
            logger.warn("Duplicate attempt to register a customizer");
        }
    }

    private void setupCustomizers() {
        if (this.customizers == null) {
            this.customizers = new HashMap<String, ICMLCustomizer>();
        }
        try (InputStream in = this.getClass().getResourceAsStream(CUSTOMIZERS_LIST);
             InputStreamReader rdr = new InputStreamReader(Objects.requireNonNull(in));
             BufferedReader brdr = new BufferedReader(rdr);){
            String customizerName;
            logger.debug("Starting loading Customizers...");
            int numLoaded = 0;
            while ((customizerName = brdr.readLine()) != null) {
                if (!this.customizers.containsKey(customizerName)) {
                    if (!this.loadCustomizer(customizerName)) continue;
                    ++numLoaded;
                    continue;
                }
                logger.warn("Duplicate attempt to load a customizer");
            }
            logger.info("Number of loaded customizers: ", numLoaded);
        }
        catch (Exception exception) {
            logger.error("Could not load this list: ", CUSTOMIZERS_LIST);
            logger.debug(exception);
        }
    }

    private boolean loadCustomizer(String customizerName) {
        try {
            ICMLCustomizer customizer = (ICMLCustomizer)Class.forName(customizerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.customizers.put(customizer.getClass().getName(), customizer);
            logger.info("Loaded Customizer: ", customizer.getClass().getName());
            return true;
        }
        catch (ClassNotFoundException exception) {
            logger.info("Could not find this Customizer: ", customizerName);
            logger.debug(exception);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            logger.warn("Could not load this Customizer: ", customizerName);
            logger.warn(exception.getMessage());
            logger.debug(exception);
        }
        return false;
    }

    public CMLCml cdkChemFileToCMLList(IChemFile file) {
        return this.cdkChemFileToCMLList(file, true);
    }

    private CMLCml cdkChemFileToCMLList(IChemFile file, boolean setIDs) {
        CMLCml cmlList = new CMLCml();
        cmlList.setConvention("cdk:document");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(file);
        }
        if (file.getID() != null && !file.getID().equals("")) {
            cmlList.setId(file.getID());
        }
        if (file.getChemSequenceCount() > 0) {
            for (IChemSequence iChemSequence : file.chemSequences()) {
                cmlList.appendChild(this.cdkChemSequenceToCMLList(iChemSequence));
            }
        }
        return cmlList;
    }

    public CMLList cdkChemSequenceToCMLList(IChemSequence sequence) {
        return this.cdkChemSequenceToCMLList(sequence, true);
    }

    private CMLList cdkChemSequenceToCMLList(IChemSequence sequence, boolean setIDs) {
        CMLList cmlList = new CMLList();
        cmlList.setConvention("cdk:sequence");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(sequence);
        }
        if (sequence.getID() != null && !sequence.getID().equals("")) {
            cmlList.setId(sequence.getID());
        }
        if (sequence.getChemModelCount() > 0) {
            for (int i = 0; i < sequence.getChemModelCount(); ++i) {
                cmlList.appendChild(this.cdkChemModelToCMLList(sequence.getChemModel(i)));
            }
        }
        return cmlList;
    }

    public CMLList cdkChemModelToCMLList(IChemModel model) {
        return this.cdkChemModelToCMLList(model, true);
    }

    private CMLList cdkChemModelToCMLList(IChemModel model, boolean setIDs) {
        CMLList cmlList = new CMLList();
        cmlList.setConvention("cdk:model");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(model);
        }
        if (model.getID() != null && !model.getID().equals("")) {
            cmlList.setId(model.getID());
        }
        if (model.getCrystal() != null) {
            cmlList.appendChild(this.cdkCrystalToCMLMolecule(model.getCrystal(), false));
        }
        if (model.getReactionSet() != null) {
            cmlList.appendChild(this.cdkReactionSetToCMLReactionList(model.getReactionSet(), false));
        }
        if (model.getMoleculeSet() != null) {
            cmlList.appendChild(this.cdkAtomContainerSetToCMLList(model.getMoleculeSet(), false));
        }
        return cmlList;
    }

    public CMLCml cdkReactionSchemeToCMLReactionSchemeAndMoleculeList(IReactionScheme cdkScheme) {
        CMLCml cml = new CMLCml();
        cml.appendChild(this.cdkAtomContainerSetToCMLList(ReactionSchemeManipulator.getAllAtomContainers(cdkScheme)));
        cml.appendChild(this.cdkReactionSchemeToCMLReactionScheme(cdkScheme, true));
        return cml;
    }

    public CMLReactionScheme cdkReactionSchemeToCMLReactionScheme(IReactionScheme cdkScheme) {
        return this.cdkReactionSchemeToCMLReactionScheme(cdkScheme, true);
    }

    private CMLReactionScheme cdkReactionSchemeToCMLReactionScheme(IReactionScheme cdkScheme, boolean setIDs) {
        CMLReactionScheme reactionScheme = new CMLReactionScheme();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(cdkScheme);
        }
        if (cdkScheme.getID() != null && !cdkScheme.getID().equals("")) {
            reactionScheme.setId(cdkScheme.getID());
        }
        for (IReaction iReaction : cdkScheme.reactions()) {
            reactionScheme.appendChild(this.cdkReactionToCMLReaction(iReaction, true));
        }
        for (IReactionScheme intScheme : cdkScheme.reactionSchemes()) {
            reactionScheme.appendChild(this.cdkReactionSchemeToCMLReactionScheme(intScheme));
        }
        return reactionScheme;
    }

    public CMLReactionStep cdkReactionToCMLReactionStep(IReaction reaction) {
        return this.cdkReactionToCMLReactionStep(reaction, true);
    }

    private CMLReactionStep cdkReactionToCMLReactionStep(IReaction reaction, boolean setIDs) {
        CMLReactionStep reactionStep = new CMLReactionStep();
        reactionStep.appendChild(this.cdkReactionToCMLReaction(reaction, true));
        return reactionStep;
    }

    public CMLReactionList cdkReactionSetToCMLReactionList(IReactionSet reactionSet) {
        return this.cdkReactionSetToCMLReactionList(reactionSet, true);
    }

    private CMLReactionList cdkReactionSetToCMLReactionList(IReactionSet reactionSet, boolean setIDs) {
        CMLReactionList reactionList = new CMLReactionList();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(reactionSet);
        }
        if (reactionSet.getID() != null && !reactionSet.getID().equals("")) {
            reactionList.setId(reactionSet.getID());
        }
        for (IReaction iReaction : reactionSet.reactions()) {
            reactionList.appendChild(this.cdkReactionToCMLReaction(iReaction, false));
        }
        return reactionList;
    }

    public CMLMoleculeList cdkAtomContainerSetToCMLList(IAtomContainerSet moleculeSet) {
        return this.cdkAtomContainerSetToCMLList(moleculeSet, true);
    }

    private CMLMoleculeList cdkAtomContainerSetToCMLList(IAtomContainerSet moleculeSet, boolean setIDs) {
        CMLMoleculeList cmlList = new CMLMoleculeList();
        cmlList.setConvention("cdk:moleculeSet");
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(moleculeSet);
        }
        if (moleculeSet.getID() != null && !moleculeSet.getID().equals("")) {
            cmlList.setId(moleculeSet.getID());
        }
        for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
            IAtomContainer container = moleculeSet.getAtomContainer(i);
            cmlList.appendChild(this.cdkAtomContainerToCMLMolecule(container, false, false));
        }
        return cmlList;
    }

    public CMLReaction cdkReactionToCMLReaction(IReaction reaction) {
        return this.cdkReactionToCMLReaction(reaction, true);
    }

    private CMLReaction cdkReactionToCMLReaction(IReaction reaction, boolean setIDs) {
        CMLReaction cmlReaction = new CMLReaction();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(reaction);
        }
        if (reaction.getID() != null && !reaction.getID().equals("")) {
            cmlReaction.setId(reaction.getID());
        }
        Map<Object, Object> props = reaction.getProperties();
        for (Object object : props.keySet()) {
            if (!(object instanceof String) || !(props.get(object) instanceof String)) continue;
            Object object2 = props.get(object);
            if (object.toString().equals("cdk:Title")) continue;
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setDictRef("cdk:reactionProperty");
            scalar.setTitle(object.toString());
            scalar.setValue(object2.toString());
            cmlReaction.appendChild(scalar);
        }
        CMLReactantList cmlReactants = new CMLReactantList();
        for (IAtomContainer iAtomContainer : reaction.getReactants().atomContainers()) {
            CMLReactant cmlReactant = new CMLReactant();
            cmlReactant.addMolecule(this.cdkAtomContainerToCMLMolecule(iAtomContainer));
            cmlReactants.addReactant(cmlReactant);
        }
        CMLProductList cMLProductList = new CMLProductList();
        for (IAtomContainer atomContainer : reaction.getProducts().atomContainers()) {
            CMLProduct cmlProduct = new CMLProduct();
            cmlProduct.addMolecule(this.cdkAtomContainerToCMLMolecule(atomContainer));
            cMLProductList.addProduct(cmlProduct);
        }
        CMLSubstanceList cMLSubstanceList = new CMLSubstanceList();
        for (IAtomContainer container : reaction.getAgents().atomContainers()) {
            CMLSubstance cmlSubstance = new CMLSubstance();
            cmlSubstance.addMolecule(this.cdkAtomContainerToCMLMolecule(container));
            cMLSubstanceList.addSubstance(cmlSubstance);
        }
        if (reaction.getID() != null) {
            cmlReaction.setId(reaction.getID());
        }
        cmlReaction.addReactantList(cmlReactants);
        cmlReaction.addProductList(cMLProductList);
        cmlReaction.addSubstanceList(cMLSubstanceList);
        return cmlReaction;
    }

    public CMLMolecule cdkCrystalToCMLMolecule(ICrystal crystal) {
        return this.cdkCrystalToCMLMolecule(crystal, true);
    }

    private CMLMolecule cdkCrystalToCMLMolecule(ICrystal crystal, boolean setIDs) {
        CMLMolecule molecule = this.cdkAtomContainerToCMLMolecule(crystal, false, false);
        CMLCrystal cmlCrystal = new CMLCrystal();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(crystal);
        }
        if (crystal.getID() != null && !crystal.getID().equals("")) {
            cmlCrystal.setId(crystal.getID());
        }
        this.checkPrefix(cmlCrystal);
        cmlCrystal.setZ(crystal.getZ());
        double[] params = CrystalGeometryTools.cartesianToNotional(crystal.getA(), crystal.getB(), crystal.getC());
        logger.debug("Number of cell params: ", params.length);
        cmlCrystal.setCellParameters(params);
        molecule.appendChild(cmlCrystal);
        return molecule;
    }

    public CMLMolecule cdkPDBPolymerToCMLMolecule(IPDBPolymer pdbPolymer) {
        return this.cdkPDBPolymerToCMLMolecule(pdbPolymer, true);
    }

    private CMLMolecule cdkPDBPolymerToCMLMolecule(IPDBPolymer pdbPolymer, boolean setIDs) {
        CMLMolecule cmlMolecule = new CMLMolecule();
        cmlMolecule.setConvention("PDB");
        cmlMolecule.setDictRef("pdb:model");
        Map<String, IStrand> mapS = pdbPolymer.getStrands();
        for (String key : mapS.keySet()) {
            IStrand strand = mapS.get(key);
            ArrayList<String> monomerNames = new ArrayList<String>(strand.getMonomerNames());
            Collections.sort(monomerNames);
            for (String name : monomerNames) {
                IMonomer monomer = strand.getMonomer(name);
                CMLMolecule clmono = this.cdkMonomerToCMLMolecule(monomer, true);
                cmlMolecule.appendChild(clmono);
            }
        }
        return cmlMolecule;
    }

    public CMLMolecule cdkMonomerToCMLMolecule(IMonomer monomer) {
        return this.cdkMonomerToCMLMolecule(monomer, true);
    }

    private CMLMolecule cdkMonomerToCMLMolecule(IMonomer monomer, boolean setIDs) {
        CMLMolecule cmlMolecule = new CMLMolecule();
        cmlMolecule.setDictRef("pdb:sequence");
        if (monomer.getMonomerName() != null && !monomer.getMonomerName().equals("")) {
            cmlMolecule.setId(monomer.getMonomerName());
        }
        for (int i = 0; i < monomer.getAtomCount(); ++i) {
            IAtom cdkAtom = monomer.getAtom(i);
            CMLAtom cmlAtom = this.cdkAtomToCMLAtom(monomer, cdkAtom);
            if (monomer.getConnectedSingleElectronsCount(cdkAtom) > 0) {
                cmlAtom.setSpinMultiplicity(monomer.getConnectedSingleElectronsCount(cdkAtom) + 1);
            }
            cmlMolecule.addAtom(cmlAtom);
        }
        return cmlMolecule;
    }

    public CMLMolecule cdkAtomContainerToCMLMolecule(IAtomContainer structure) {
        return this.cdkAtomContainerToCMLMolecule(structure, true, false);
    }

    private CMLMolecule cdkAtomContainerToCMLMolecule(IAtomContainer structure, boolean setIDs, boolean isRef) {
        CMLMolecule cmlMolecule = new CMLMolecule();
        if (this.useCMLIDs && setIDs) {
            IDCreator.createIDs(structure);
        }
        this.checkPrefix(cmlMolecule);
        if (structure.getID() != null && !structure.getID().equals("")) {
            if (!isRef) {
                cmlMolecule.setId(structure.getID());
            } else {
                cmlMolecule.setRef(structure.getID());
            }
        }
        if (structure.getTitle() != null) {
            cmlMolecule.setTitle(structure.getTitle());
        }
        if (structure.getProperty("cdk:InChI") != null) {
            CMLIdentifier ident = new CMLIdentifier();
            ident.setConvention("iupac:inchi");
            ident.setCMLValue(structure.getProperty("cdk:InChI").toString());
            cmlMolecule.appendChild(ident);
        }
        if (!isRef) {
            int i;
            for (i = 0; i < structure.getAtomCount(); ++i) {
                IAtom cdkAtom = structure.getAtom(i);
                CMLAtom cmlAtom = this.cdkAtomToCMLAtom(structure, cdkAtom);
                if (structure.getConnectedSingleElectronsCount(cdkAtom) > 0) {
                    cmlAtom.setSpinMultiplicity(structure.getConnectedSingleElectronsCount(cdkAtom) + 1);
                }
                cmlMolecule.addAtom(cmlAtom);
            }
            for (i = 0; i < structure.getBondCount(); ++i) {
                CMLBond cmlBond = this.cdkBondToCMLBond(structure.getBond(i));
                cmlMolecule.addBond(cmlBond);
            }
        }
        Map<Object, Object> props = structure.getProperties();
        for (Object key : props.keySet()) {
            if (key instanceof String && !isRef && props.get(key) instanceof String) {
                Object value = props.get(key);
                if (!key.toString().equals("cdk:Title") && !key.toString().equals("cdk:InChI")) {
                    CMLScalar scalar = new CMLScalar();
                    this.checkPrefix(scalar);
                    scalar.setDictRef("cdk:molecularProperty");
                    scalar.setTitle(key.toString());
                    scalar.setValue(value.toString());
                    cmlMolecule.addScalar(scalar);
                }
            }
            if (!(key instanceof String) || isRef || !key.toString().equals("cdk:Formula")) continue;
            if (props.get(key) instanceof IMolecularFormula) {
                IMolecularFormula cdkFormula = (IMolecularFormula)props.get(key);
                CMLFormula cmlFormula = new CMLFormula();
                List<IIsotope> isotopesList = MolecularFormulaManipulator.putInOrder(MolecularFormulaManipulator.generateOrderEle(), cdkFormula);
                for (IIsotope iIsotope : isotopesList) {
                    cmlFormula.add(iIsotope.getSymbol(), cdkFormula.getIsotopeCount(iIsotope));
                }
                cmlMolecule.appendChild(cmlFormula);
                continue;
            }
            if (!(props.get(key) instanceof IMolecularFormulaSet)) continue;
            IMolecularFormulaSet cdkFormulaSet = (IMolecularFormulaSet)props.get(key);
            for (IMolecularFormula cdkFormula : cdkFormulaSet.molecularFormulas()) {
                List<IIsotope> isotopesList = MolecularFormulaManipulator.putInOrder(MolecularFormulaManipulator.generateOrderEle(), cdkFormula);
                CMLFormula cmlFormula = new CMLFormula();
                cmlFormula.setDictRef("cdk:possibleMachts");
                for (IIsotope iIsotope : isotopesList) {
                    cmlFormula.add(iIsotope.getSymbol(), cdkFormula.getIsotopeCount(iIsotope));
                }
                cmlMolecule.appendChild(cmlFormula);
            }
        }
        for (String s : this.customizers.keySet()) {
            ICMLCustomizer customizer = this.customizers.get(s);
            try {
                customizer.customize(structure, (Object)cmlMolecule);
            }
            catch (Exception exception) {
                logger.error("Error while customizing CML output with customizer: ", customizer.getClass().getName());
                logger.debug(exception);
            }
        }
        return cmlMolecule;
    }

    private boolean addDictRef(IChemObject object, CMLElement cmlElement) {
        Map<Object, Object> properties = object.getProperties();
        for (Object key : properties.keySet()) {
            String keyName;
            if (!(key instanceof String) || !(keyName = (String)key).startsWith("org.openscience.cdk.dict")) continue;
            String dictRef = (String)properties.get(keyName);
            cmlElement.setProperty("dictRef", dictRef);
            return true;
        }
        return false;
    }

    private boolean addAtomID(IAtom cdkAtom, CMLAtom cmlAtom) {
        if (cdkAtom.getID() != null && !cdkAtom.getID().equals("")) {
            cmlAtom.setId(cdkAtom.getID());
        } else {
            cmlAtom.setId("a" + Integer.valueOf(cdkAtom.hashCode()).toString());
        }
        return true;
    }

    public CMLAtom cdkAtomToCMLAtom(IAtom cdkAtom) {
        return this.cdkAtomToCMLAtom(null, cdkAtom);
    }

    public CMLAtom cdkAtomToCMLAtom(IAtomContainer container, IAtom cdkAtom) {
        Integer totalHydrogen;
        CMLAtom cmlAtom = new CMLAtom();
        this.checkPrefix(cmlAtom);
        this.addAtomID(cdkAtom, cmlAtom);
        this.addDictRef(cdkAtom, cmlAtom);
        cmlAtom.setElementType(cdkAtom.getSymbol());
        if (cdkAtom instanceof IPseudoAtom) {
            String label = ((IPseudoAtom)cdkAtom).getLabel();
            if (label != null) {
                cmlAtom.setTitle(label);
            }
            cmlAtom.setElementType("Du");
        }
        this.map2DCoordsToCML(cmlAtom, cdkAtom);
        this.map3DCoordsToCML(cmlAtom, cdkAtom);
        this.mapFractionalCoordsToCML(cmlAtom, cdkAtom);
        Integer formalCharge = cdkAtom.getFormalCharge();
        if (formalCharge != null) {
            cmlAtom.setFormalCharge(formalCharge);
        }
        if ((totalHydrogen = cdkAtom.getImplicitHydrogenCount()) != null) {
            if (container != null) {
                for (IBond iBond : container.getConnectedBondsList(cdkAtom)) {
                    for (IAtom atom : iBond.atoms()) {
                        if (atom.getAtomicNumber() != 1 || Objects.equals(atom, cdkAtom)) continue;
                        Integer n = totalHydrogen;
                        Integer n2 = totalHydrogen = Integer.valueOf(totalHydrogen + 1);
                    }
                }
            }
            cmlAtom.setHydrogenCount(totalHydrogen);
        }
        Integer massNumber = cdkAtom.getMassNumber();
        if (!(cdkAtom instanceof IPseudoAtom) && massNumber != null) {
            cmlAtom.setIsotopeNumber(massNumber);
        }
        if (cdkAtom.getCharge() != CDKConstants.UNSET) {
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setDictRef("cdk:partialCharge");
            scalar.setValue(cdkAtom.getCharge());
            cmlAtom.addScalar(scalar);
        }
        this.writeProperties(cdkAtom, cmlAtom);
        if (cdkAtom.getFlag(32)) {
            CMLScalar aromAtom = new CMLScalar();
            aromAtom.setDictRef("cdk:aromaticAtom");
            cmlAtom.appendChild(aromAtom);
        }
        for (String s : this.customizers.keySet()) {
            ICMLCustomizer customizer = this.customizers.get(s);
            try {
                customizer.customize(cdkAtom, (Object)cmlAtom);
            }
            catch (Exception exception) {
                logger.error("Error while customizing CML output with customizer: ", customizer.getClass().getName());
                logger.debug(exception);
            }
        }
        return cmlAtom;
    }

    public CMLBond cdkBondToCMLBond(IBond cdkBond) {
        CMLBond cmlBond = new CMLBond();
        this.checkPrefix(cmlBond);
        if (cdkBond.getID() == null || cdkBond.getID().length() == 0) {
            cmlBond.setId("b" + cdkBond.hashCode());
        } else {
            cmlBond.setId(cdkBond.getID());
        }
        String[] atomRefArray = new String[cdkBond.getAtomCount()];
        for (int i = 0; i < cdkBond.getAtomCount(); ++i) {
            String atomID = cdkBond.getAtom(i).getID();
            atomRefArray[i] = atomID == null || atomID.length() == 0 ? "a" + Integer.valueOf(cdkBond.getAtom(i).hashCode()).toString() : atomID;
        }
        if (atomRefArray.length == 2) {
            cmlBond.setAtomRefs2(atomRefArray);
        } else {
            cmlBond.setAtomRefs(atomRefArray);
        }
        IBond.Order border = cdkBond.getOrder();
        if (border == IBond.Order.SINGLE) {
            cmlBond.setOrder("S");
        } else if (border == IBond.Order.DOUBLE) {
            cmlBond.setOrder("D");
        } else if (border == IBond.Order.TRIPLE) {
            cmlBond.setOrder("T");
        } else {
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setDictRef("cdk:bondOrder");
            scalar.setTitle("order");
            scalar.setValue(cdkBond.getOrder().numeric());
            cmlBond.appendChild(scalar);
        }
        if (cdkBond.getFlag(32)) {
            CMLBondType bType = new CMLBondType();
            bType.setDictRef("cdk:aromaticBond");
            cmlBond.appendChild(bType);
        }
        if (cdkBond.getStereo() == IBond.Stereo.UP || cdkBond.getStereo() == IBond.Stereo.DOWN) {
            CMLBondStereo bondStereo = new CMLBondStereo();
            this.checkPrefix(bondStereo);
            if (cdkBond.getStereo() == IBond.Stereo.UP) {
                bondStereo.setDictRef("cml:W");
                bondStereo.setXMLContent("W");
            } else {
                bondStereo.setDictRef("cml:H");
                bondStereo.setXMLContent("H");
            }
            cmlBond.appendChild(bondStereo);
        }
        if (cdkBond.getProperties().size() > 0) {
            this.writeProperties(cdkBond, cmlBond);
        }
        for (String s : this.customizers.keySet()) {
            ICMLCustomizer customizer = this.customizers.get(s);
            try {
                customizer.customize(cdkBond, (Object)cmlBond);
            }
            catch (Exception exception) {
                logger.error("Error while customizing CML output with customizer: ", customizer.getClass().getName());
                logger.debug(exception);
            }
        }
        return cmlBond;
    }

    private void writeProperties(IChemObject object, CMLElement cmlElement) {
        Map<Object, Object> props = object.getProperties();
        for (Object key : props.keySet()) {
            String stringKey;
            if (key instanceof DictRef) {
                Object value = props.get(key);
                CMLScalar scalar = new CMLScalar();
                this.checkPrefix(scalar);
                scalar.setDictRef(((DictRef)key).getType());
                scalar.setValue(value.toString());
                cmlElement.appendChild(scalar);
                continue;
            }
            if (!(key instanceof String) || (stringKey = (String)key).equals("cdk:Title") || stringKey.startsWith("org.openscience.cdk")) continue;
            Object value = props.get(key);
            CMLScalar scalar = new CMLScalar();
            this.checkPrefix(scalar);
            scalar.setTitle((String)key);
            scalar.setValue(value.toString());
            cmlElement.appendChild(scalar);
        }
    }

    private void mapFractionalCoordsToCML(CMLAtom cmlAtom, IAtom cdkAtom) {
        if (cdkAtom.getFractionalPoint3d() != null) {
            cmlAtom.setXFract(cdkAtom.getFractionalPoint3d().x);
            cmlAtom.setYFract(cdkAtom.getFractionalPoint3d().y);
            cmlAtom.setZFract(cdkAtom.getFractionalPoint3d().z);
        }
    }

    private void map3DCoordsToCML(CMLAtom cmlAtom, IAtom cdkAtom) {
        if (cdkAtom.getPoint3d() != null) {
            cmlAtom.setX3(cdkAtom.getPoint3d().x);
            cmlAtom.setY3(cdkAtom.getPoint3d().y);
            cmlAtom.setZ3(cdkAtom.getPoint3d().z);
        }
    }

    private void map2DCoordsToCML(CMLAtom cmlAtom, IAtom cdkAtom) {
        if (cdkAtom.getPoint2d() != null) {
            cmlAtom.setX2(cdkAtom.getPoint2d().x);
            cmlAtom.setY2(cdkAtom.getPoint2d().y);
        }
    }

    private void checkPrefix(CMLElement element) {
        if (this.prefix != null) {
            this.prefix = this.prefix.trim();
            if (this.prefix.length() == 0) {
                this.prefix = null;
            }
        }
        if (this.prefix != null) {
            element.setNamespacePrefix(this.prefix);
        }
    }
}

