/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.io.IOException;
import java.util.Iterator;
import javax.vecmath.Point3d;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class InductiveAtomicSoftnessDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] NAMES = new String[]{"indAtomSoftness"};
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(InductiveAtomicSoftnessDescriptor.class);
    private AtomTypeFactory factory = null;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#atomicSoftness", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return NAMES;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(Double.NaN), NAMES, e);
    }

    @Override
    public DescriptorValue calculate(IAtom atom, IAtomContainer ac) {
        double radiusTarget;
        IAtomType type;
        String symbol;
        if (this.factory == null) {
            try {
                this.factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/jmol_atomtypes.txt", ac.getBuilder());
            }
            catch (Exception exception) {
                return this.getDummyDescriptorValue(exception);
            }
        }
        Iterator<IAtom> allAtoms = ac.atoms().iterator();
        double atomicSoftness = 0.0;
        try {
            symbol = atom.getSymbol();
            type = this.factory.getAtomType(symbol);
            radiusTarget = type.getCovalentRadius();
        }
        catch (Exception execption) {
            logger.debug(execption);
            return this.getDummyDescriptorValue(execption);
        }
        while (allAtoms.hasNext()) {
            IAtom curAtom = allAtoms.next();
            if (atom.getPoint3d() == null || curAtom.getPoint3d() == null) {
                return this.getDummyDescriptorValue(new CDKException("The target atom or current atom had no 3D coordinates. These are required"));
            }
            if (atom.equals(curAtom)) continue;
            double partial = 0.0;
            symbol = curAtom.getSymbol();
            try {
                type = this.factory.getAtomType(symbol);
            }
            catch (Exception exception) {
                logger.debug(exception);
                return this.getDummyDescriptorValue(exception);
            }
            double radius = type.getCovalentRadius();
            partial += radius * radius;
            partial += radiusTarget * radiusTarget;
            atomicSoftness += (partial /= this.calculateSquareDistanceBetweenTwoAtoms(curAtom, atom));
        }
        atomicSoftness = 2.0 * atomicSoftness;
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new DoubleResult(atomicSoftness *= 0.172), NAMES);
    }

    private double calculateSquareDistanceBetweenTwoAtoms(IAtom atom1, IAtom atom2) {
        Point3d firstPoint = atom1.getPoint3d();
        Point3d secondPoint = atom2.getPoint3d();
        double tmp = firstPoint.distance(secondPoint);
        double distance = tmp * tmp;
        return distance;
    }

    @Override
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }
}

