/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class WHIMDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(WHIMDescriptor.class);
    String type = "unity";
    final Map<String, Double> hashatwt = new HashMap<String, Double>();
    final Map<String, Double> hashvdw = new HashMap<String, Double>();
    final Map<String, Double> hasheneg = new HashMap<String, Double>();
    final Map<String, Double> hashpol = new HashMap<String, Double>();

    public WHIMDescriptor() {
        this.hashatwt.put("H", 0.084);
        this.hashatwt.put("B", 0.9);
        this.hashatwt.put("C", 1.0);
        this.hashatwt.put("N", 1.166);
        this.hashatwt.put("O", 1.332);
        this.hashatwt.put("F", 1.582);
        this.hashatwt.put("Al", 2.246);
        this.hashatwt.put("Si", 2.339);
        this.hashatwt.put("P", 2.579);
        this.hashatwt.put("S", 2.67);
        this.hashatwt.put("Cl", 2.952);
        this.hashatwt.put("Fe", 4.65);
        this.hashatwt.put("Co", 4.907);
        this.hashatwt.put("Ni", 4.887);
        this.hashatwt.put("Cu", 5.291);
        this.hashatwt.put("Zn", 5.445);
        this.hashatwt.put("Br", 6.653);
        this.hashatwt.put("Sn", 9.884);
        this.hashatwt.put("I", 10.566);
        this.hashvdw.put("H", 0.299);
        this.hashvdw.put("B", 0.796);
        this.hashvdw.put("C", 1.0);
        this.hashvdw.put("N", 0.695);
        this.hashvdw.put("O", 0.512);
        this.hashvdw.put("F", 0.41);
        this.hashvdw.put("Al", 1.626);
        this.hashvdw.put("Si", 1.424);
        this.hashvdw.put("P", 1.181);
        this.hashvdw.put("S", 1.088);
        this.hashvdw.put("Cl", 1.035);
        this.hashvdw.put("Fe", 1.829);
        this.hashvdw.put("Co", 1.561);
        this.hashvdw.put("Ni", 0.764);
        this.hashvdw.put("Cu", 0.512);
        this.hashvdw.put("Zn", 1.708);
        this.hashvdw.put("Br", 1.384);
        this.hashvdw.put("Sn", 2.042);
        this.hashvdw.put("I", 1.728);
        this.hasheneg.put("H", 0.944);
        this.hasheneg.put("B", 0.828);
        this.hasheneg.put("C", 1.0);
        this.hasheneg.put("N", 1.163);
        this.hasheneg.put("O", 1.331);
        this.hasheneg.put("F", 1.457);
        this.hasheneg.put("Al", 0.624);
        this.hasheneg.put("Si", 0.779);
        this.hasheneg.put("P", 0.916);
        this.hasheneg.put("S", 1.077);
        this.hasheneg.put("Cl", 1.265);
        this.hasheneg.put("Fe", 0.728);
        this.hasheneg.put("Co", 0.728);
        this.hasheneg.put("Ni", 0.728);
        this.hasheneg.put("Cu", 0.74);
        this.hasheneg.put("Zn", 0.81);
        this.hasheneg.put("Br", 1.172);
        this.hasheneg.put("Sn", 0.837);
        this.hasheneg.put("I", 1.012);
        this.hashpol.put("H", 0.379);
        this.hashpol.put("B", 1.722);
        this.hashpol.put("C", 1.0);
        this.hashpol.put("N", 0.625);
        this.hashpol.put("O", 0.456);
        this.hashpol.put("F", 0.316);
        this.hashpol.put("Al", 3.864);
        this.hashpol.put("Si", 3.057);
        this.hashpol.put("P", 2.063);
        this.hashpol.put("S", 1.648);
        this.hashpol.put("Cl", 1.239);
        this.hashpol.put("Fe", 4.773);
        this.hashpol.put("Co", 4.261);
        this.hashpol.put("Ni", 3.864);
        this.hashpol.put("Cu", 3.466);
        this.hashpol.put("Zn", 4.034);
        this.hashpol.put("Br", 1.733);
        this.hashpol.put("Sn", 4.375);
        this.hashpol.put("I", 3.04);
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#WHIM", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("WHIMDescriptor requires 1 parameter");
        }
        if (!(params[0] instanceof String)) {
            throw new CDKException("Parameters must be of type String");
        }
        this.type = (String)params[0];
        if (!(this.type.equals("unity") || this.type.equals("mass") || this.type.equals("volume") || this.type.equals("eneg") || this.type.equals("polar"))) {
            throw new CDKException("Weighting scheme must be one of those specified in the API");
        }
    }

    @Override
    public Object[] getParameters() {
        Object[] o = new Object[]{this.type};
        return o;
    }

    @Override
    public String[] getDescriptorNames() {
        String[] names = new String[]{"Wlambda1", "Wlambda2", "Wlambda3", "Wnu1", "Wnu2", "Wgamma1", "Wgamma2", "Wgamma3", "Weta1", "Weta2", "Weta3", "WT", "WA", "WV", "WK", "WG", "WD"};
        int i = 0;
        while (i < names.length) {
            int n = i++;
            names[n] = names[n] + "." + this.type;
        }
        return names;
    }

    @Override
    public String[] getParameterNames() {
        String[] pname = new String[]{"type"};
        return pname;
    }

    @Override
    public Object getParameterType(String name) {
        return "";
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        int i;
        int i2;
        int i3;
        int i4;
        IAtomContainer ac;
        if (!GeometryUtil.has3DCoordinates(container)) {
            return this.getDummyDescriptorValue(new CDKException("Molecule must have 3D coordinates"));
        }
        double sum = 0.0;
        try {
            ac = container.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        double[][] cmat = new double[ac.getAtomCount()][3];
        for (int i5 = 0; i5 < ac.getAtomCount(); ++i5) {
            Point3d coords = ac.getAtom(i5).getPoint3d();
            cmat[i5][0] = coords.x;
            cmat[i5][1] = coords.y;
            cmat[i5][2] = coords.z;
        }
        Map<String, Double> hash = null;
        double[] wt = new double[ac.getAtomCount()];
        if (this.type.equals("unity")) {
            for (i4 = 0; i4 < ac.getAtomCount(); ++i4) {
                wt[i4] = 1.0;
            }
        } else {
            if (this.type.equals("mass")) {
                hash = this.hashatwt;
            } else if (this.type.equals("volume")) {
                hash = this.hashvdw;
            } else if (this.type.equals("eneg")) {
                hash = this.hasheneg;
            } else if (this.type.equals("polar")) {
                hash = this.hashpol;
            }
            for (i4 = 0; i4 < ac.getAtomCount(); ++i4) {
                String sym = ac.getAtom(i4).getSymbol();
                wt[i4] = hash.get(sym);
            }
        }
        PCA pcaobject = null;
        try {
            pcaobject = new PCA(cmat, wt);
        }
        catch (CDKException cdke) {
            logger.debug(cdke);
        }
        double[] lambda = pcaobject.getEigenvalues();
        double[] gamma = new double[3];
        double[] nu = new double[3];
        double[] eta = new double[3];
        for (i3 = 0; i3 < 3; ++i3) {
            sum += lambda[i3];
        }
        for (i3 = 0; i3 < 3; ++i3) {
            nu[i3] = lambda[i3] / sum;
        }
        double[][] scores = pcaobject.getScores();
        for (i2 = 0; i2 < 3; ++i2) {
            sum = 0.0;
            for (int j = 0; j < ac.getAtomCount(); ++j) {
                sum += scores[j][i2] * scores[j][i2] * scores[j][i2] * scores[j][i2];
            }
            eta[i2] = 1.0 / (sum /= lambda[i2] * lambda[i2] * (double)ac.getAtomCount());
        }
        for (i2 = 0; i2 < 3; ++i2) {
            double ns = 0.0;
            double na = 0.0;
            for (int j = 0; j < ac.getAtomCount(); ++j) {
                boolean foundmatch = false;
                for (int k = 0; k < ac.getAtomCount(); ++k) {
                    if (k == j || scores[j][i2] != -1.0 * scores[k][i2]) continue;
                    ns += 1.0;
                    foundmatch = true;
                    break;
                }
                if (foundmatch) continue;
                na += 1.0;
            }
            double n = ac.getAtomCount();
            gamma[i2] = -1.0 * (ns / n * Math.log(ns / n) / Math.log(2.0) + na / n * Math.log(1.0 / n) / Math.log(2.0));
            gamma[i2] = 1.0 / (1.0 + gamma[i2]);
        }
        double t = lambda[0] + lambda[1] + lambda[2];
        double a = lambda[0] * lambda[1] + lambda[0] * lambda[2] + lambda[1] * lambda[2];
        double v = t + a + lambda[0] * lambda[1] * lambda[2];
        double k = 0.0;
        sum = 0.0;
        for (i = 0; i < 3; ++i) {
            sum += lambda[i];
        }
        if (sum == 0.0) {
            return this.getDummyDescriptorValue(new ArithmeticException("Lambda sum was 0, cannot divide by 0!"));
        }
        for (i = 0; i < 3; ++i) {
            k = lambda[i] / sum - 0.3333333333333333;
        }
        k /= 1.3333333333333333;
        double g = Math.pow(gamma[0] * gamma[1] * gamma[2], 0.3333333333333333);
        double d = eta[0] + eta[1] + eta[2];
        DoubleArrayResult retval = new DoubleArrayResult(17);
        retval.add(lambda[0]);
        retval.add(lambda[1]);
        retval.add(lambda[2]);
        retval.add(nu[0]);
        retval.add(nu[1]);
        retval.add(gamma[0]);
        retval.add(gamma[1]);
        retval.add(gamma[2]);
        retval.add(eta[0]);
        retval.add(eta[1]);
        retval.add(eta[2]);
        retval.add(t);
        retval.add(a);
        retval.add(v);
        retval.add(k);
        retval.add(g);
        retval.add(d);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(17);
    }

    class PCA {
        Matrix evec;
        Matrix t;
        double[] eval;

        public PCA(double[][] cmat, double[] wt) throws CDKException {
            int i;
            int ncol = 3;
            int nrow = wt.length;
            if (cmat.length != wt.length) {
                throw new CDKException("WHIMDescriptor: number of weights should be equal to number of atoms");
            }
            double[][] d = new double[nrow][ncol];
            for (i = 0; i < nrow; ++i) {
                for (int j = 0; j < ncol; ++j) {
                    d[i][j] = cmat[i][j];
                }
            }
            for (i = 0; i < ncol; ++i) {
                int j;
                double mean = 0.0;
                for (j = 0; j < nrow; ++j) {
                    mean += d[j][i];
                }
                mean /= (double)nrow;
                for (j = 0; j < nrow; ++j) {
                    d[j][i] = d[j][i] - mean;
                }
            }
            double[][] covmat = new double[ncol][ncol];
            double sumwt = 0.0;
            for (double v : wt) {
                sumwt += v;
            }
            for (int i2 = 0; i2 < ncol; ++i2) {
                double meanx = 0.0;
                for (int k = 0; k < nrow; ++k) {
                    meanx += d[k][i2];
                }
                meanx /= (double)nrow;
                for (int j = 0; j < ncol; ++j) {
                    double meany = 0.0;
                    for (int k = 0; k < nrow; ++k) {
                        meany += d[k][j];
                    }
                    meany /= (double)nrow;
                    double sum = 0.0;
                    for (int k = 0; k < nrow; ++k) {
                        sum += wt[k] * (d[k][i2] - meanx) * (d[k][j] - meany);
                    }
                    covmat[i2][j] = sum / sumwt;
                }
            }
            Matrix m = new Matrix(covmat);
            EigenvalueDecomposition ed = m.eig();
            this.eval = ed.getRealEigenvalues();
            this.evec = ed.getV();
            Matrix x = new Matrix(d);
            this.t = x.times(this.evec);
        }

        double[] getEigenvalues() {
            return this.eval;
        }

        double[][] getScores() {
            return this.t.getArray();
        }
    }
}

