/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.protein;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class TaeAminoAcidDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(TaeAminoAcidDescriptor.class);
    private Map<String, Double[]> taeParams = new HashMap<String, Double[]>();
    private final int ndesc = 147;
    private final Map<String, String> nametrans = new HashMap<String, String>();

    private List<IMonomer> getMonomers(IBioPolymer iBioPolymer) {
        ArrayList<IMonomer> monomList = new ArrayList<IMonomer>();
        Map<String, IStrand> strands = iBioPolymer.getStrands();
        Set<String> strandKeys = strands.keySet();
        for (String key : strandKeys) {
            IStrand aStrand = strands.get(key);
            Map<String, IMonomer> tmp = aStrand.getMonomers();
            Set<String> keys = tmp.keySet();
            for (String o1 : keys) {
                monomList.add(tmp.get(o1));
            }
        }
        return monomList;
    }

    private void loadTAEParams() {
        String filename = "org/openscience/cdk/qsar/descriptors/data/taepeptides.txt";
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(filename);
        if (ins == null) {
            logger.debug("Could not load the TAE peptide parameter data file");
            this.taeParams = null;
            return;
        }
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(ins));
            String header = breader.readLine();
            if (header == null) {
                throw new IllegalStateException("Expected a header");
            }
            for (int i = 0; i < 60; ++i) {
                String line = breader.readLine();
                String[] components = line.split(",");
                if (components.length != 148) {
                    throw new CDKException("TAE peptide data table seems to be corrupt");
                }
                String key = components[0].toLowerCase().trim();
                Double[] data = new Double[147];
                for (int j = 1; j < components.length; ++j) {
                    data[j - 1] = new Double(components[j]);
                }
                this.taeParams.put(key, data);
            }
        }
        catch (IOException | CDKException ioe) {
            LoggingToolFactory.createLoggingTool(TaeAminoAcidDescriptor.class).warn("Unexpected Error:", ioe);
            this.taeParams = null;
            return;
        }
        logger.debug("Loaded " + this.taeParams.size() + " TAE parameters for amino acids");
    }

    public TaeAminoAcidDescriptor() {
        this.nametrans.put("a", "ala");
        this.nametrans.put("c", "cys");
        this.nametrans.put("d", "asp");
        this.nametrans.put("e", "glu");
        this.nametrans.put("f", "phe");
        this.nametrans.put("g", "gly");
        this.nametrans.put("h", "his");
        this.nametrans.put("i", "ile");
        this.nametrans.put("k", "lys");
        this.nametrans.put("l", "leu");
        this.nametrans.put("m", "met");
        this.nametrans.put("n", "asn");
        this.nametrans.put("p", "pro");
        this.nametrans.put("q", "gln");
        this.nametrans.put("r", "arg");
        this.nametrans.put("s", "ser");
        this.nametrans.put("t", "thr");
        this.nametrans.put("v", "val");
        this.nametrans.put("w", "trp");
        this.nametrans.put("y", "tyr");
        this.loadTAEParams();
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#taeAminoAcid", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        String[] names = new String[147];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "TAE" + i;
        }
        return names;
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        int ndesc = this.getDescriptorNames().length;
        DoubleArrayResult results = new DoubleArrayResult(ndesc);
        for (int i = 0; i < ndesc; ++i) {
            results.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        if (this.taeParams == null) {
            return this.getDummyDescriptorValue(new CDKException("TAE parameters were not initialized"));
        }
        if (!(container instanceof IBioPolymer)) {
            return this.getDummyDescriptorValue(new CDKException("The molecule should be of type IBioPolymer"));
        }
        IBioPolymer peptide = (IBioPolymer)container;
        double[] desc = new double[147];
        for (int i = 0; i < 147; ++i) {
            desc[i] = 0.0;
        }
        List<IMonomer> monomers = this.getMonomers(peptide);
        for (IMonomer monomer : monomers) {
            String o = monomer.getMonomerName();
            if (o.length() == 0) continue;
            String olc = String.valueOf(o.toLowerCase().charAt(0));
            String tlc = this.nametrans.get(olc);
            logger.debug("Converted " + olc + " to " + tlc);
            Double[] params = this.taeParams.get(tlc);
            for (int i = 0; i < 147; ++i) {
                int n = i;
                desc[n] = desc[n] + params[i];
            }
        }
        DoubleArrayResult retval = new DoubleArrayResult(147);
        for (int i = 0; i < 147; ++i) {
            retval.add(desc[i]);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(147);
    }
}

