/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.vecmath.Point2d;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.TextGroupElement;
import org.openscience.cdk.renderer.generators.AtomNumberGenerator;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class ExtendedAtomGenerator
extends BasicAtomGenerator {
    private final IGeneratorParameter<Boolean> showImplicitHydrogens = new ShowImplicitHydrogens();
    private final ShowAtomTypeNames showAtomTypeNames = new ShowAtomTypeNames();

    @Override
    public IRenderingElement generate(IAtomContainer container, IAtom atom, RendererModel model) {
        boolean drawNumbers = false;
        if (model.hasParameter(AtomNumberGenerator.WillDrawAtomNumbers.class)) {
            drawNumbers = (Boolean)model.getParameter(AtomNumberGenerator.WillDrawAtomNumbers.class).getValue();
        }
        if (!this.hasCoordinates(atom) || this.invisibleHydrogen(atom, model) || this.invisibleCarbon(atom, container, model) && !drawNumbers) {
            return null;
        }
        if (((Boolean)model.getParameter(BasicAtomGenerator.CompactAtom.class).getValue()).booleanValue()) {
            return this.generateCompactElement(atom, model);
        }
        String text = atom instanceof IPseudoAtom ? ((IPseudoAtom)atom).getLabel() : (this.invisibleCarbon(atom, container, model) && drawNumbers ? String.valueOf(container.indexOf(atom) + 1) : atom.getSymbol());
        Point2d point = atom.getPoint2d();
        Color ccolor = this.getAtomColor(atom, model);
        TextGroupElement textGroup = new TextGroupElement(point.x, point.y, text, ccolor);
        this.decorate(textGroup, container, atom, model);
        return textGroup;
    }

    private void decorate(TextGroupElement textGroup, IAtomContainer container, IAtom atom, RendererModel model) {
        Integer massNumber;
        int hCount;
        TextGroupElement.Position position;
        Stack<TextGroupElement.Position> unused = this.getUnusedPositions(container, atom);
        if (model.hasParameter(AtomNumberGenerator.WillDrawAtomNumbers.class)) {
            boolean drawNumbers = (Boolean)model.getParameter(AtomNumberGenerator.WillDrawAtomNumbers.class).getValue();
            if (!this.invisibleCarbon(atom, container, model) && drawNumbers) {
                position = this.getNextPosition(unused);
                String number = String.valueOf(container.indexOf(atom) + 1);
                textGroup.addChild(number, position);
            }
        }
        if (this.showImplicitHydrogens.getValue().booleanValue() && atom.getImplicitHydrogenCount() != null && (hCount = atom.getImplicitHydrogenCount().intValue()) > 0) {
            position = this.getNextPosition(unused);
            if (hCount == 1) {
                textGroup.addChild("H", position);
            } else {
                textGroup.addChild("H", String.valueOf(hCount), position);
            }
        }
        if ((massNumber = atom.getMassNumber()) != null) {
            try {
                Isotopes factory = Isotopes.getInstance();
                int majorMass = factory.getMajorIsotope(atom.getSymbol()).getMassNumber();
                if (massNumber != majorMass) {
                    TextGroupElement.Position position2 = this.getNextPosition(unused);
                    textGroup.addChild(String.valueOf(massNumber), position2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private TextGroupElement.Position getNextPosition(Stack<TextGroupElement.Position> unused) {
        if (unused.size() > 0) {
            return unused.pop();
        }
        return TextGroupElement.Position.N;
    }

    private Stack<TextGroupElement.Position> getUnusedPositions(IAtomContainer container, IAtom atom) {
        Stack<TextGroupElement.Position> unused = new Stack<TextGroupElement.Position>();
        for (TextGroupElement.Position p : TextGroupElement.Position.values()) {
            unused.add(p);
        }
        for (IAtom connectedAtom : container.getConnectedAtomsList(atom)) {
            TextGroupElement.Position used = this.getPosition(atom, connectedAtom);
            if (!unused.contains((Object)used)) continue;
            unused.remove((Object)used);
        }
        return unused;
    }

    private TextGroupElement.Position getPosition(IAtom atom, IAtom connectedAtom) {
        Point2d pointA = atom.getPoint2d();
        Point2d pointB = connectedAtom.getPoint2d();
        double diffx = pointB.x - pointA.x;
        double diffy = pointB.y - pointA.y;
        double DELTA = 0.2;
        if (diffx < -0.2) {
            if (diffy < -0.2) {
                return TextGroupElement.Position.NW;
            }
            if (diffy > -0.2 && diffy < 0.2) {
                return TextGroupElement.Position.W;
            }
            return TextGroupElement.Position.SW;
        }
        if (diffx > -0.2 && diffx < 0.2) {
            if (diffy < -0.2) {
                return TextGroupElement.Position.N;
            }
            if (diffy > -0.2 && diffy < 0.2) {
                return TextGroupElement.Position.N;
            }
            return TextGroupElement.Position.S;
        }
        if (diffy < -0.2) {
            return TextGroupElement.Position.NE;
        }
        if (diffy > -0.2 && diffy < 0.2) {
            return TextGroupElement.Position.E;
        }
        return TextGroupElement.Position.SE;
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        ArrayList parameters = new ArrayList();
        parameters.add(this.showImplicitHydrogens);
        parameters.add(this.showAtomTypeNames);
        parameters.addAll(super.getParameters());
        return parameters;
    }

    public static class ShowAtomTypeNames
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.FALSE;
        }
    }

    public static class ShowImplicitHydrogens
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return Boolean.TRUE;
        }
    }
}

