/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.silent.AtomContainerSet;
import org.openscience.cdk.silent.ChemObject;
import org.openscience.cdk.silent.RingSet;

public class ChemModel
extends ChemObject
implements Serializable,
IChemModel,
IChemObjectListener,
Cloneable {
    private static final long serialVersionUID = -5213425310451366185L;
    protected IAtomContainerSet setOfMolecules = null;
    protected IReactionSet setOfReactions = null;
    protected IRingSet ringSet = null;
    protected ICrystal crystal = null;

    @Override
    public IAtomContainerSet getMoleculeSet() {
        return this.setOfMolecules;
    }

    @Override
    public void setMoleculeSet(IAtomContainerSet setOfMolecules) {
        this.setOfMolecules = setOfMolecules;
    }

    @Override
    public IRingSet getRingSet() {
        return this.ringSet;
    }

    @Override
    public void setRingSet(IRingSet ringSet) {
        this.ringSet = ringSet;
    }

    @Override
    public ICrystal getCrystal() {
        return this.crystal;
    }

    @Override
    public void setCrystal(ICrystal crystal) {
        this.crystal = crystal;
    }

    @Override
    public IReactionSet getReactionSet() {
        return this.setOfReactions;
    }

    @Override
    public void setReactionSet(IReactionSet sor) {
        this.setOfReactions = sor;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append("ChemModel(");
        buffer.append(this.hashCode());
        if (this.getMoleculeSet() != null) {
            buffer.append(", ");
            buffer.append(this.getMoleculeSet().toString());
        }
        if (this.getCrystal() != null) {
            buffer.append(", ");
            buffer.append(this.getCrystal().toString());
        }
        if (this.getReactionSet() != null) {
            buffer.append(", ");
            buffer.append(this.getReactionSet().toString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChemModel clone = (ChemModel)super.clone();
        clone.setOfMolecules = this.setOfMolecules != null ? (AtomContainerSet)this.setOfMolecules.clone() : null;
        clone.setOfReactions = this.setOfReactions != null ? (IReactionSet)this.setOfReactions.clone() : null;
        clone.crystal = this.crystal != null ? this.crystal.clone() : null;
        clone.ringSet = this.ringSet != null ? (RingSet)this.ringSet.clone() : null;
        return clone;
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
    }

    @Override
    public boolean isEmpty() {
        if (this.setOfMolecules != null && !this.setOfMolecules.isEmpty()) {
            return false;
        }
        if (this.setOfReactions != null && !this.setOfReactions.isEmpty()) {
            return false;
        }
        if (this.ringSet != null && !this.ringSet.isEmpty()) {
            return false;
        }
        return this.crystal == null || this.crystal.isEmpty();
    }
}

