/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.silent.ChemModel;
import org.openscience.cdk.silent.ChemObject;

public class ChemSequence
extends ChemObject
implements Serializable,
IChemSequence,
IChemObjectListener,
Cloneable {
    private static final long serialVersionUID = 2199218627455492000L;
    protected IChemModel[] chemModels = new ChemModel[4];
    protected int chemModelCount = 0;
    protected final int growArraySize = 4;

    @Override
    public void addChemModel(IChemModel chemModel) {
        if (this.chemModelCount + 1 >= this.chemModels.length) {
            this.growChemModelArray();
        }
        this.chemModels[this.chemModelCount] = chemModel;
        ++this.chemModelCount;
    }

    @Override
    public void removeChemModel(int pos) {
        for (int i = pos; i < this.chemModelCount - 1; ++i) {
            this.chemModels[i] = this.chemModels[i + 1];
        }
        this.chemModels[this.chemModelCount - 1] = null;
        --this.chemModelCount;
    }

    @Override
    public Iterable<IChemModel> chemModels() {
        return () -> new ChemModelIterator();
    }

    @Override
    public IChemModel getChemModel(int number) {
        return this.chemModels[number];
    }

    protected void growChemModelArray() {
        ChemModel[] newchemModels = new ChemModel[this.chemModels.length + 4];
        System.arraycopy(this.chemModels, 0, newchemModels, 0, this.chemModels.length);
        this.chemModels = newchemModels;
    }

    @Override
    public int getChemModelCount() {
        return this.chemModelCount;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("ChemSequence(#M=");
        buffer.append(this.chemModelCount);
        if (this.chemModelCount > 0) {
            buffer.append(", ");
            for (int i = 0; i < this.chemModelCount; ++i) {
                buffer.append(this.chemModels[i].toString());
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ChemSequence clone = (ChemSequence)super.clone();
        clone.chemModelCount = this.getChemModelCount();
        clone.chemModels = new ChemModel[clone.chemModelCount];
        for (int f = 0; f < clone.chemModelCount; ++f) {
            clone.chemModels[f] = (ChemModel)this.chemModels[f].clone();
        }
        return clone;
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
    }

    private class ChemModelIterator
    implements Iterator<IChemModel> {
        private int pointer = 0;

        private ChemModelIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < ChemSequence.this.chemModelCount;
        }

        @Override
        public IChemModel next() {
            if (this.pointer >= ChemSequence.this.chemModelCount) {
                throw new NoSuchElementException();
            }
            return ChemSequence.this.chemModels[this.pointer++];
        }

        @Override
        public void remove() {
            ChemSequence.this.removeChemModel(--this.pointer);
        }
    }
}

