/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles.smarts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.openscience.cdk.ReactionRole;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@Deprecated
final class SmartsAtomAtomMapFilter
implements Predicate<int[]> {
    private final List<MappedPairs> mapped = new ArrayList<MappedPairs>();
    private final IAtomContainer target;

    SmartsAtomAtomMapFilter(IAtomContainer query, IAtomContainer target) {
        HashMap<Integer, List> reactInvMap = null;
        HashMap<Integer, List> prodInvMap = null;
        this.target = target;
        int numAtoms = query.getAtomCount();
        block4: for (int idx = 0; idx < numAtoms; ++idx) {
            IAtom atom = query.getAtom(idx);
            int mapidx = this.mapidx(atom);
            if (mapidx == 0) continue;
            switch (this.role(atom)) {
                case Reactant: {
                    if (reactInvMap == null) {
                        reactInvMap = new HashMap<Integer, List>();
                    }
                    reactInvMap.computeIfAbsent(mapidx, k -> new ArrayList()).add(idx);
                    continue block4;
                }
                case Product: {
                    if (prodInvMap == null) {
                        prodInvMap = new HashMap<Integer, List>();
                    }
                    prodInvMap.computeIfAbsent(mapidx, k -> new ArrayList()).add(idx);
                }
            }
        }
        if (reactInvMap != null && prodInvMap != null) {
            for (Map.Entry e : reactInvMap.entrySet()) {
                int[] reacMaps = ((List)e.getValue()).stream().mapToInt(i -> i).toArray();
                int[] prodMaps = ((List)prodInvMap.get(e.getKey())).stream().mapToInt(i -> i).toArray();
                if (prodMaps.length == 0) continue;
                this.mapped.add(new MappedPairs(reacMaps, prodMaps));
            }
        }
    }

    private int mapidx(IAtom atom) {
        Integer mapidx = (Integer)atom.getProperty("cdk:AtomAtomMapping");
        if (mapidx != null) {
            return mapidx;
        }
        return 0;
    }

    private ReactionRole role(IAtom atom) {
        ReactionRole role = (ReactionRole)((Object)atom.getProperty("cdk:ReactionRole"));
        if (role != null) {
            return role;
        }
        return ReactionRole.None;
    }

    @Override
    public boolean test(int[] perm) {
        for (MappedPairs mpair : this.mapped) {
            if (mpair.rIdxs.length > 1) {
                HashSet<Integer> bound = new HashSet<Integer>();
                for (int rIdx : mpair.rIdxs) {
                    int refidx = this.mapidx(this.target.getAtom(perm[rIdx]));
                    if (refidx == 0) {
                        return false;
                    }
                    bound.add(refidx);
                }
                for (int pIdx : mpair.pIdxs) {
                    if (bound.contains(this.mapidx(this.target.getAtom(perm[pIdx])))) continue;
                    return false;
                }
                continue;
            }
            int refidx = this.mapidx(this.target.getAtom(perm[mpair.rIdxs[0]]));
            if (refidx == 0) {
                return false;
            }
            if (refidx != this.mapidx(this.target.getAtom(perm[mpair.pIdxs[0]]))) {
                return false;
            }
            for (int i = 1; i < mpair.pIdxs.length; ++i) {
                if (refidx == this.mapidx(this.target.getAtom(perm[mpair.pIdxs[i]]))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean apply(int[] ints) {
        return this.test(ints);
    }

    private final class MappedPairs {
        final int[] rIdxs;
        final int[] pIdxs;

        private MappedPairs(int[] rIdxs, int[] pIdxs) {
            this.rIdxs = rIdxs;
            this.pIdxs = pIdxs;
        }

        public String toString() {
            return "{" + Arrays.toString(this.rIdxs) + "=>" + Arrays.toString(this.pIdxs) + "}";
        }
    }
}

