/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen.stochastic;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.SaturationChecker;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class PartialFilledStructureMerger {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(PartialFilledStructureMerger.class);
    final SaturationChecker satCheck = new SaturationChecker();

    public IAtomContainer generate(IAtomContainerSet atomContainers) throws CDKException {
        int iteration = 0;
        boolean structureFound = false;
        do {
            boolean bondFormed;
            ++iteration;
            do {
                bondFormed = false;
                for (IAtomContainer ac : atomContainers.atomContainers()) {
                    for (IAtom atom : AtomContainerManipulator.getAtomArray(ac)) {
                        IAtom partner;
                        if (this.satCheck.isSaturated(atom, ac) || (partner = this.getAnotherUnsaturatedNode(atom, ac, atomContainers)) == null) continue;
                        IAtomContainer toadd = AtomContainerSetManipulator.getRelevantAtomContainer(atomContainers, partner);
                        double cmax1 = this.satCheck.getCurrentMaxBondOrder(atom, ac);
                        double cmax2 = this.satCheck.getCurrentMaxBondOrder(partner, toadd);
                        double max = Math.min(cmax1, cmax2);
                        double order = Math.min(Math.max(1.0, max), 3.0);
                        this.logger.debug("cmax1, cmax2, max, order: " + cmax1 + ", " + cmax2 + ", " + max + ", " + order);
                        if (toadd != ac) {
                            atomContainers.removeAtomContainer(toadd);
                            ac.add(toadd);
                        }
                        ac.addBond(ac.getBuilder().newInstance(IBond.class, new Object[]{atom, partner, BondManipulator.createBondOrder(order)}));
                        bondFormed = true;
                    }
                }
            } while (bondFormed);
            if (atomContainers.getAtomContainerCount() != 1 || !this.satCheck.allSaturated(atomContainers.getAtomContainer(0))) continue;
            structureFound = true;
        } while (!structureFound && iteration < 5);
        if (atomContainers.getAtomContainerCount() == 1 && this.satCheck.allSaturated(atomContainers.getAtomContainer(0))) {
            structureFound = true;
        }
        if (!structureFound) {
            throw new CDKException("Could not combine the fragments to combine a valid, satured structure");
        }
        return atomContainers.getAtomContainer(0);
    }

    private IAtom getAnotherUnsaturatedNode(IAtom exclusionAtom, IAtomContainer exclusionAtomContainer, IAtomContainerSet atomContainers) throws CDKException {
        IAtom atom;
        for (IAtomContainer ac : atomContainers.atomContainers()) {
            int next;
            if (ac == exclusionAtomContainer) continue;
            for (int f = next = 0; f < ac.getAtomCount(); ++f) {
                atom = ac.getAtom(f);
                if (this.satCheck.isSaturated(atom, ac) || exclusionAtom == atom) continue;
                return atom;
            }
        }
        int next = exclusionAtomContainer.getAtomCount();
        for (int f = 0; f < next; ++f) {
            atom = exclusionAtomContainer.getAtom(f);
            if (this.satCheck.isSaturated(atom, exclusionAtomContainer) || exclusionAtom == atom || exclusionAtomContainer.getConnectedAtomsList(exclusionAtom).contains(atom)) continue;
            return atom;
        }
        return null;
    }
}

