/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Map;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAminoAcid;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBioPolymer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMonomer;
import org.openscience.cdk.interfaces.IStrand;
import org.openscience.cdk.templates.AminoAcids;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class ProteinBuilderTool {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ProteinBuilderTool.class);

    public static IBioPolymer addAminoAcidAtNTerminus(IBioPolymer protein, IAminoAcid aaToAdd, IStrand strand, IAminoAcid aaToAddTo) {
        ProteinBuilderTool.addAminoAcid(protein, aaToAdd, strand);
        if (protein.getMonomerCount() == 0) {
            protein.addBond(aaToAdd.getBuilder().newInstance(IBond.class, new Object[]{aaToAddTo.getNTerminus(), aaToAdd.getCTerminus(), IBond.Order.SINGLE}));
        }
        return protein;
    }

    public static IBioPolymer addAminoAcidAtCTerminus(IBioPolymer protein, IAminoAcid aaToAdd, IStrand strand, IAminoAcid aaToAddTo) {
        ProteinBuilderTool.addAminoAcid(protein, aaToAdd, strand);
        if (protein.getMonomerCount() != 0 && aaToAddTo != null) {
            protein.addBond(aaToAdd.getBuilder().newInstance(IBond.class, new Object[]{aaToAddTo.getCTerminus(), aaToAdd.getNTerminus(), IBond.Order.SINGLE}));
        }
        return protein;
    }

    public static IBioPolymer createProtein(String sequence) throws CDKException {
        return ProteinBuilderTool.createProtein(sequence, DefaultChemObjectBuilder.getInstance());
    }

    public static IBioPolymer createProtein(String sequence, IChemObjectBuilder builder) throws CDKException {
        Map<String, IAminoAcid> templates = AminoAcids.getHashMapBySingleCharCode();
        IBioPolymer protein = builder.newInstance(IBioPolymer.class, new Object[0]);
        IStrand strand = builder.newInstance(IStrand.class, new Object[0]);
        IAtomContainer previousAA = null;
        for (int i = 0; i < sequence.length(); ++i) {
            String aminoAcidCode = "" + sequence.charAt(i);
            logger.debug("Adding AA: " + aminoAcidCode);
            if (aminoAcidCode.equals(" ")) continue;
            IAminoAcid aminoAcid = templates.get(aminoAcidCode);
            if (aminoAcid == null) {
                throw new CDKException("Cannot build sequence! Unknown amino acid: " + aminoAcidCode);
            }
            try {
                aminoAcid = aminoAcid.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new CDKException("Cannot build sequence! Clone exception: " + e.getMessage(), e);
            }
            aminoAcid.setMonomerName(aminoAcidCode + i);
            logger.debug("protein: ", protein);
            logger.debug("strand: ", strand);
            ProteinBuilderTool.addAminoAcidAtCTerminus(protein, aminoAcid, strand, (IAminoAcid)previousAA);
            previousAA = aminoAcid;
        }
        if (previousAA != null) {
            IAtom oxygen = builder.newInstance(IAtom.class, "O");
            previousAA.addAtom(oxygen);
            IBond bond = builder.newInstance(IBond.class, new Object[]{oxygen, previousAA.getCTerminus(), IBond.Order.SINGLE});
            previousAA.addBond(bond);
            protein.addAtom(oxygen, (IMonomer)previousAA, strand);
            protein.addBond(bond);
        }
        return protein;
    }

    private static IBioPolymer addAminoAcid(IBioPolymer protein, IAminoAcid aaToAdd, IStrand strand) {
        for (IAtom iAtom : AtomContainerManipulator.getAtomArray(aaToAdd)) {
            protein.addAtom(iAtom, aaToAdd, strand);
        }
        for (IChemObject iChemObject : AtomContainerManipulator.getBondArray(aaToAdd)) {
            protein.addBond((IBond)iChemObject);
        }
        return protein;
    }
}

