/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.tools.IDeduceBondOrderTool;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.IValencyChecker;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class SaturationChecker
implements IValencyChecker,
IDeduceBondOrderTool {
    AtomTypeFactory structgenATF;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SaturationChecker.class);

    protected AtomTypeFactory getAtomTypeFactory(IChemObjectBuilder builder) throws CDKException {
        if (this.structgenATF == null) {
            try {
                this.structgenATF = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml", builder);
            }
            catch (Exception exception) {
                logger.debug(exception);
                throw new CDKException("Could not instantiate AtomTypeFactory!", exception);
            }
        }
        return this.structgenATF;
    }

    public boolean hasPerfectConfiguration(IAtom atom, IAtomContainer ac) throws CDKException {
        double bondOrderSum = ac.getBondOrderSum(atom);
        IBond.Order maxBondOrder = ac.getMaximumBondOrder(atom);
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return true;
        }
        logger.debug("*** Checking for perfect configuration ***");
        try {
            logger.debug("Checking configuration of atom " + ac.indexOf(atom));
            logger.debug("Atom has bondOrderSum = " + bondOrderSum);
            logger.debug("Atom has max = " + bondOrderSum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IAtomType atomType : atomTypes) {
            if (bondOrderSum != atomType.getBondOrderSum() || maxBondOrder != atomType.getMaxBondOrder()) continue;
            try {
                logger.debug("Atom " + ac.indexOf(atom) + " has perfect configuration");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        try {
            logger.debug("*** Atom " + ac.indexOf(atom) + " has imperfect configuration ***");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isSaturated(IAtomContainer container) throws CDKException {
        return this.allSaturated(container);
    }

    public boolean allSaturated(IAtomContainer ac) throws CDKException {
        logger.debug("Are all atoms saturated?");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (this.isSaturated(ac.getAtom(f), ac)) continue;
            return false;
        }
        return true;
    }

    public boolean isUnsaturated(IBond bond, IAtomContainer atomContainer) throws CDKException {
        IAtom[] atoms = BondManipulator.getAtomArray(bond);
        boolean isUnsaturated = true;
        for (IAtom atom : atoms) {
            isUnsaturated = isUnsaturated && !this.isSaturated(atom, atomContainer);
        }
        return isUnsaturated;
    }

    public boolean isSaturated(IBond bond, IAtomContainer atomContainer) throws CDKException {
        IAtom[] atoms = BondManipulator.getAtomArray(bond);
        boolean isSaturated = true;
        for (IAtom atom : atoms) {
            isSaturated = isSaturated && this.isSaturated(atom, atomContainer);
        }
        return isSaturated;
    }

    @Override
    public boolean isSaturated(IAtom atom, IAtomContainer ac) throws CDKException {
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return true;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        IBond.Order maxBondOrder = ac.getMaximumBondOrder(atom);
        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        Integer charge = atom.getFormalCharge() == CDKConstants.UNSET ? 0 : atom.getFormalCharge();
        try {
            logger.debug("*** Checking saturation of atom ", atom.getSymbol(), "" + ac.indexOf(atom) + " ***");
            logger.debug("bondOrderSum: " + bondOrderSum);
            logger.debug("maxBondOrder: " + (Object)((Object)maxBondOrder));
            logger.debug("hcount: " + hcount);
        }
        catch (Exception exc) {
            logger.debug(exc);
        }
        for (IAtomType atomType : atomTypes) {
            if (bondOrderSum - (double)charge.intValue() + (double)hcount.intValue() != atomType.getBondOrderSum() || BondManipulator.isHigherOrder(maxBondOrder, atomType.getMaxBondOrder())) continue;
            logger.debug("*** Good ! ***");
            return true;
        }
        logger.debug("*** Bad ! ***");
        return false;
    }

    public boolean isOverSaturated(IAtom atom, IAtomContainer ac) throws CDKException {
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return false;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        IBond.Order maxBondOrder = ac.getMaximumBondOrder(atom);
        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        Integer charge = atom.getFormalCharge() == CDKConstants.UNSET ? 0 : atom.getFormalCharge();
        try {
            logger.debug("*** Checking saturation of atom " + ac.indexOf(atom) + " ***");
            logger.debug("bondOrderSum: " + bondOrderSum);
            logger.debug("maxBondOrder: " + (Object)((Object)maxBondOrder));
            logger.debug("hcount: " + hcount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IAtomType atomType : atomTypes) {
            if (!(bondOrderSum - (double)charge.intValue() + (double)hcount.intValue() > atomType.getBondOrderSum())) continue;
            logger.debug("*** Good ! ***");
            return true;
        }
        logger.debug("*** Bad ! ***");
        return false;
    }

    public double getCurrentMaxBondOrder(IAtom atom, IAtomContainer ac) throws CDKException {
        IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            return 0.0;
        }
        double bondOrderSum = ac.getBondOrderSum(atom);
        Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        double max = 0.0;
        for (IAtomType atomType : atomTypes) {
            double current = (double)hcount.intValue() + bondOrderSum;
            if (!(atomType.getBondOrderSum() - current > max)) continue;
            max = atomType.getBondOrderSum() - current;
        }
        return max;
    }

    public void unsaturate(IAtomContainer atomContainer) {
        for (IBond bond : atomContainer.bonds()) {
            bond.setOrder(IBond.Order.SINGLE);
        }
    }

    public void unsaturateBonds(IAtomContainer container) {
        for (IBond bond : container.bonds()) {
            bond.setOrder(IBond.Order.SINGLE);
        }
    }

    public void newSaturate(IAtomContainer atomContainer) throws CDKException {
        logger.info("Saturating atomContainer by adjusting bond orders...");
        boolean allSaturated = this.allSaturated(atomContainer);
        if (!allSaturated) {
            IBond[] bonds = new IBond[atomContainer.getBondCount()];
            for (int i = 0; i < bonds.length; ++i) {
                bonds[i] = atomContainer.getBond(i);
            }
            boolean succeeded = this.newSaturate(bonds, atomContainer);
            block1: for (IBond iBond : bonds) {
                if (iBond.getOrder() != IBond.Order.DOUBLE || !iBond.getFlag(32) || iBond.getBegin().getAtomicNumber() != 7 || iBond.getEnd().getAtomicNumber() != 7) continue;
                int atomtohandle = 0;
                if (iBond.getBegin().getAtomicNumber() == 7) {
                    atomtohandle = 1;
                }
                List<IBond> bondstohandle = atomContainer.getConnectedBondsList(iBond.getAtom(atomtohandle));
                for (IBond bond : bondstohandle) {
                    if (bond.getOrder() != IBond.Order.SINGLE || !bond.getFlag(32)) continue;
                    bond.setOrder(IBond.Order.DOUBLE);
                    iBond.setOrder(IBond.Order.SINGLE);
                    continue block1;
                }
            }
            if (!succeeded) {
                throw new CDKException("Could not saturate this atomContainer!");
            }
        }
    }

    public boolean newSaturate(IBond[] bonds, IAtomContainer atomContainer) throws CDKException {
        logger.debug("Saturating bond set of size: " + bonds.length);
        boolean bondsAreFullySaturated = true;
        if (bonds.length > 0) {
            IBond bond = bonds[0];
            int leftBondCount = bonds.length - 1;
            IBond[] leftBonds = new IBond[leftBondCount];
            System.arraycopy(bonds, 1, leftBonds, 0, leftBondCount);
            if (this.isUnsaturated(bond, atomContainer)) {
                if (leftBondCount > 0) {
                    logger.debug("Recursing with unsaturated bond with #bonds: " + leftBondCount);
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = false;
                }
                if (!bondsAreFullySaturated) {
                    logger.debug("First try did not work...");
                    boolean couldSaturate = this.newSaturate(bond, atomContainer);
                    if (couldSaturate) {
                        if (leftBondCount > 0) {
                            logger.debug("Recursing with saturated bond with #bonds: " + leftBondCount);
                            bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer);
                        } else {
                            bondsAreFullySaturated = true;
                        }
                    } else {
                        bondsAreFullySaturated = false;
                    }
                }
            } else if (this.isSaturated(bond, atomContainer)) {
                logger.debug("This bond is already saturated.");
                if (leftBondCount > 0) {
                    logger.debug("Recursing with #bonds: " + leftBondCount);
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer);
                } else {
                    bondsAreFullySaturated = true;
                }
            } else {
                logger.debug("Cannot saturate this bond");
                if (leftBondCount > 0) {
                    logger.debug("Recursing with saturated bond with #bonds: " + leftBondCount);
                    bondsAreFullySaturated = this.newSaturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = !this.isUnsaturated(bond, atomContainer);
                }
            }
        }
        logger.debug("Is bond set fully saturated?: " + bondsAreFullySaturated);
        logger.debug("Returning to level: " + (bonds.length + 1));
        return bondsAreFullySaturated;
    }

    public boolean newSaturate(IBond bond, IAtomContainer atomContainer) throws CDKException {
        IAtom[] atoms = BondManipulator.getAtomArray(bond);
        IAtom atom = atoms[0];
        IAtom partner = atoms[1];
        logger.debug("  saturating bond: ", atom.getSymbol(), "-", partner.getSymbol());
        IAtomType[] atomTypes1 = this.getAtomTypeFactory(bond.getBuilder()).getAtomTypes(atom.getSymbol());
        IAtomType[] atomTypes2 = this.getAtomTypeFactory(bond.getBuilder()).getAtomTypes(partner.getSymbol());
        boolean bondOrderIncreased = true;
        while (bondOrderIncreased && !this.isSaturated(bond, atomContainer)) {
            logger.debug("Can increase bond order");
            bondOrderIncreased = false;
            for (int atCounter1 = 0; atCounter1 < atomTypes1.length && !bondOrderIncreased; ++atCounter1) {
                IAtomType aType1 = atomTypes1[atCounter1];
                logger.debug("  condidering atom type: ", aType1);
                if (!this.couldMatchAtomType(atomContainer, atom, aType1)) continue;
                logger.debug("  trying atom type: ", aType1);
                for (int atCounter2 = 0; atCounter2 < atomTypes2.length && !bondOrderIncreased; ++atCounter2) {
                    IAtomType aType2 = atomTypes2[atCounter2];
                    logger.debug("  condidering partner type: ", aType1);
                    if (!this.couldMatchAtomType(atomContainer, partner, atomTypes2[atCounter2])) continue;
                    logger.debug("    with atom type: ", aType2);
                    if (!BondManipulator.isLowerOrder(bond.getOrder(), aType2.getMaxBondOrder()) || !BondManipulator.isLowerOrder(bond.getOrder(), aType1.getMaxBondOrder())) {
                        logger.debug("Bond order not increased: atoms has reached (or exceeded) maximum bond order for this atom type");
                        continue;
                    }
                    if (!BondManipulator.isLowerOrder(bond.getOrder(), aType2.getMaxBondOrder()) || !BondManipulator.isLowerOrder(bond.getOrder(), aType1.getMaxBondOrder())) continue;
                    BondManipulator.increaseBondOrder(bond);
                    logger.debug("Bond order now " + (Object)((Object)bond.getOrder()));
                    bondOrderIncreased = true;
                }
            }
        }
        return this.isSaturated(bond, atomContainer);
    }

    public boolean couldMatchAtomType(IAtomContainer atomContainer, IAtom atom, IAtomType atomType) {
        logger.debug("   ... matching atom ", atom.getSymbol(), " vs ", atomType);
        if (atomContainer.getBondOrderSum(atom) + (double)atom.getImplicitHydrogenCount().intValue() < atomType.getBondOrderSum()) {
            logger.debug("    Match!");
            return true;
        }
        logger.debug("    No Match");
        return false;
    }

    @Override
    public void saturate(IAtomContainer atomContainer) throws CDKException {
        for (int i = 1; i < 4; ++i) {
            block1: for (int f = 0; f < atomContainer.getAtomCount(); ++f) {
                IBond bond;
                IAtomType[] atomTypes2;
                IAtom partner;
                List<IAtom> partners;
                IAtom atom = atomContainer.getAtom(f);
                logger.debug("symbol: ", atom.getSymbol());
                IAtomType[] atomTypes1 = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
                if (atomTypes1.length <= 0) continue;
                logger.debug("first atom type: ", atomTypes1[0]);
                if (atomContainer.getConnectedBondsCount(atom) != i) continue;
                Integer hcount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
                if (atom.getFlag(32) && atomContainer.getBondOrderSum(atom) < atomTypes1[0].getBondOrderSum() - (double)hcount.intValue()) {
                    partners = atomContainer.getConnectedAtomsList(atom);
                    for (int g = 0; g < partners.size(); ++g) {
                        partner = partners.get(g);
                        logger.debug("Atom has " + partners.size() + " partners");
                        atomTypes2 = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(partner.getSymbol());
                        if (atomTypes2.length == 0) {
                            return;
                        }
                        hcount = partner.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : partner.getImplicitHydrogenCount();
                        if (!atomContainer.getBond(partner, atom).getFlag(32) || !(atomContainer.getBondOrderSum(partner) < atomTypes2[0].getBondOrderSum() - (double)hcount.intValue())) continue;
                        logger.debug("Partner has " + atomContainer.getBondOrderSum(partner) + ", may have: " + atomTypes2[0].getBondOrderSum());
                        bond = atomContainer.getBond(atom, partner);
                        logger.debug("Bond order was " + (Object)((Object)bond.getOrder()));
                        BondManipulator.increaseBondOrder(bond);
                        logger.debug("Bond order now " + (Object)((Object)bond.getOrder()));
                        break;
                    }
                }
                Double bondOrderSum = atomTypes1[0].getBondOrderSum() == CDKConstants.UNSET ? 0.0 : atomTypes1[0].getBondOrderSum();
                Integer hydrogenCount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
                Double atomContainerBondOrderSum = atomContainer.getBondOrderSum(atom);
                if (atomContainerBondOrderSum == CDKConstants.UNSET) {
                    atomContainerBondOrderSum = 0.0;
                }
                if (!(atomContainerBondOrderSum < bondOrderSum - (double)hydrogenCount.intValue())) continue;
                logger.debug("Atom has " + atomContainerBondOrderSum + ", may have: " + bondOrderSum);
                partners = atomContainer.getConnectedAtomsList(atom);
                for (int g = 0; g < partners.size(); ++g) {
                    partner = partners.get(g);
                    logger.debug("Atom has " + partners.size() + " partners");
                    atomTypes2 = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(partner.getSymbol());
                    if (atomTypes2.length == 0) {
                        return;
                    }
                    Double bos2 = atomTypes2[0].getBondOrderSum();
                    Integer hc2 = partner.getImplicitHydrogenCount();
                    Double acbos2 = atomContainer.getBondOrderSum(partner);
                    if (bos2 == CDKConstants.UNSET) {
                        bos2 = 0.0;
                    }
                    if (hc2 == CDKConstants.UNSET) {
                        hc2 = 0;
                    }
                    if (acbos2 == CDKConstants.UNSET) {
                        acbos2 = 0.0;
                    }
                    if (!(acbos2 < bos2 - (double)hc2.intValue())) continue;
                    logger.debug("Partner has " + acbos2 + ", may have: " + bos2);
                    bond = atomContainer.getBond(atom, partner);
                    logger.debug("Bond order was " + (Object)((Object)bond.getOrder()));
                    BondManipulator.increaseBondOrder(bond);
                    logger.debug("Bond order now " + (Object)((Object)bond.getOrder()));
                    continue block1;
                }
            }
        }
    }

    public void saturateRingSystems(IAtomContainer atomContainer) throws CDKException {
        IRingSet rs = Cycles.sssr(atomContainer.getBuilder().newInstance(IAtomContainer.class, atomContainer)).toRingSet();
        List<IRingSet> ringSets = RingPartitioner.partitionRings(rs);
        Iterator<IRingSet> iterator = ringSets.iterator();
        while (iterator.hasNext()) {
            IRingSet ringSet;
            rs = ringSet = iterator.next();
            List<IAtomContainer> containers = RingSetManipulator.getAllAtomContainers(rs);
            Iterator<IAtomContainer> iterator2 = containers.iterator();
            while (iterator2.hasNext()) {
                IAtom atom;
                int g;
                IAtomContainer container;
                IAtomContainer ac = container = iterator2.next();
                int[] temp = new int[ac.getAtomCount()];
                for (g = 0; g < ac.getAtomCount(); ++g) {
                    atom = ac.getAtom(g);
                    temp[g] = atom.getImplicitHydrogenCount();
                    atom.setImplicitHydrogenCount(atomContainer.getConnectedBondsCount(atom) - ac.getConnectedBondsCount(atom) - temp[g]);
                }
                this.saturate(ac);
                for (g = 0; g < ac.getAtomCount(); ++g) {
                    atom = ac.getAtom(g);
                    atom.setImplicitHydrogenCount(temp[g]);
                }
            }
        }
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, IAtomContainer container) throws CDKException {
        return this.calculateNumberOfImplicitHydrogens(atom, container, false);
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom) throws CDKException {
        ArrayList<IBond> bonds = new ArrayList<IBond>();
        return this.calculateNumberOfImplicitHydrogens(atom, 0.0, 0.0, bonds, false);
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, IAtomContainer container, boolean throwExceptionForUnknowAtom) throws CDKException {
        return this.calculateNumberOfImplicitHydrogens(atom, container.getBondOrderSum(atom), container.getConnectedSingleElectronsCount(atom), container.getConnectedBondsList(atom), throwExceptionForUnknowAtom);
    }

    public int calculateNumberOfImplicitHydrogens(IAtom atom, double bondOrderSum, double singleElectronSum, List<IBond> connectedBonds, boolean throwExceptionForUnknowAtom) throws CDKException {
        int missingHydrogen = 0;
        if (!(atom instanceof IPseudoAtom)) {
            if (atom.getAtomicNumber() != null && atom.getAtomicNumber() == 1 || atom.getAtomicNumber() == 1) {
                missingHydrogen = (int)(1.0 - bondOrderSum - singleElectronSum - (double)atom.getFormalCharge().intValue());
            } else {
                logger.info("Calculating number of missing hydrogen atoms");
                IAtomType[] atomTypes = this.getAtomTypeFactory(atom.getBuilder()).getAtomTypes(atom.getSymbol());
                if (atomTypes.length == 0 && throwExceptionForUnknowAtom) {
                    return 0;
                }
                logger.debug("Found atomtypes: " + atomTypes.length);
                if (atomTypes.length > 0) {
                    Double tmpBondOrderSum;
                    IAtomType defaultAtom = atomTypes[0];
                    logger.debug("DefAtom: ", defaultAtom);
                    Integer formalCharge = atom.getFormalCharge();
                    if (formalCharge == null) {
                        formalCharge = 0;
                    }
                    if ((tmpBondOrderSum = defaultAtom.getBondOrderSum()) == null) {
                        tmpBondOrderSum = 0.0;
                    }
                    missingHydrogen = (int)(tmpBondOrderSum - bondOrderSum - singleElectronSum + (double)formalCharge.intValue());
                    if (atom.getFlag(32)) {
                        boolean subtractOne = true;
                        for (IBond connectedBond : connectedBonds) {
                            IBond conBond = connectedBond;
                            if (conBond.getOrder() != IBond.Order.DOUBLE && !conBond.getFlag(32)) continue;
                            subtractOne = false;
                        }
                        if (subtractOne) {
                            --missingHydrogen;
                        }
                    }
                    logger.debug("Atom: ", atom.getSymbol());
                    logger.debug("  max bond order: " + tmpBondOrderSum);
                    logger.debug("  bond order sum: " + bondOrderSum);
                    logger.debug("  charge        : " + formalCharge);
                } else {
                    logger.warn("Could not find atom type for ", atom.getSymbol());
                }
            }
        }
        return missingHydrogen;
    }
}

