/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.manipulator.RingManipulator;
import org.openscience.cdk.tools.manipulator.RingSizeComparator;

public class RingSetManipulator {
    public static int getAtomCount(IRingSet set) {
        int count = 0;
        for (IAtomContainer atomContainer : set.atomContainers()) {
            count += atomContainer.getAtomCount();
        }
        return count;
    }

    public static IAtomContainer getAllInOneContainer(IRingSet ringSet) {
        IAtomContainer resultContainer = ringSet.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtomContainer container : RingSetManipulator.getAllAtomContainers(ringSet)) {
            resultContainer.add(container);
        }
        return resultContainer;
    }

    public static IRingSet getLargestRingSet(List<IRingSet> ringSystems) {
        IRingSet largestRingSet = null;
        int atomNumber = 0;
        for (IRingSet ringSystem : ringSystems) {
            IAtomContainer container = RingSetManipulator.getAllInOneContainer(ringSystem);
            if (atomNumber >= container.getAtomCount()) continue;
            atomNumber = container.getAtomCount();
            largestRingSet = ringSystem;
        }
        return largestRingSet;
    }

    public static int getBondCount(IRingSet set) {
        int count = 0;
        for (IAtomContainer atomContainer : set.atomContainers()) {
            count += atomContainer.getBondCount();
        }
        return count;
    }

    public static List<IAtomContainer> getAllAtomContainers(IRingSet set) {
        ArrayList<IAtomContainer> atomContainerList = new ArrayList<IAtomContainer>();
        for (IAtomContainer atomContainer : set.atomContainers()) {
            atomContainerList.add(atomContainer);
        }
        return atomContainerList;
    }

    public static void sort(IRingSet ringSet) {
        ArrayList<IRing> ringList = new ArrayList<IRing>();
        for (IAtomContainer iAtomContainer : ringSet.atomContainers()) {
            ringList.add((IRing)iAtomContainer);
        }
        ringList.sort(new RingSizeComparator(2));
        ringSet.removeAllAtomContainers();
        for (IAtomContainer iAtomContainer : ringList) {
            ringSet.addAtomContainer(iAtomContainer);
        }
    }

    public static IRing getHeaviestRing(IRingSet ringSet, IBond bond) {
        IRingSet rings = ringSet.getRings(bond);
        IRing ring = null;
        int maxOrderSum = 0;
        for (IAtomContainer ring1 : rings.atomContainers()) {
            if (maxOrderSum >= ((IRing)ring1).getBondOrderSum()) continue;
            ring = (IRing)ring1;
            maxOrderSum = ring.getBondOrderSum();
        }
        return ring;
    }

    public static IRing getMostComplexRing(IRingSet ringSet) {
        int i;
        int[] neighbors = new int[ringSet.getAtomContainerCount()];
        int mostComplex = 0;
        int mostComplexPosition = 0;
        for (i = 0; i < ringSet.getAtomContainerCount(); ++i) {
            IRing ring1 = (IRing)ringSet.getAtomContainer(i);
            for (int j = 0; j < ring1.getAtomCount(); ++j) {
                IAtom atom1 = ring1.getAtom(j);
                block2: for (int k = i + 1; k < ringSet.getAtomContainerCount(); ++k) {
                    IRing ring2 = (IRing)ringSet.getAtomContainer(k);
                    if (ring1 == ring2) continue;
                    for (int l = 0; l < ring2.getAtomCount(); ++l) {
                        IAtom atom2 = ring2.getAtom(l);
                        if (!atom1.equals(atom2)) continue;
                        int n = i;
                        neighbors[n] = neighbors[n] + 1;
                        int n2 = k;
                        neighbors[n2] = neighbors[n2] + 1;
                        continue block2;
                    }
                }
            }
        }
        for (i = 0; i < neighbors.length; ++i) {
            if (neighbors[i] < mostComplex) continue;
            mostComplex = neighbors[i];
            mostComplexPosition = i;
        }
        return (IRing)ringSet.getAtomContainer(mostComplexPosition);
    }

    public static boolean isSameRing(IRingSet ringSet, IAtom atom1, IAtom atom2) {
        for (IAtomContainer atomContainer : ringSet.atomContainers()) {
            IRing ring = (IRing)atomContainer;
            if (!ring.contains(atom1) || !ring.contains(atom2)) continue;
            return true;
        }
        return false;
    }

    public static boolean ringAlreadyInSet(IRing newRing, IRingSet ringSet) {
        for (int f = 0; f < ringSet.getAtomContainerCount(); ++f) {
            boolean equals = false;
            int equalCount = 0;
            IRing ring = (IRing)ringSet.getAtomContainer(f);
            if (ring.getBondCount() == newRing.getBondCount()) {
                for (IBond newBond : newRing.bonds()) {
                    for (IBond bond : ring.bonds()) {
                        if (!newBond.equals(bond)) continue;
                        equals = true;
                        ++equalCount;
                        break;
                    }
                    if (equals) continue;
                    break;
                }
            }
            if (equalCount != ring.getBondCount()) continue;
            return true;
        }
        return false;
    }

    public static void markAromaticRings(IRingSet ringset) {
        for (IAtomContainer atomContainer : ringset.atomContainers()) {
            RingManipulator.markAromaticRings((IRing)atomContainer);
        }
    }
}

