/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.attribute.main;

import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.StringSTAttribute;

public class CountExpressionAttribute
extends StringSTAttribute {
    public static final String NAME = "countExpression";
    String argName = "null";
    int start = 0;
    int end = 0;

    public CountExpressionAttribute() {
        super(NAME);
    }

    public CountExpressionAttribute(String value) {
        super(NAME);
        this.setCMLValue(value);
    }

    public CountExpressionAttribute(Attribute att) throws RuntimeException {
        super(att);
    }

    @Override
    public void setCMLValue(String value) throws RuntimeException {
        if (value == null) {
            throw new RuntimeException("null CountExpressionAttribute value");
        }
        if (!value.trim().equals("")) {
            super.setCMLValue(value);
        }
    }

    public static void generateAndInsertClones(CMLElement element) throws RuntimeException {
        if (element == null) {
            throw new RuntimeException("Cannot process null element");
        }
        Element parent = (Element)element.getParent();
        if (parent == null) {
            throw new RuntimeException("Cannot process CountExpressionAttribute without parent");
        }
        CountExpressionAttribute cea = (CountExpressionAttribute)element.getAttribute(NAME);
        int idx = parent.indexOf(element);
        int count = cea.calculateCountExpression();
        for (int i = 1; i < count; ++i) {
            Element newElement = element.copy();
            parent.insertChild(newElement, idx + 1);
        }
    }

    public static void cloneContentAndAppend(CMLElement element) throws RuntimeException {
        if (element == null) {
            throw new RuntimeException("Cannot process null element");
        }
        Element parent = (Element)element.getParent();
        if (parent == null) {
            throw new RuntimeException("Cannot process CountExpressionAttribute without parent");
        }
        CountExpressionAttribute cea = (CountExpressionAttribute)element.getAttribute(NAME);
        int count = cea.calculateCountExpression();
        int nChild = element.getChildCount();
        for (int i = 1; i < count; ++i) {
            for (int j = 0; j < nChild; ++j) {
                Node newChild = element.getChild(j).copy();
                element.appendChild(newChild);
            }
        }
    }

    public int calculateCountExpression() {
        int count = 1;
        String countEx = this.getValue();
        if (countEx != null) {
            if (countEx.startsWith("gaussian")) {
                int[] counts = this.parseCount(countEx = countEx.substring("gaussian".length()));
                if (counts.length != 2 || counts[0] <= 3 || counts[1] < 1 || counts[0] / counts[1] < 3) {
                    throw new RuntimeException("Bad gaussian: " + countEx);
                }
                throw new RuntimeException("gaussian NYI");
            }
            if (countEx.startsWith("range")) {
                int[] counts = this.parseCount(countEx = countEx.substring("range".length()));
                if (counts.length != 2 || counts[0] <= 0 || counts[0] >= counts[1]) {
                    throw new RuntimeException("Bad range: " + countEx);
                }
                double mid2 = (double)(counts[1] + counts[0]) / 2.0;
                double delta2 = (double)(counts[1] - counts[0]) / 2.0;
                double dd = mid2 + delta2 * (0.5 - Math.random());
                count = (int)Math.round(dd);
            } else if (countEx.startsWith("*")) {
                int[] counts = this.parseCount(countEx = countEx.substring("*".length()));
                if (counts.length != 1) {
                    throw new RuntimeException("Bad range: " + countEx);
                }
                count = counts[0];
            } else {
                throw new RuntimeException("Bad count expression: " + countEx);
            }
        }
        return count;
    }

    private int[] parseCount(String countEx) {
        if (!countEx.startsWith("(") || !countEx.endsWith(")")) {
            throw new RuntimeException("Bad range: requires (...): " + countEx);
        }
        countEx = countEx.substring(1, countEx.length() - 1).trim();
        String[] countStrings = countEx.split(",");
        int[] counts = new int[countStrings.length];
        for (int i = 0; i < countStrings.length; ++i) {
            try {
                counts[i] = Integer.parseInt(countStrings[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Bad integer in countExpression :" + countStrings[i]);
            }
        }
        return counts;
    }
}

