/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.ParentNode;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractBond;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLBondArray;
import org.xmlcml.cml.element.CMLBondStereo;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real2;
import org.xmlcml.molutil.ChemicalElement;

public class CMLBond
extends AbstractBond {
    public static final String NS = "cml:bond";
    public static final String DEPRECATED_SINGLE = "1";
    public static final String DEPRECATED_DOUBLE = "2";
    public static final String DEPRECATED_TRIPLE = "3";
    static final Logger logger = Logger.getLogger(CMLBond.class);
    public static final String UNKNOWN_ORDER = "UNK";
    private static final String SINGLE = "1";
    public static final String SINGLE_NORM = "1";
    private static final String DOUBLE = "2";
    public static final String DOUBLE_NORM = "2";
    private static final String TRIPLE = "3";
    public static final String TRIPLE_NORM = "3";
    public static final String SINGLE_S = "S";
    public static final String DOUBLE_D = "D";
    public static final String TRIPLE_T = "T";
    public static final String AROMATIC = "A";
    public static final String ZERO = ".";
    public static final String WEDGE = "W";
    public static final String HATCH = "H";
    public static final String QUERY_BOLD = "BOLD?";
    public static final String QUERY_HASH = "HASH?";
    public static final String CIS = "C";
    public static final String TRANS = "T";
    public static final String LINEAR = "L";
    public static final String NOSTEREO = "-";
    public static final String ACYCLIC = "ACYCLIC";
    public static final String CYCLIC = "CYCLIC";
    public static final String CYCLIC_UNKNOWN = "UNK";
    public static final String USER_CYCLIC = "userCyclic";
    public static final String[] bondType = new String[]{"1", "2", "3", "A", ".", "W", "H", "-"};
    public static final double[] bondOrders = new double[]{1.0, 2.0, 3.0, 1.5, 0.0, 1.0, 1.0, 1.0};
    public static final String HASH_SYMB = "__";
    public static final String BOND_LINK = "-";
    List<CMLAtom> atomList;

    public CMLBond() {
    }

    public CMLBond(String id, CMLAtom atom1, CMLAtom atom2) throws RuntimeException {
        this(atom1, atom2);
        this.setId(id);
    }

    public CMLBond(String id, CMLAtom atom1, CMLAtom atom2, String order) throws RuntimeException {
        this(id, atom1, atom2);
        this.setOrder(order);
    }

    public CMLBond(CMLAtom atom1, CMLAtom atom2) throws RuntimeException {
        if (atom1 == null || atom2 == null) {
            throw new RuntimeException("Atoms in bond muct not be null");
        }
        if (atom1 == atom2) {
            throw new RuntimeException("Atoms in bond must be distinct: " + atom1.getId() + ", " + atom2.getId());
        }
        if (atom1.getMolecule() == null || atom2.getMolecule() == null) {
            throw new RuntimeException("Atoms in bond must have owner molecules");
        }
        if (!atom1.getMolecule().equals(atom2.getMolecule())) {
            throw new RuntimeException("Atoms in bond must have identical owner molecule");
        }
        String atomId1 = atom1.getId();
        String atomId2 = atom2.getId();
        if (atomId1 == null || atomId2 == null) {
            throw new RuntimeException("Atoms in bond must have ids");
        }
        this.setAtomRefs2(new String[]{atomId1, atomId2});
    }

    public CMLBond(CMLAtom atom1, CMLAtom atom2, String order) throws RuntimeException {
        this(atom1, atom2);
        this.setOrder(order);
    }

    public CMLBond(CMLBond old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLBond(this);
    }

    @Override
    public CMLBond makeElementInContext(Element parent) {
        CMLBond bond = null;
        if (parent == null) {
            bond = new CMLBond();
        } else if (parent instanceof CMLBondArray) {
            Element grandParent = (Element)parent.getParent();
            if (!(grandParent instanceof CMLMolecule)) {
                throw new RuntimeException("Bond needs molecule grandparent");
            }
            bond = new CMLBond();
        } else {
            throw new RuntimeException("Bond needs bondArray parent");
        }
        return bond;
    }

    @Override
    public void finishMakingElement(Element parent) {
        this.getMolecule();
        if (this.getAtomRefs2() == null && this.getAtomRefs() == null) {
            throw new RuntimeException("bond must have AtomRefs2 or atomRefs");
        }
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        ParentNode parent = this.getParent();
        if (parent != null && parent instanceof CMLBondArray) {
            CMLBondArray bondArray = (CMLBondArray)parent;
            bondArray.getBondIdMap().put(id, this);
        }
    }

    @Override
    public String getOrder() {
        String order = super.getOrder();
        if (order == null) {
            order = null;
        } else if (CMLBond.isSingle(order)) {
            order = SINGLE_S;
        } else if (CMLBond.isDouble(order)) {
            order = DOUBLE_D;
        } else if (CMLBond.isTriple(order)) {
            order = "T";
        } else if (!order.equals(AROMATIC)) {
            order = "UNK";
        }
        return order;
    }

    CMLBondArray getBondArray() {
        ParentNode parent = this.getParent();
        return parent == null || !(parent instanceof CMLBondArray) ? null : (CMLBondArray)parent;
    }

    @Override
    public void detach() {
        CMLBondArray bondArray = this.getBondArray();
        if (bondArray != null) {
            bondArray.removeBond(this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CMLMolecule getMolecule() {
        CMLMolecule molecule = null;
        ParentNode bondArray = this.getParent();
        if (bondArray == null) return molecule;
        ParentNode grandParent = bondArray.getParent();
        if (grandParent == null) throw new RuntimeException(Message.NULL_GRANDPARENT.value);
        if (!(grandParent instanceof CMLMolecule)) throw new RuntimeException("grandParent of bond is not a molecule: " + grandParent.getClass());
        return (CMLMolecule)grandParent;
    }

    public String getAtomId(int i) {
        CMLAtom atom = this.getAtom(i);
        return atom == null ? null : atom.getId();
    }

    public CMLAtom getAtom(int i) {
        List<CMLAtom> atomList = this.getAtoms();
        return atomList == null || i < 0 || i >= atomList.size() ? null : atomList.get(i);
    }

    public List<CMLAtom> getAtoms() throws RuntimeException {
        if (this.atomList == null) {
            this.atomList = new ArrayList<CMLAtom>();
            String[] atomRefs2 = this.getAtomRefs2();
            if (atomRefs2 == null) {
                throw new RuntimeException("bond has no atomRefs2");
            }
            CMLMolecule molecule = this.getMolecule();
            if (molecule == null) {
                throw new RuntimeException("bond has no parent molecule");
            }
            this.addAtom(this.atomList, molecule, atomRefs2[0]);
            this.addAtom(this.atomList, molecule, atomRefs2[1]);
        }
        return this.atomList;
    }

    public double getBondLength() {
        double d = Double.NaN;
        List<CMLAtom> atoms = this.getAtoms();
        if (atoms.size() == 2) {
            d = atoms.get(0).getDistanceTo(atoms.get(1));
        }
        return d;
    }

    public double getBondLength(CMLElement.CoordinateType type) {
        double d = Double.NaN;
        List<CMLAtom> atoms = this.getAtoms();
        if (atoms.size() == 2) {
            if (CMLElement.CoordinateType.TWOD.equals((Object)type)) {
                Real2 xy0 = atoms.get(0).getXY2();
                Real2 xy1 = atoms.get(1).getXY2();
                d = xy0.getDistance(xy1);
            } else if (CMLElement.CoordinateType.CARTESIAN.equals((Object)type)) {
                d = atoms.get(0).getDistanceTo(atoms.get(1));
            } else {
                throw new RuntimeException("Bad type: " + (Object)((Object)type));
            }
        }
        return d;
    }

    private void addAtom(List<CMLAtom> atomList, CMLMolecule molecule, String id) {
        CMLAtom atom = molecule.getAtomById(id);
        if (atom == null) {
            String molId = molecule == null ? null : molecule.getId();
            throw new RuntimeException("Non-existent atom in bond : atom/mol " + id + "/" + molId);
        }
        atomList.add(atom);
    }

    public String getOtherAtomId(String id) {
        String[] atomRefs2;
        String id1 = null;
        if (id != null && (atomRefs2 = this.getAtomRefs2()) != null) {
            if (id.equals(atomRefs2[0])) {
                id1 = atomRefs2[1];
            } else if (id.equals(atomRefs2[1])) {
                id1 = atomRefs2[0];
            }
        }
        return id1;
    }

    public CMLAtom getOtherAtom(CMLAtom atom) {
        CMLAtom otherAtom = null;
        if (atom != null) {
            this.atomList = this.getAtoms();
            if (this.atomList != null) {
                int idx = this.atomList.indexOf(atom);
                if (idx == -1) {
                    throw new RuntimeException("atom not in bond: " + atom.getId());
                }
                otherAtom = this.atomList.get(1 - idx);
            }
        }
        return otherAtom;
    }

    public void appendToId(String s, boolean updateRefs) {
        String id = this.getId();
        if (id != null && id.length() > 0) {
            this.resetId(id + s);
            if (updateRefs) {
                String[] refs = this.getAtomRefs2();
                if (refs != null) {
                    int j = refs.length - 1;
                    while (j >= 0) {
                        int n = j--;
                        refs[n] = refs[n] + s;
                    }
                }
                this.setAtomRefs2(refs);
            }
        }
    }

    void updateLigands() {
        List<CMLAtom> atoms = this.getAtoms();
        atoms.get(0).addLigandBond(this, atoms.get(1));
        atoms.get(1).addLigandBond(this, atoms.get(0));
    }

    void setAtomRefs2(String atomId1, String atomId2) throws RuntimeException {
        this.setAtomRefs2(new String[]{atomId1, atomId2});
    }

    public static String atomHash(String atomId1, String atomId2) {
        if (atomId1 == null || atomId2 == null) {
            return null;
        }
        if (atomId1 == atomId2) {
            return null;
        }
        if (atomId1.compareTo(atomId2) < 0) {
            String temp = atomId2;
            atomId2 = atomId1;
            atomId1 = temp;
        }
        return atomId1 + HASH_SYMB + atomId2;
    }

    public static String atomHash(String[] atomRefs2) {
        return atomRefs2 == null ? null : CMLBond.atomHash(atomRefs2[0], atomRefs2[1]);
    }

    public String atomHash() {
        return CMLBond.atomHash(this.getAtomRefs2());
    }

    public static String atomHash(CMLAtom atom1, CMLAtom atom2) {
        String hash = null;
        if (atom1 != null && atom2 != null) {
            hash = CMLBond.atomHash(atom1.getId(), atom2.getId());
        }
        return hash;
    }

    public static String atomHash(CMLBond bond) throws RuntimeException {
        String hash = null;
        if (bond != null) {
            String[] atomRefs2 = bond.getAtomRefs2();
            if (atomRefs2 == null) {
                throw new RuntimeException("no atomRefs2 attribute");
            }
            hash = CMLBond.atomHash(atomRefs2[0], atomRefs2[1]);
        }
        return hash;
    }

    @Override
    public void setCyclic(String c) {
        this.addAttribute(new Attribute(USER_CYCLIC, c));
    }

    @Override
    public String getCyclic() {
        return this.getAttributeValue(USER_CYCLIC);
    }

    public CMLBondStereo getBondStereo() {
        return (CMLBondStereo)this.getFirstCMLChild("bondStereo");
    }

    public void setBondStereo(CMLBondStereo stereo) {
        this.clearBondStereo();
        try {
            this.addBondStereo(stereo);
        }
        catch (Exception e) {
            throw new RuntimeException("BUG " + e);
        }
    }

    public void clearBondStereo() {
        while (this.getBondStereoElements().size() > 0) {
            this.removeChild(this.getBondStereo());
        }
    }

    public static boolean areWithinBondingDistance(CMLAtom atom1, CMLAtom atom2) {
        double covd2;
        double dz;
        double dy;
        ArrayList<CMLAtom> atomList = new ArrayList<CMLAtom>(2);
        atomList.add(atom1);
        atomList.add(atom2);
        double covd = 0.0;
        for (CMLAtom atom : atomList) {
            ChemicalElement el = atom.getChemicalElement();
            if (el == null) {
                throw new RuntimeException("cannot find chemicalElement for atom (" + atom.getId() + "):" + atom.getElementType());
            }
            double radius = el.getTypeAdjustedCovalentRadius();
            covd += radius;
        }
        double dx = atom1.getX3() - atom2.getX3();
        double d2 = dx * dx + (dy = atom1.getY3() - atom2.getY3()) * dy + (dz = atom1.getZ3() - atom2.getZ3()) * dz;
        return d2 < (covd2 = covd * covd);
    }

    public boolean containsElement(String elementType) {
        this.getAtoms();
        return this.atomList.size() == 2 && (this.atomList.get(0).hasElement(elementType) || this.atomList.get(1).hasElement(elementType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void incrementOrder(int delta) {
        String order = this.getOrder();
        if (delta == 1) {
            if (order == null || CMLBond.isSingle(order)) {
                order = DOUBLE_D;
            } else if (CMLBond.isDouble(order)) {
                order = "T";
            } else {
                if (!CMLBond.isTriple(order)) throw new RuntimeException("Cannot increment bond order " + order);
                order = "4";
            }
        } else if (delta == 2) {
            if (order == null) {
                order = DOUBLE_D;
            } else if (CMLBond.isSingle(order)) {
                order = "T";
            } else {
                if (!CMLBond.isDouble(order)) throw new RuntimeException("Cannot increment bond order " + order);
                order = "4";
            }
        } else if (delta == -1) {
            if (order == null) {
                throw new RuntimeException("Cannot decrement bond order " + order);
            }
            if (CMLBond.isDouble(order)) {
                order = SINGLE_S;
            } else {
                if (!CMLBond.isTriple(order)) throw new RuntimeException("Cannot decrement bond order " + order);
                order = DOUBLE_D;
            }
        } else if (delta != 0) {
            throw new RuntimeException("Cannot change bond order by " + delta);
        }
        this.setOrder(order);
    }

    public static boolean isSingle(String order) {
        return order != null && (order.equals("1") || order.equals(SINGLE_S));
    }

    public static boolean isDouble(String order) {
        return order != null && (order.equals("2") || order.equals(DOUBLE_D));
    }

    public static boolean isTriple(String order) {
        return order != null && (order.equals("3") || order.equals("T"));
    }

    public static String createId(CMLAtom atom1, CMLAtom atom2) {
        String[] atomR2 = new String[]{atom1.getId(), atom2.getId()};
        return CMLBond.createId(atomR2);
    }

    private static String createId(String[] atomR2) {
        return atomR2[0] + "-" + atomR2[1];
    }

    public String createId() {
        return CMLBond.createId(this.getAtomRefs2());
    }

    public String getString() {
        String s = "";
        String[] atomRefs2 = this.getAtomRefs2();
        if (atomRefs2 != null) {
            s = this.atomHash();
        }
        return s;
    }

    void renameAtomRef(String oldId, String newId) {
        String[] atomRefs2 = this.getAtomRefs2();
        String newAtomRef0 = "";
        String newAtomRef1 = "";
        if (oldId.equals(atomRefs2[0])) {
            newAtomRef0 = newId;
            newAtomRef1 = atomRefs2[1];
        } else if (oldId.equals(atomRefs2[1])) {
            newAtomRef0 = atomRefs2[0];
            newAtomRef1 = newId;
        } else {
            throw new RuntimeException("Cannot find find atomRef: " + oldId + " in atomRefs2: " + atomRefs2);
        }
        this.setAtomRefs2(new String[]{newAtomRef0, newAtomRef1});
    }

    public String generateAndSetId() {
        String bondId = this.getId();
        if (bondId != null) {
            this.removeAttribute("id");
        }
        List<CMLAtom> atomListx = this.getAtoms();
        String at0id = atomListx.get(0).getId();
        String at1id = atomListx.get(1).getId();
        bondId = at0id + "_" + at1id;
        this.setId(bondId);
        return bondId;
    }

    public void swapAtomsInBond(CMLAtom atom0, CMLAtom atom1) {
        this.setAtomRefs2(new String[]{atom1.getId(), atom0.getId()});
    }

    public void swapAtomsInBond() {
        this.setAtomRefs2(new String[]{this.getAtomRefs2()[1], this.getAtomRefs2()[0]});
    }

    public double calculateBondLength3D() {
        return this.calculateBondLength(CMLElement.CoordinateType.CARTESIAN);
    }

    public double calculateBondLength2D() {
        return this.calculateBondLength(CMLElement.CoordinateType.TWOD);
    }

    public double calculateBondLength(CMLElement.CoordinateType type) {
        CMLAtom atom0 = null;
        CMLAtom atom1 = null;
        List<CMLAtom> atomList = this.getAtoms();
        atom0 = atomList.get(0);
        atom1 = atomList.get(1);
        if (atom0 == null || atom1 == null) {
            throw new RuntimeException("missing atoms");
        }
        double length = -1.0;
        if (type.equals((Object)CMLElement.CoordinateType.CARTESIAN)) {
            length = this.calculateLength3D(atom0, atom1);
        } else if (type.equals((Object)CMLElement.CoordinateType.TWOD)) {
            length = this.calculateLength2D(atom0, atom1);
        }
        return length;
    }

    private double calculateLength2D(CMLAtom atom0, CMLAtom atom1) {
        Real2 p0 = atom0.getXY2();
        Real2 p1 = atom1.getXY2();
        if (p0 == null || p1 == null) {
            throw new RuntimeException("atoms do not have 2D coordinates");
        }
        double length = p0.getDistance(p1);
        return length;
    }

    private double calculateLength3D(CMLAtom atom0, CMLAtom atom1) {
        Point3 p0 = atom0.getXYZ3();
        Point3 p1 = atom1.getXYZ3();
        if (p0 == null || p1 == null) {
            throw new RuntimeException("atoms do not have 3D coordinates");
        }
        double length = p0.getDistanceFromPoint(p1);
        return length;
    }

    public static enum Message {
        NULL_GRANDPARENT("null grandparent for bond");

        public String value;

        private Message(String s) {
            this.value = s;
        }
    }
}

