/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import nu.xom.Element;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractEigen;
import org.xmlcml.cml.element.CMLArray;
import org.xmlcml.cml.element.CMLMatrix;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.RealMatrix;
import org.xmlcml.euclid.Util;

public class CMLEigen
extends AbstractEigen {
    public static final String NS = "cml:eigen";

    public CMLEigen() {
    }

    public CMLEigen(CMLEigen old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLEigen(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        CMLEigen eigen = new CMLEigen();
        return eigen;
    }

    @Override
    public void finishMakingElement(Element parent) {
        CMLArray eigenvalues = this.getEigenvalues();
        CMLMatrix eigenvectors = this.getEigenvectors();
        if (eigenvalues != null && eigenvectors != null) {
            if (eigenvectors.getRowsAttribute() == null || eigenvectors.getColumnsAttribute() == null) {
                throw new RuntimeException("must give rows and columns attributes on eigenvectors");
            }
            String orientation = this.getOrientation();
            if (!Orientation.VALUES_COLS.value.equals(orientation) && !Orientation.VALUES_ROWS.value.equals(orientation)) {
                throw new RuntimeException("must give valid orientation on eigenvectors: " + orientation);
            }
        }
    }

    public CMLEigen(CMLMatrix eigenvectors, CMLArray eigenvalues, Orientation orient) {
        if (eigenvectors == null && eigenvalues == null) {
            throw new RuntimeException("null eigen argument(s)");
        }
        if (eigenvectors.getRows() != eigenvectors.getColumns()) {
            throw new RuntimeException("eigenvector matrix must be square: rows(" + eigenvectors.getRows() + ") columns (" + eigenvectors.getColumns() + ")");
        }
        if (eigenvalues.getSize() != eigenvectors.getColumns()) {
            throw new RuntimeException("eigenvector matrix (" + eigenvectors.getColumns() + ") incompatible with eigenvalues (" + eigenvalues.getSize() + ")");
        }
        if (!"xsd:double".equals(eigenvalues.getDataType())) {
            throw new RuntimeException("eigenvalue matrix must be real numbers");
        }
        if (!"xsd:double".equals(eigenvectors.getDataType())) {
            throw new RuntimeException("eigenvector matrix must be real numbers");
        }
        this.appendChild(eigenvalues);
        this.appendChild(eigenvectors);
        this.setOrientation(orient.value);
    }

    public int getSize() {
        int size = 0;
        CMLArray eigenvalues = this.getEigenvalues();
        if (eigenvalues != null) {
            size = eigenvalues.getDoubles().length;
        }
        return size;
    }

    public CMLMatrix getEigenvectors() {
        CMLMatrix eigenvectors;
        CMLMatrix cMLMatrix = eigenvectors = this.getMatrixElements().size() == 1 ? this.getMatrixElements().get(0) : null;
        if (eigenvectors != null && !"xsd:double".equals(eigenvectors.getDataType())) {
            throw new RuntimeException("eigenvectors array must be of type double");
        }
        return eigenvectors;
    }

    public CMLArray getEigenvalues() {
        CMLArray eigenvalues;
        CMLArray cMLArray = eigenvalues = this.getArrayElements().size() == 1 ? this.getArrayElements().get(0) : null;
        if (eigenvalues != null && !"xsd:double".equals(eigenvalues.getDataType())) {
            throw new RuntimeException("eigenvalues array must be of type double");
        }
        return eigenvalues;
    }

    public RealArray getEigenvector(int serial) throws RuntimeException {
        RealArray array = null;
        if (serial < 0) {
            throw new RuntimeException("bad index: " + serial);
        }
        CMLMatrix matrix = this.getEigenvectors();
        if (matrix != null) {
            if (serial >= matrix.getRows()) {
                throw new RuntimeException("bad index: " + serial);
            }
            if (matrix != null && serial < matrix.getRows() && "xsd:double".equals(matrix.getDataType())) {
                RealMatrix mat = matrix.getEuclidRealMatrix();
                if (Orientation.VALUES_COLS.value.equals(this.getOrientation())) {
                    array = mat.extractColumnData(serial);
                } else if (Orientation.VALUES_ROWS.value.equals(this.getOrientation())) {
                    Util.println("ROW");
                    array = mat.extractRowData(serial);
                } else {
                    throw new RuntimeException("unknown orientation: " + this.getOrientation());
                }
            }
        }
        return array;
    }

    public static enum Orientation {
        VALUES_ROWS("rowVectors", "eigenvalues correspond to rows"),
        VALUES_COLS("columnVectors", "eigenvalues correspond to columns");

        public String value;
        public String desc;

        private Orientation(String value, String desc) {
            this.desc = desc;
            this.value = value;
        }
    }
}

