/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import nu.xom.Element;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractPlane3;
import org.xmlcml.cml.element.CMLLine3;
import org.xmlcml.cml.element.CMLPoint3;
import org.xmlcml.cml.element.CMLVector3;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Line3;
import org.xmlcml.euclid.Plane3;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class CMLPlane3
extends AbstractPlane3 {
    public static final String NS = "cml:plane3";
    private static final Logger LOG = Logger.getLogger(CMLPlane3.class.getName());

    public CMLPlane3() {
    }

    public CMLPlane3(CMLPlane3 old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLPlane3(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLPlane3();
    }

    @Override
    public void finishMakingElement(Element parent) throws RuntimeException {
        double[] array = this.getXMLContent();
        if (array == null) {
            LOG.warn("plane must not be empty");
        } else if (array.length != 4) {
            LOG.warn("plane must have 4 double components");
        }
    }

    public CMLPlane3(double[] array) {
        this.setArray(array);
    }

    public CMLPlane3(Plane3 plane) {
        this();
        this.setArrayNoCheck(plane.getArray());
    }

    public CMLPlane3(double[] lmn, double d) {
        this();
        try {
            Util.check(lmn, 3);
            Plane3 pp = new Plane3(lmn, d);
            this.setArrayNoCheck(pp.getArray());
        }
        catch (EuclidRuntimeException e) {
            throw new RuntimeException("" + e);
        }
    }

    public CMLPlane3(CMLVector3 v, double d) throws RuntimeException {
        try {
            Plane3 pp = new Plane3(v.getEuclidVector3(), d);
            this.setArrayNoCheck(pp.getArray());
        }
        catch (Exception e) {
            throw new RuntimeException("" + e);
        }
    }

    public CMLPlane3(CMLPoint3 p1, CMLPoint3 p2, CMLPoint3 p3) {
        Plane3 pp = new Plane3(p1.getEuclidPoint3(), p2.getEuclidPoint3(), p3.getEuclidPoint3());
        this.setArrayNoCheck(pp.getArray());
    }

    public CMLPlane3(CMLLine3 l, CMLPoint3 p) {
        Plane3 pp = new Plane3(l.getEuclidLine3(), p.getEuclidPoint3());
        this.setArrayNoCheck(pp.getArray());
    }

    public Plane3 getEuclidPlane3() throws RuntimeException {
        Plane3 pleucl3 = null;
        try {
            pleucl3 = new Plane3(this.getXMLContent());
        }
        catch (EuclidRuntimeException e) {
            throw new RuntimeException("" + e);
        }
        return pleucl3;
    }

    public void setArray(double[] array) {
        Util.check(array, 4);
        this.setArrayNoCheck(array);
    }

    private void setArrayNoCheck(double[] array) throws RuntimeException {
        Vector3 v = new Vector3(array[0], array[1], array[2]);
        if (v.isZero()) {
            throw new RuntimeException("Cannot make plane with zero vector");
        }
        v.normalize();
        double[] vv = v.getArray();
        double[] aa = new double[]{vv[0], vv[1], vv[2], array[3]};
        this.setXMLContent(aa);
    }

    public double[] getArray() {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return pleucl3.getArray();
    }

    public CMLVector3 getVector() {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return CMLVector3.createCMLVector3(pleucl3.getVector());
    }

    public double getDistance() {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return pleucl3.getArray()[3];
    }

    public void negative() {
        Plane3 pleucl3 = this.getEuclidPlane3();
        pleucl3.negative();
        this.setXMLContent(pleucl3.getArray());
    }

    public boolean isEqualTo(CMLPlane3 pl2) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return pleucl3.isEqualTo(pl2.getEuclidPlane3());
    }

    public CMLPlane3 subtract() {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return new CMLPlane3(pleucl3.subtract());
    }

    public double getDistanceFromPoint(CMLPoint3 p) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return pleucl3.getDistanceFromPoint(p.getEuclidPoint3());
    }

    public boolean isParallelTo(CMLPlane3 pl2) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return pleucl3.isParallelTo(pl2.getEuclidPlane3());
    }

    public boolean isAntiparallelTo(CMLPlane3 pl2) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return pleucl3.isAntiparallelTo(pl2.getEuclidPlane3());
    }

    public boolean containsPoint(CMLPoint3 p) {
        double d = this.getDistanceFromPoint(p);
        return Math.abs(d) < 1.0E-14;
    }

    public CMLPoint3 getClosestPointTo(CMLPoint3 p2) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        Point3 p = pleucl3.getClosestPointTo(p2.getEuclidPoint3());
        return new CMLPoint3(p);
    }

    public CMLPoint3 getIntersectionWith(CMLLine3 l) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        Point3 p = pleucl3.getIntersectionWith(l.getEuclidLine3());
        return p == null ? null : new CMLPoint3(p);
    }

    public CMLLine3 getIntersectionWith(CMLPlane3 pl2) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        Line3 l = pleucl3.getIntersectionWith(pl2.getEuclidPlane3());
        return l == null ? null : new CMLLine3(l);
    }

    public CMLPoint3 getIntersectionWith(CMLPlane3 pl2, CMLPlane3 pl3) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        Point3 p = pleucl3.getIntersectionWith(pl2.getEuclidPlane3(), pl3.getEuclidPlane3());
        return p == null ? null : new CMLPoint3(p);
    }

    public double getAngleMadeWith(CMLPlane3 pl2) {
        Plane3 pleucl3 = this.getEuclidPlane3();
        return pleucl3.getAngleMadeWith(pl2.getEuclidPlane3()).getRadian();
    }
}

