/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.text.ParseException;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.xmlcml.cml.attribute.DictRefAttribute;
import org.xmlcml.cml.attribute.NamespaceRefAttribute;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLType;
import org.xmlcml.cml.element.AbstractScalar;
import org.xmlcml.cml.interfacex.HasDataType;
import org.xmlcml.cml.interfacex.HasDictRef;
import org.xmlcml.cml.interfacex.HasScalar;
import org.xmlcml.cml.interfacex.HasUnits;
import org.xmlcml.euclid.JodaDate;
import org.xmlcml.euclid.Util;

public class CMLScalar
extends AbstractScalar
implements HasUnits,
HasScalar,
HasDictRef,
HasDataType {
    private static Logger LOG = Logger.getLogger(CMLScalar.class);
    public static final String NS = "cml:scalar";

    public CMLScalar() {
        this.init();
    }

    void init() {
    }

    public CMLScalar(CMLScalar old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLScalar(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLScalar();
    }

    @Override
    public void finishMakingElement(Element parent) throws RuntimeException {
        String dataType = this.getDataType();
        if (!dataType.equals("xsd:string")) {
            if (dataType.equals("xsd:boolean")) {
                this.getBoolean();
            } else if ("xsd:double".equals(CMLType.getNormalizedValue(dataType))) {
                this.getDouble();
            } else if (dataType.equals("xsd:integer")) {
                this.getInt();
            } else if (dataType.equals("xsd:date")) {
                this.getDate();
            } else {
                throw new RuntimeException("scalar does not support dataType: " + dataType);
            }
        }
    }

    public CMLScalar(Boolean scalar) {
        this.setValue(scalar);
    }

    public CMLScalar(DateTime scalar) {
        this.setValue(scalar);
    }

    public CMLScalar(String scalar) {
        this.setValue(scalar);
    }

    public CMLScalar(double scalar) {
        this.setValue(scalar);
    }

    public CMLScalar(int scalar) {
        this.setValue(scalar);
    }

    public Boolean getBoolean() {
        String content;
        Boolean result = null;
        if (this.getDataType().equals("xsd:boolean") && (content = this.getXMLContent()) != null) {
            result = new Boolean(content);
        }
        return result;
    }

    public DateTime getDate() {
        String content;
        DateTime result = null;
        if (this.getDataType().equals("xsd:date") && (content = this.getXMLContent()) != null) {
            try {
                result = JodaDate.parseDate(content);
            }
            catch (Exception e) {
                throw new RuntimeException("bad date", e);
            }
        }
        return result;
    }

    @Override
    public double getDouble() {
        String content;
        double result = Double.NaN;
        if (this.getDataType().equals("xsd:double") && (content = this.getXMLContent()) != null) {
            try {
                result = Util.parseFlexibleDouble(content);
            }
            catch (ParseException e) {
                throw new RuntimeException("Bad double :" + content, e);
            }
        }
        return result;
    }

    @Override
    public String getString() {
        String result = null;
        if (this.getDataType().equals("xsd:string")) {
            result = this.getXMLContent();
        }
        return result;
    }

    @Override
    public int getInt() {
        int result = Integer.MIN_VALUE;
        if (this.getDataType().equals("xsd:integer")) {
            String content = this.getXMLContent();
            if (content != null && !content.trim().equals("")) {
                try {
                    result = Integer.parseInt(content);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("bad integer content: " + content);
                }
            }
        } else {
            throw new RuntimeException("wrong dataType for int " + this.getDataType());
        }
        return result;
    }

    public void setValue(Boolean scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:boolean");
    }

    public void setValue(DateTime scalar) {
        String date = JodaDate.formatDate(scalar);
        this.setXMLContent(date);
        super.setDataType("xsd:date");
    }

    public void setValue(String scalar) {
        if (scalar != null) {
            this.setXMLContent(scalar);
            super.setDataType("xsd:string");
        }
    }

    public void setValueNoTrim(String scalar) {
        if (scalar != null) {
            this.removeChildren();
            this.appendChild(scalar);
            this.setDataType("xsd:string");
        }
    }

    public void setValue(double scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:double");
    }

    public void setValue(int scalar) {
        this.setXMLContent("" + scalar);
        super.setDataType("xsd:integer");
    }

    @Override
    public String getDataType() {
        String dataType = super.getDataType();
        if (dataType == null) {
            dataType = "xsd:string";
            super.setDataType(dataType);
        }
        return CMLType.getNormalizedValue(dataType);
    }

    public Class<?> getDataTypeClass() {
        Class clazz = null;
        String dataType = this.getDataType();
        if ("xsd:string".equals(dataType)) {
            clazz = String.class;
        } else if ("xsd:double".equals(dataType)) {
            clazz = Double.class;
        } else if ("xsd:integer".equals(dataType)) {
            clazz = Integer.class;
        } else if ("xsd:boolean".equals(dataType)) {
            clazz = Boolean.class;
        } else if ("xsd:date".equals(dataType)) {
            clazz = DateTime.class;
        }
        return clazz;
    }

    @Override
    public void setDataType(String dType) {
        if (this.getAttributeValue("dataType") != null) {
            throw new RuntimeException("Must not reset dataType; use SetValue(...)");
        }
        super.setDataType(dType);
    }

    void checkNumericConformability(CMLScalar scalar) {
        if (!this.getDataType().equals(scalar.getDataType())) {
            throw new RuntimeException("Unsuitable dataTypes for numeric operations / " + this.getDataType() + "/" + scalar.getDataType());
        }
    }

    public CMLScalar subtract(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        CMLScalar resultScalar = null;
        if (this.getDataType().equals("xsd:double")) {
            resultScalar = new CMLScalar(this.getDouble() - scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            resultScalar = new CMLScalar(this.getInt() - scalar.getInt());
        }
        return resultScalar;
    }

    public void subtractEquals(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        if (this.getDataType().equals("xsd:double")) {
            this.setValue(this.getDouble() - scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            this.setValue(this.getInt() - scalar.getInt());
        }
    }

    public CMLScalar plus(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        CMLScalar resultScalar = null;
        if (this.getDataType().equals("xsd:double")) {
            resultScalar = new CMLScalar(this.getDouble() + scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            resultScalar = new CMLScalar(this.getInt() + scalar.getInt());
        }
        return resultScalar;
    }

    public void plusEquals(CMLScalar scalar) {
        this.checkNumericConformability(scalar);
        if (this.getDataType().equals("xsd:double")) {
            this.setValue(this.getDouble() + scalar.getDouble());
        } else if (this.getDataType().equals("xsd:integer")) {
            this.setValue(this.getInt() + scalar.getInt());
        }
    }

    public DictRefAttribute getDictRefFromElementOrParent() {
        return DictRefAttribute.getDictRefFromElementOrParent(this);
    }

    @Override
    public void setUnits(String prefix, String id, String namespaceURI) {
        NamespaceRefAttribute.setUnits(this, prefix, id, namespaceURI);
    }

    @Override
    public void setUnitType(String value) throws RuntimeException {
        NamespaceRefAttribute att = null;
        if (this._att_unittype == null) {
            this._att_unittype = new NamespaceRefAttribute("unitType", value);
            if (this._att_unittype == null) {
                throw new RuntimeException("BUG: cannot process attributeGroupName : unitType probably incompatible attributeGroupName and attributeName");
            }
        }
        att = new NamespaceRefAttribute((Attribute)this._att_unittype);
        super.addRemove(att, value);
    }

    public Double getNumberAsDouble() {
        Double d = this.getDouble();
        if (d == null || Double.isNaN(d)) {
            try {
                Integer i = this.getInt();
                d = (double)i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }
}

