/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import org.apache.log4j.Logger;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Real2;
import org.xmlcml.euclid.Vector2;

public class Line2
implements EuclidConstants {
    private static Logger LOG = Logger.getLogger(Line2.class);
    public static final Line2 XAXIS = new Line2(new Real2(0.0, 0.0), new Real2(1.0, 0.0));
    public static final Line2 YAXIS = new Line2(new Real2(0.0, 0.0), new Real2(0.0, 1.0));
    private Real2 from;
    private Real2 to;
    private Vector2 vector;
    private Vector2 unitVector = null;
    private double slope = Double.NaN;
    private double c = Double.NaN;
    private double xint = Double.NaN;

    public Line2(Real2 from, Real2 to) {
        this.from = new Real2(from);
        this.to = new Real2(to);
        this.createVector();
        this.init();
    }

    private void createVector() {
        this.vector = new Vector2(this.to.subtract(this.from));
        if (this.vector.getLength() < 1.0E-14) {
            LOG.trace("line has coincident points: " + this.from + " ... " + this.to);
        }
    }

    private void init() {
        this.slope = Double.NaN;
        this.c = Double.NaN;
        this.xint = Double.NaN;
    }

    public Line2(Real2 from, Vector2 v) {
        if (v.getLength() < 1.0E-14) {
            throw new EuclidRuntimeException("Cannot form line from coincident points");
        }
        this.from = new Real2(from);
        this.vector = new Vector2(v);
        this.to = from.plus(v);
    }

    public double getSlope() {
        if (Double.isNaN(this.slope)) {
            try {
                this.slope = this.vector.getY() / this.vector.getX();
            }
            catch (ArithmeticException ae) {
                this.slope = this.vector.getY() > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            }
        }
        return this.slope;
    }

    public double getYIntercept() {
        if (Double.isNaN(this.c)) {
            this.getSlope();
            if (!Double.isNaN(this.slope) && this.slope < Double.POSITIVE_INFINITY && this.slope > Double.NEGATIVE_INFINITY) {
                this.c = this.from.getY() - this.from.getX() * this.slope;
            }
        }
        return this.c;
    }

    public double getXIntercept() {
        if (Double.isNaN(this.xint)) {
            this.getYIntercept();
            if (Double.isNaN(this.slope) || Double.compare(this.slope, Double.NEGATIVE_INFINITY) == 0 || Double.compare(this.slope, Double.POSITIVE_INFINITY) == 0) {
                this.xint = this.from.getX();
            } else if (Math.abs(this.slope) > 1.0E-14) {
                this.xint = -this.c / this.slope;
            }
        }
        return this.xint;
    }

    public Real2 getIntersection(Line2 line1) {
        Real2 inter = null;
        if (this.from.getDistance(line1.from) < 1.0E-14) {
            inter = this.from;
        } else {
            double perpv = this.vector.getPerpProduct(line1.vector);
            Vector2 w = new Vector2(this.from.subtract(line1.from));
            double perpw = line1.vector.getPerpProduct(w);
            double lambda = perpw / perpv;
            Real2 vv = this.vector.multiplyBy(lambda);
            inter = this.from.plus(vv);
        }
        return inter;
    }

    public boolean contains(Real2 point, double eps, boolean allowExtension) {
        double dist;
        boolean contains = false;
        if (point != null && (dist = Math.abs(this.getDistanceFromPoint(point))) < eps) {
            double length = this.getLength() + eps;
            contains = allowExtension || point.getDistance(this.from) < length && point.getDistance(this.to) < length;
        }
        return contains;
    }

    public void flipCoordinates() {
        Real2 temp = this.from;
        this.from = this.to;
        this.to = temp;
    }

    public Vector2 getUnitVector() {
        if (this.unitVector == null) {
            this.unitVector = new Vector2(this.vector.getUnitVector());
        }
        return this.unitVector;
    }

    public double getDistanceFromPoint(Real2 point) {
        this.getUnitVector();
        LOG.trace(this.unitVector);
        Vector2 w = new Vector2(point.subtract(this.from));
        LOG.trace(w);
        return this.unitVector.getPerpProduct(w);
    }

    public double getSignedDistanceFromPoint(Real2 point) {
        this.getUnitVector();
        LOG.trace(this.unitVector);
        Vector2 w = new Vector2(point.subtract(this.from));
        LOG.trace(w);
        return this.unitVector.getPerpProduct(w);
    }

    public double getUnsignedDistanceFromPoint(Real2 point) {
        Real2 pb = this.getNearestPointOnLine(point);
        return pb.getDistance(point);
    }

    public Real2 getNearestPointNew(Real2 point) {
        Vector2 v = new Vector2(this.getXY(1).subtract(this.getXY(0)));
        Vector2 w = new Vector2(point.subtract(this.getXY(0)));
        double c1 = w.dotProduct(v);
        double c2 = v.dotProduct(v);
        double b = c1 / c2;
        Real2 pb = this.getXY(0).plus(v.multiplyBy(b));
        return pb;
    }

    public Real2 getNearestPointOnLine(Real2 point) {
        this.getUnitVector();
        Vector2 lp = new Vector2(point.subtract(this.from));
        double lambda = this.unitVector.dotProduct(lp);
        Real2 vv = this.unitVector.multiplyBy(lambda);
        return this.from.plus(vv);
    }

    public Boolean isParallelTo(Line2 line, Angle eps) {
        Boolean parallel = null;
        if (line != null && eps != null) {
            Angle angle = this.getAngleMadeWith(line);
            angle.normalizeToPlusMinusPI();
            parallel = Math.abs(angle.getRadian()) < Math.abs(eps.getRadian());
        }
        return parallel;
    }

    public boolean isAntiParallelTo(Line2 line, Angle eps) {
        Boolean antiParallel = null;
        if (line != null && eps != null) {
            Angle angle = this.getAngleMadeWith(line);
            angle.normalizeTo2Pi();
            antiParallel = Math.abs(Math.abs(angle.getRadian()) - Math.PI) < Math.abs(eps.getRadian());
        }
        return antiParallel;
    }

    public Boolean isParallelOrAntiParallelTo(Line2 line, Angle eps) {
        Boolean para = null;
        if (line != null && eps != null) {
            para = this.isParallelTo(line, eps) != false || this.isAntiParallelTo(line, eps);
        }
        return para;
    }

    public Double calculateUnsignedDistanceBetweenLines(Line2 line, Angle eps) {
        Double d = null;
        if (this.isParallelOrAntiParallelTo(line, eps).booleanValue()) {
            Real2 p = line.getNearestPointOnLine(this.getXY(0));
            d = this.getXY(0).getDistance(p);
        }
        return d;
    }

    public Angle getAngleMadeWith(Line2 line) {
        Angle angle = null;
        if (line != null) {
            angle = this.getVector().getAngleMadeWith(line.getVector());
        }
        return angle;
    }

    public Boolean isPerpendicularTo(Line2 line, Angle angleEps) {
        if (line == null || angleEps == null) {
            return null;
        }
        Angle angle = this.getAngleMadeWith(line);
        return Math.abs(Math.abs(angle.getRadian()) - 1.5707963267948966) < angleEps.getRadian();
    }

    public double getLambda(Real2 p) {
        Real2 near = this.getNearestPointOnLine(p);
        Real2 delta = near.subtract(this.from);
        double lambda = Math.abs(this.vector.getX()) > Math.abs(this.vector.getY()) ? delta.getX() / this.vector.getX() : delta.getY() / this.vector.getY();
        return lambda;
    }

    public Real2 getMidPoint() {
        Real2 mm = this.from.plus(this.to);
        return mm.multiplyBy(0.5);
    }

    public double getLength() {
        return this.vector.getLength();
    }

    public Real2 getFrom() {
        return this.from;
    }

    public Real2 getTo() {
        return this.to;
    }

    public Real2 getXY(int i) {
        Real2 xy = null;
        if (i == 0) {
            xy = this.from;
        } else if (i == 1) {
            xy = this.to;
        } else {
            throw new EuclidRuntimeException("Bad point in Line2 " + i);
        }
        return xy;
    }

    public void setXY(Real2 xy, int i) {
        if (i == 0) {
            this.from = new Real2(xy);
        } else if (i == 1) {
            this.to = new Real2(xy);
        } else {
            throw new EuclidRuntimeException("Bad point in Line2 " + i);
        }
        this.createVector();
    }

    public Vector2 getVector() {
        return this.vector;
    }

    public Real2 createPointOnLine(Double dist) {
        double length = this.getLength();
        double multiplier = dist / length;
        Real2 newVector = this.vector.multiplyBy(multiplier);
        Real2 newPoint = new Real2(this.from);
        newPoint.plusEquals(newVector);
        return newPoint;
    }

    public Real2 createPointOnLine(Double dist, int index) {
        double length = this.getLength();
        double multiplier = dist / length;
        Real2 newVector = this.vector.multiplyBy(multiplier);
        if (index == 1) {
            newVector.negative();
        }
        Real2 newPoint = this.getXY(index).plus(newVector);
        return newPoint;
    }

    public int getSerial(Real2 point, double eps) {
        if (this.from.getDistance(point) < eps) {
            return 0;
        }
        if (this.to != null && this.to.getDistance(point) < eps) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "line: from(" + this.from + ") to(" + this.to + ") v(" + this.vector + ")";
    }

    public boolean isHorizontal(Angle eps) {
        return this.isParallelOrAntiParallelTo(XAXIS, eps);
    }

    public boolean isVertical(Angle eps) {
        return this.isParallelOrAntiParallelTo(YAXIS, eps);
    }
}

