/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.euclid.EuclidConstants;
import org.xmlcml.euclid.IntRange;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.RealArray;
import org.xmlcml.euclid.Util;

public class RealRange
implements EuclidConstants,
Comparable<RealRange> {
    private static final Logger LOG = Logger.getLogger(RealRange.class);
    private static final Pattern CURLY_PATTERN1;
    private static final Pattern CURLY_PATTERN2;
    private static final String ANY = "*";
    protected double maxval;
    protected double minval;

    public RealRange() {
        this.minval = Double.POSITIVE_INFINITY;
        this.maxval = Double.NEGATIVE_INFINITY;
    }

    public RealRange(double minv, double maxv) {
        this.setRange(minv, maxv);
    }

    public RealRange(double minv, double maxv, boolean normalize) {
        if (minv > maxv) {
            double temp = minv;
            minv = maxv;
            maxv = temp;
        }
        this.setRange(minv, maxv);
    }

    public void setRange(double minv, double maxv) {
        this.maxval = maxv;
        this.minval = minv;
        if (this.minval > this.maxval) {
            this.minval = Double.POSITIVE_INFINITY;
            this.maxval = Double.NEGATIVE_INFINITY;
        }
    }

    public RealRange(RealRange r) {
        this.minval = r.minval;
        this.maxval = r.maxval;
    }

    public RealRange(IntRange ir) {
        this.minval = ir.minval;
        this.maxval = ir.maxval;
    }

    public static RealRange getRange(String s) {
        RealRange rr = null;
        RealArray ra = new RealArray(s);
        if (ra.size() == 2) {
            rr = new RealRange(ra.get(0), ra.get(1));
        }
        return rr;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o != null && o instanceof RealRange) {
            RealRange ir = (RealRange)o;
            equals = this.minval == ir.minval && this.maxval == ir.maxval;
        }
        return equals;
    }

    public int hashCode() {
        return 17 * (int)Math.round(this.minval) + 31 * (int)Math.round(this.maxval);
    }

    public boolean isValid() {
        return this.minval <= this.maxval;
    }

    @Deprecated
    public boolean isEqualTo(RealRange r) {
        return r != null && Real.isEqual(this.minval, r.minval) && Real.isEqual(this.maxval, r.maxval) && this.minval <= this.maxval;
    }

    public boolean isEqualTo(RealRange r, double eps) {
        return r != null && Real.isEqual(this.minval, r.minval, eps) && Real.isEqual(this.maxval, r.maxval, eps) && this.minval <= this.maxval;
    }

    public RealRange plus(RealRange r2) {
        if (r2 == null) {
            return this;
        }
        if (!this.isValid()) {
            if (r2 == null || !r2.isValid()) {
                return new RealRange();
            }
            return new RealRange(r2);
        }
        RealRange temp = new RealRange(Math.min(this.minval, r2.minval), Math.max(this.maxval, r2.maxval));
        return temp;
    }

    public RealRange plusEquals(RealRange r2) {
        if (r2 != null) {
            this.minval = Math.min(this.minval, r2.minval);
            this.maxval = Math.max(this.maxval, r2.maxval);
        }
        return this;
    }

    public boolean intersectsWith(RealRange r2) {
        RealRange r = this.intersectionWith(r2);
        return r != null && r.isValid();
    }

    public RealRange intersectionWith(RealRange r2) {
        double maxv;
        double minv;
        RealRange inter = null;
        if (this.isValid() && r2 != null && r2.isValid() && (minv = Math.max(this.minval, r2.minval)) <= (maxv = Math.min(this.maxval, r2.maxval))) {
            inter = new RealRange(minv, maxv);
        }
        return inter;
    }

    public double getMin() {
        return this.minval;
    }

    public double getMax() {
        return this.maxval;
    }

    public double getMidPoint() {
        return (this.minval + this.maxval) * 0.5;
    }

    public double getRange() {
        if (!this.isValid()) {
            return Double.NaN;
        }
        return this.maxval - this.minval;
    }

    public boolean includes(RealRange r2) {
        return r2 != null && r2.isValid() && this.includes(r2.getMin()) && this.includes(r2.getMax());
    }

    public boolean includes(double f) {
        return f >= this.minval && f <= this.maxval;
    }

    public boolean contains(double f) {
        return this.includes(f);
    }

    public void add(double x) {
        this.maxval = Math.max(this.maxval, x);
        this.minval = Math.min(this.minval, x);
    }

    public double getRandomVariate() {
        double range = this.maxval - this.minval;
        return this.minval + Math.random() * range;
    }

    public Double getScaleTo(RealRange range) {
        Double scale = null;
        if (range != null) {
            try {
                scale = range.getRange() / this.getRange();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return scale;
    }

    public void normalize() {
        if (this.minval > this.maxval) {
            double temp = this.minval;
            this.minval = this.maxval;
            this.maxval = temp;
        }
    }

    public double distanceOutside(double d) {
        double dd = Double.NaN;
        if (!Double.isNaN(d)) {
            dd = 0.0;
            if (d < this.minval) {
                dd = d - this.minval;
            } else if (d > this.maxval) {
                dd = this.maxval - d;
            }
        }
        return dd;
    }

    public String toString() {
        return this.minval > this.maxval ? "NULL" : "(" + this.minval + "," + this.maxval + ")";
    }

    public RealRange format(Integer decimalPlaces) {
        this.maxval = Util.format(this.maxval, decimalPlaces);
        this.minval = Util.format(this.minval, decimalPlaces);
        return this;
    }

    @Override
    public int compareTo(RealRange realRange) {
        if (realRange == null) {
            return -1;
        }
        if (this.minval < realRange.minval) {
            return -1;
        }
        if (this.minval > realRange.minval) {
            return 1;
        }
        if (this.maxval < realRange.maxval) {
            return -1;
        }
        if (this.maxval > realRange.maxval) {
            return 1;
        }
        return 0;
    }

    public void extendBothEndsBy(double tolerance) {
        this.minval -= tolerance;
        this.maxval += tolerance;
        if (tolerance < 0.0 && this.minval > this.maxval) {
            double middle;
            this.minval = middle = (this.minval + this.maxval) / 2.0;
            this.maxval = middle;
        }
    }

    public void extendLowerEndBy(double tolerance) {
        this.minval -= tolerance;
        if (tolerance < 0.0 && this.minval > this.maxval) {
            this.minval = this.maxval;
        }
    }

    public void extendUpperEndBy(double tolerance) {
        this.maxval += tolerance;
        if (tolerance < 0.0 && this.minval > this.maxval) {
            this.maxval = this.minval;
        }
    }

    public RealRange getRangeExtendedBy(double minExtend, double maxExtend) {
        return new RealRange(this.minval - minExtend, this.maxval + maxExtend);
    }

    public static RealRange parseCurlyBracketString(String token) {
        RealRange intRange = null;
        if (token != null) {
            Double min = null;
            Double max = null;
            token = token.replaceAll("\\s+", "");
            Matcher matcher = CURLY_PATTERN2.matcher(token);
            try {
                if (matcher.matches()) {
                    String minS = matcher.group(1);
                    String maxS = matcher.group(2);
                    min = ANY.equals(minS) ? -1.7976931348623157E308 : new Double(minS);
                    max = ANY.equals(maxS) ? Double.MAX_VALUE : new Double(maxS);
                } else {
                    matcher = CURLY_PATTERN1.matcher(token);
                    if (matcher.matches()) {
                        String minS = matcher.group(1);
                        max = min = Double.valueOf(ANY.equals(minS) ? -1.7976931348623157E308 : new Double(minS));
                    }
                }
                intRange = new RealRange(min, max);
            }
            catch (Exception e) {
                LOG.error("Cannot parse range: " + token);
            }
        }
        return intRange;
    }

    public static List<RealRange> createRealRangeList(List<String> tokens) {
        ArrayList<RealRange> realRangeList = new ArrayList<RealRange>();
        for (String token : tokens) {
            RealRange realRange = RealRange.parseCurlyBracketString(token);
            if (realRange == null) {
                throw new RuntimeException("Cannot parse (" + token + ") as RealRange in : " + tokens);
            }
            realRangeList.add(realRange);
        }
        return realRangeList;
    }

    public static boolean isEqual(RealRange range0, RealRange range1, double eps) {
        return range0 == null && range1 == null ? false : Real.isEqual(range0.getMin(), range1.getMin(), eps) && Real.isEqual(range0.getMax(), range1.getMax(), eps);
    }

    public boolean isLessThan(RealRange range) {
        return range != null && this.getRange() < range.getRange();
    }

    static {
        LOG.setLevel(Level.DEBUG);
        CURLY_PATTERN1 = Pattern.compile("\\{([^,]+)\\}");
        CURLY_PATTERN2 = Pattern.compile("\\{([^,]+),([^,]+)\\}");
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

