/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.stml.attribute;

import nu.xom.Attribute;
import org.xmlcml.euclid.Util;
import org.xmlcml.stml.STMLAttribute;

public class StringArraySTAttribute
extends STMLAttribute {
    public static final String JAVA_TYPE = "String[]";
    public static final String JAVA_GET_METHOD = "getStringArray";
    public static final String JAVA_SHORT_CLASS = "StringArraySTAttribute";
    protected String[] ss = null;

    public StringArraySTAttribute(String name) {
        super(name);
    }

    public StringArraySTAttribute(Attribute att) {
        this(att.getLocalName());
        this.setSTMLValue(att.getValue());
    }

    @Override
    public void setValue(String s) {
        super.setValue(s);
        this.setSTMLValue(s);
    }

    public StringArraySTAttribute(StringArraySTAttribute att) {
        super(att);
        if (att.ss != null) {
            this.ss = new String[att.ss.length];
            for (int i = 0; i < this.ss.length; ++i) {
                this.ss[i] = att.ss[i];
            }
        }
    }

    @Override
    public Attribute copy() {
        return new StringArraySTAttribute(this);
    }

    public StringArraySTAttribute(Attribute att, String value) {
        super(att);
        this.setSTMLValue(value);
    }

    @Override
    public void setSTMLValue(String s) {
        this.setSTMLValue(this.arrayFromString(s));
    }

    protected String[] arrayFromString(String s) {
        String[] split = s.trim().split("\\s+");
        return split;
    }

    protected String stringFromArray(String[] array) {
        return Util.concatenate(array, " ");
    }

    public void setSTMLValue(String[] ss) {
        this.checkValue(ss);
        this.ss = ss;
        super.setValue(this.stringFromArray(ss));
    }

    public void checkValue(String[] ss) {
        if (this.cmlType != null) {
            this.cmlType.checkValue(ss);
        }
    }

    @Override
    public Object getSTMLValue() {
        return this.ss;
    }

    public String[] getStringArray() {
        return this.ss;
    }

    @Override
    public String getJavaType() {
        return JAVA_TYPE;
    }

    @Override
    public String getJavaGetMethod() {
        return JAVA_GET_METHOD;
    }

    @Override
    public String getJavaShortClassName() {
        return JAVA_SHORT_CLASS;
    }
}

