/*
 * Decompiled with CFR 0.152.
 */
package signature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import signature.AbstractGraphBuilder;
import signature.AbstractVertexSignature;
import signature.ColoredTree;
import signature.SymmetryClass;
import signature.VirtualGraphBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphSignature {
    private final String separator;
    private int height;
    private String graphSignature;

    public AbstractGraphSignature() {
        this(" + ", -1);
    }

    public AbstractGraphSignature(String separator) {
        this(separator, -1);
    }

    public AbstractGraphSignature(int height) {
        this(" + ", height);
    }

    public AbstractGraphSignature(String separator, int height) {
        this.separator = separator;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    protected abstract int getVertexCount();

    public abstract String signatureStringForVertex(int var1);

    public abstract String signatureStringForVertex(int var1, int var2);

    public abstract AbstractVertexSignature signatureForVertex(int var1);

    public String toCanonicalString() {
        String canonicalString = null;
        for (int i = 0; i < this.getVertexCount(); ++i) {
            String signatureString = this.signatureStringForVertex(i);
            if (canonicalString != null && canonicalString.compareTo(signatureString) <= 0) continue;
            canonicalString = signatureString;
        }
        if (canonicalString == null) {
            return "";
        }
        return canonicalString;
    }

    public List<SymmetryClass> getSymmetryClasses() {
        return this.getSymmetryClasses(-1);
    }

    public List<SymmetryClass> getSymmetryClasses(int height) {
        ArrayList<SymmetryClass> symmetryClasses = new ArrayList<SymmetryClass>();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            String signatureString = this.signatureStringForVertex(i, height);
            SymmetryClass foundClass = null;
            for (SymmetryClass symmetryClass : symmetryClasses) {
                if (!symmetryClass.hasSignature(signatureString)) continue;
                foundClass = symmetryClass;
                break;
            }
            if (foundClass == null) {
                foundClass = new SymmetryClass(signatureString);
                symmetryClasses.add(foundClass);
            }
            foundClass.addIndex(i);
        }
        return symmetryClasses;
    }

    public String toFullString() {
        HashMap<String, Integer> sigmap = new HashMap<String, Integer>();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            String signatureString = this.signatureStringForVertex(i);
            if (sigmap.containsKey(signatureString)) {
                int count = (Integer)sigmap.get(signatureString);
                sigmap.put(signatureString, count + 1);
                continue;
            }
            sigmap.put(signatureString, 1);
        }
        ArrayList keyList = new ArrayList();
        keyList.addAll(sigmap.keySet());
        Collections.sort(keyList);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < keyList.size() - 1; ++i) {
            String signature = (String)keyList.get(i);
            int count = (Integer)sigmap.get(signature);
            buffer.append(count).append(signature).append(this.separator);
        }
        String finalSignature = (String)keyList.get(keyList.size() - 1);
        int count = (Integer)sigmap.get(finalSignature);
        buffer.append(count).append(finalSignature);
        return buffer.toString();
    }

    public String getGraphSignature() {
        this.graphSignature = this.getMaximalSignature();
        return this.graphSignature;
    }

    public List<String> getSortedSignatures() {
        List<String> vertexSignatures = this.getVertexSignatureStrings();
        Collections.sort(vertexSignatures);
        return vertexSignatures;
    }

    public String getMinimalSignature() {
        List<String> sortedSignatures = this.getSortedSignatures();
        return sortedSignatures.get(sortedSignatures.size() - 1);
    }

    public String getMaximalSignature() {
        List<String> sortedSignatures = this.getSortedSignatures();
        return sortedSignatures.get(0);
    }

    public List<String> getVertexSignatureStrings() {
        ArrayList<String> vertexSignatures = new ArrayList<String>();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            vertexSignatures.add(this.signatureStringForVertex(i));
        }
        return vertexSignatures;
    }

    public List<AbstractVertexSignature> getVertexSignatures() {
        ArrayList<AbstractVertexSignature> signatures = new ArrayList<AbstractVertexSignature>();
        for (int i = 0; i < this.getVertexCount(); ++i) {
            signatures.add(this.signatureForVertex(i));
        }
        return signatures;
    }

    public boolean isCanonicallyLabelled() {
        int[] labels = this.getCanonicalLabels();
        int previousLabel = -1;
        for (int i = 0; i < labels.length; ++i) {
            if (previousLabel != -1 && labels[i] <= previousLabel) {
                return false;
            }
            previousLabel = labels[i];
        }
        return true;
    }

    public void reconstructCanonicalGraph(AbstractVertexSignature signature, AbstractGraphBuilder builder) {
        String canonicalString = this.toCanonicalString();
        ColoredTree tree = AbstractVertexSignature.parse(canonicalString);
        builder.makeFromColoredTree(tree);
    }

    public int[] getCanonicalLabels() {
        int n = this.getVertexCount();
        AbstractVertexSignature canonicalSignature = null;
        String canonicalSignatureString = null;
        for (int i = 0; i < n; ++i) {
            AbstractVertexSignature signatureForVertexI = this.signatureForVertex(i);
            String signatureString = signatureForVertexI.toCanonicalString();
            if (canonicalSignature != null && signatureString.compareTo(canonicalSignatureString) >= 0) continue;
            canonicalSignature = signatureForVertexI;
            canonicalSignatureString = signatureString;
        }
        return canonicalSignature.getCanonicalLabelling(n);
    }

    public String reconstructCanonicalEdgeString() {
        String canonicalString = this.toCanonicalString();
        VirtualGraphBuilder builder = new VirtualGraphBuilder();
        builder.makeFromColoredTree(AbstractVertexSignature.parse(canonicalString));
        return builder.toEdgeString();
    }
}

