"""
This module has a similar scope to os.path, containing utility
functions for dealing with paths in Blender.

"""

import typing
import collections.abc
import bpy.types

GenericType1 = typing.TypeVar("GenericType1")
GenericType2 = typing.TypeVar("GenericType2")

def abspath(
    path, start: bytes | str | None = None, library: bpy.types.Library | None = None
):
    """Returns the absolute path relative to the current blend file
    using the "//" prefix.

        :param start: Relative to this path,
    when not set the current filename is used.
        :type start: bytes | str | None
        :param library: The library this path is from. This is only included for
    convenience, when the library is not None its path replaces start.
        :type library: bpy.types.Library | None
    """

    ...

def abspath(
    path, start: bytes | str | None = None, library: bpy.types.Library | None = None
):
    """Returns the absolute path relative to the current blend file
    using the "//" prefix.

        :param start: Relative to this path,
    when not set the current filename is used.
        :type start: bytes | str | None
        :param library: The library this path is from. This is only included for
    convenience, when the library is not None its path replaces start.
        :type library: bpy.types.Library | None
    """

    ...

def basename(path):
    """Equivalent to os.path.basename, but skips a "//" prefix.Use for Windows compatibility."""

    ...

def basename(path):
    """Equivalent to os.path.basename, but skips a "//" prefix.Use for Windows compatibility."""

    ...

def clean_name(name, replace="_"):
    """Returns a name with characters replaced that
    may cause problems under various circumstances,
    such as writing to a file.
    All characters besides A-Z/a-z, 0-9 are replaced with "_"
    or the replace argument if defined.

    """

    ...

def clean_name(name, replace="_"):
    """Returns a name with characters replaced that
    may cause problems under various circumstances,
    such as writing to a file.
    All characters besides A-Z/a-z, 0-9 are replaced with "_"
    or the replace argument if defined.

    """

    ...

def display_name(name, *, has_ext=True, title_case=True):
    """Creates a display string from name to be used menus and the user interface.
    Intended for use with filenames and module names.

        :param has_ext: Remove file extension from name
        :param title_case: Convert lowercase names to title case
    """

    ...

def display_name(name, has_ext=True, title_case=True):
    """Creates a display string from name to be used menus and the user interface.
    Intended for use with filenames and module names.

        :param has_ext: Remove file extension from name
        :param title_case: Convert lowercase names to title case
    """

    ...

def display_name_from_filepath(name):
    """Returns the path stripped of directory and extension,
    ensured to be utf8 compatible.

    """

    ...

def display_name_from_filepath(name):
    """Returns the path stripped of directory and extension,
    ensured to be utf8 compatible.

    """

    ...

def display_name_to_filepath(name):
    """Performs the reverse of display_name using literal versions of characters
    which aren't supported in a filepath.

    """

    ...

def display_name_to_filepath(name):
    """Performs the reverse of display_name using literal versions of characters
    which aren't supported in a filepath.

    """

    ...

def ensure_ext(filepath, ext: str | None, case_sensitive: bool | None = False):
    """Return the path with the extension added if it is not already set.

        :param ext: The extension to check for, can be a compound extension. Should
    start with a dot, such as '.blend' or '.tar.gz'.
        :type ext: str | None
        :param case_sensitive: Check for matching case when comparing extensions.
        :type case_sensitive: bool | None
    """

    ...

def ensure_ext(filepath, ext: str | None, case_sensitive: bool | None = False):
    """Return the path with the extension added if it is not already set.

        :param ext: The extension to check for, can be a compound extension. Should
    start with a dot, such as '.blend' or '.tar.gz'.
        :type ext: str | None
        :param case_sensitive: Check for matching case when comparing extensions.
        :type case_sensitive: bool | None
    """

    ...

def is_subdir(path: bytes | str | None, directory):
    """Returns true if path in a subdirectory of directory.
    Both paths must be absolute.

        :param path: An absolute path.
        :type path: bytes | str | None
    """

    ...

def is_subdir(path: bytes | str | None, directory):
    """Returns true if path in a subdirectory of directory.
    Both paths must be absolute.

        :param path: An absolute path.
        :type path: bytes | str | None
    """

    ...

def module_names(path: str | None, recursive: bool | None = False) -> list:
    """Return a list of modules which can be imported from path.

    :param path: a directory to scan.
    :type path: str | None
    :param recursive: Also return submodule names for packages.
    :type recursive: bool | None
    :return: a list of string pairs (module_name, module_file).
    :rtype: list
    """

    ...

def module_names(path: str | None, recursive: bool | None = False) -> list:
    """Return a list of modules which can be imported from path.

    :param path: a directory to scan.
    :type path: str | None
    :param recursive: Also return submodule names for packages.
    :type recursive: bool | None
    :return: a list of string pairs (module_name, module_file).
    :rtype: list
    """

    ...

def native_pathsep(path):
    """Replace the path separator with the systems native os.sep."""

    ...

def native_pathsep(path):
    """Replace the path separator with the systems native os.sep."""

    ...

def reduce_dirs(dirs: collections.abc.Sequence | None) -> list:
    """Given a sequence of directories, remove duplicates and
    any directories nested in one of the other paths.
    (Useful for recursive path searching).

        :param dirs: Sequence of directory paths.
        :type dirs: collections.abc.Sequence | None
        :return: A unique list of paths.
        :rtype: list
    """

    ...

def reduce_dirs(dirs: collections.abc.Sequence | None) -> list:
    """Given a sequence of directories, remove duplicates and
    any directories nested in one of the other paths.
    (Useful for recursive path searching).

        :param dirs: Sequence of directory paths.
        :type dirs: collections.abc.Sequence | None
        :return: A unique list of paths.
        :rtype: list
    """

    ...

def relpath(path: bytes | str | None, start: bytes | str | None = None):
    """Returns the path relative to the current blend file using the "//" prefix.

        :param path: An absolute path.
        :type path: bytes | str | None
        :param start: Relative to this path,
    when not set the current filename is used.
        :type start: bytes | str | None
    """

    ...

def relpath(path: bytes | str | None, start: bytes | str | None = None):
    """Returns the path relative to the current blend file using the "//" prefix.

        :param path: An absolute path.
        :type path: bytes | str | None
        :param start: Relative to this path,
    when not set the current filename is used.
        :type start: bytes | str | None
    """

    ...

def resolve_ncase(path):
    """Resolve a case insensitive path on a case sensitive system,
    returning a string with the path if found else return the original path.

    """

    ...

def resolve_ncase(path):
    """Resolve a case insensitive path on a case sensitive system,
    returning a string with the path if found else return the original path.

    """

    ...
