# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClientCredentialsArgs', 'ClientCredentials']

@pulumi.input_type
class ClientCredentialsArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[builtins.str],
                 authentication_method: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_jwt: Optional[pulumi.Input['ClientCredentialsPrivateKeyJwtArgs']] = None,
                 self_signed_tls_client_auth: Optional[pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs']] = None,
                 signed_request_object: Optional[pulumi.Input['ClientCredentialsSignedRequestObjectArgs']] = None,
                 tls_client_auth: Optional[pulumi.Input['ClientCredentialsTlsClientAuthArgs']] = None):
        """
        The set of arguments for constructing a ClientCredentials resource.
        :param pulumi.Input[builtins.str] client_id: The ID of the client for which to configure the authentication method.
        :param pulumi.Input[builtins.str] authentication_method: Configure the method to use when making requests to any endpoint that requires this client to authenticate. Options include `none` (public client without a client secret), `client_secret_post` (confidential client using HTTP POST parameters), `client_secret_basic` (confidential client using HTTP Basic), `private_key_jwt` (confidential client using a Private Key JWT), `tls_client_auth` (confidential client using CA-based mTLS authentication), `self_signed_tls_client_auth` (confidential client using mTLS authentication utilizing a self-signed certificate).
        :param pulumi.Input['ClientCredentialsPrivateKeyJwtArgs'] private_key_jwt: Defines `private_key_jwt` client authentication method.
        :param pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs'] self_signed_tls_client_auth: Defines `tls_client_auth` client authentication method.
        :param pulumi.Input['ClientCredentialsSignedRequestObjectArgs'] signed_request_object: Configuration for JWT-secured Authorization Requests(JAR).
        :param pulumi.Input['ClientCredentialsTlsClientAuthArgs'] tls_client_auth: Defines `tls_client_auth` client authentication method.
        """
        pulumi.set(__self__, "client_id", client_id)
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if private_key_jwt is not None:
            pulumi.set(__self__, "private_key_jwt", private_key_jwt)
        if self_signed_tls_client_auth is not None:
            pulumi.set(__self__, "self_signed_tls_client_auth", self_signed_tls_client_auth)
        if signed_request_object is not None:
            pulumi.set(__self__, "signed_request_object", signed_request_object)
        if tls_client_auth is not None:
            pulumi.set(__self__, "tls_client_auth", tls_client_auth)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the client for which to configure the authentication method.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure the method to use when making requests to any endpoint that requires this client to authenticate. Options include `none` (public client without a client secret), `client_secret_post` (confidential client using HTTP POST parameters), `client_secret_basic` (confidential client using HTTP Basic), `private_key_jwt` (confidential client using a Private Key JWT), `tls_client_auth` (confidential client using CA-based mTLS authentication), `self_signed_tls_client_auth` (confidential client using mTLS authentication utilizing a self-signed certificate).
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="privateKeyJwt")
    def private_key_jwt(self) -> Optional[pulumi.Input['ClientCredentialsPrivateKeyJwtArgs']]:
        """
        Defines `private_key_jwt` client authentication method.
        """
        return pulumi.get(self, "private_key_jwt")

    @private_key_jwt.setter
    def private_key_jwt(self, value: Optional[pulumi.Input['ClientCredentialsPrivateKeyJwtArgs']]):
        pulumi.set(self, "private_key_jwt", value)

    @property
    @pulumi.getter(name="selfSignedTlsClientAuth")
    def self_signed_tls_client_auth(self) -> Optional[pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs']]:
        """
        Defines `tls_client_auth` client authentication method.
        """
        return pulumi.get(self, "self_signed_tls_client_auth")

    @self_signed_tls_client_auth.setter
    def self_signed_tls_client_auth(self, value: Optional[pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs']]):
        pulumi.set(self, "self_signed_tls_client_auth", value)

    @property
    @pulumi.getter(name="signedRequestObject")
    def signed_request_object(self) -> Optional[pulumi.Input['ClientCredentialsSignedRequestObjectArgs']]:
        """
        Configuration for JWT-secured Authorization Requests(JAR).
        """
        return pulumi.get(self, "signed_request_object")

    @signed_request_object.setter
    def signed_request_object(self, value: Optional[pulumi.Input['ClientCredentialsSignedRequestObjectArgs']]):
        pulumi.set(self, "signed_request_object", value)

    @property
    @pulumi.getter(name="tlsClientAuth")
    def tls_client_auth(self) -> Optional[pulumi.Input['ClientCredentialsTlsClientAuthArgs']]:
        """
        Defines `tls_client_auth` client authentication method.
        """
        return pulumi.get(self, "tls_client_auth")

    @tls_client_auth.setter
    def tls_client_auth(self, value: Optional[pulumi.Input['ClientCredentialsTlsClientAuthArgs']]):
        pulumi.set(self, "tls_client_auth", value)


@pulumi.input_type
class _ClientCredentialsState:
    def __init__(__self__, *,
                 authentication_method: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_jwt: Optional[pulumi.Input['ClientCredentialsPrivateKeyJwtArgs']] = None,
                 self_signed_tls_client_auth: Optional[pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs']] = None,
                 signed_request_object: Optional[pulumi.Input['ClientCredentialsSignedRequestObjectArgs']] = None,
                 tls_client_auth: Optional[pulumi.Input['ClientCredentialsTlsClientAuthArgs']] = None):
        """
        Input properties used for looking up and filtering ClientCredentials resources.
        :param pulumi.Input[builtins.str] authentication_method: Configure the method to use when making requests to any endpoint that requires this client to authenticate. Options include `none` (public client without a client secret), `client_secret_post` (confidential client using HTTP POST parameters), `client_secret_basic` (confidential client using HTTP Basic), `private_key_jwt` (confidential client using a Private Key JWT), `tls_client_auth` (confidential client using CA-based mTLS authentication), `self_signed_tls_client_auth` (confidential client using mTLS authentication utilizing a self-signed certificate).
        :param pulumi.Input[builtins.str] client_id: The ID of the client for which to configure the authentication method.
        :param pulumi.Input['ClientCredentialsPrivateKeyJwtArgs'] private_key_jwt: Defines `private_key_jwt` client authentication method.
        :param pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs'] self_signed_tls_client_auth: Defines `tls_client_auth` client authentication method.
        :param pulumi.Input['ClientCredentialsSignedRequestObjectArgs'] signed_request_object: Configuration for JWT-secured Authorization Requests(JAR).
        :param pulumi.Input['ClientCredentialsTlsClientAuthArgs'] tls_client_auth: Defines `tls_client_auth` client authentication method.
        """
        if authentication_method is not None:
            pulumi.set(__self__, "authentication_method", authentication_method)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if private_key_jwt is not None:
            pulumi.set(__self__, "private_key_jwt", private_key_jwt)
        if self_signed_tls_client_auth is not None:
            pulumi.set(__self__, "self_signed_tls_client_auth", self_signed_tls_client_auth)
        if signed_request_object is not None:
            pulumi.set(__self__, "signed_request_object", signed_request_object)
        if tls_client_auth is not None:
            pulumi.set(__self__, "tls_client_auth", tls_client_auth)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure the method to use when making requests to any endpoint that requires this client to authenticate. Options include `none` (public client without a client secret), `client_secret_post` (confidential client using HTTP POST parameters), `client_secret_basic` (confidential client using HTTP Basic), `private_key_jwt` (confidential client using a Private Key JWT), `tls_client_auth` (confidential client using CA-based mTLS authentication), `self_signed_tls_client_auth` (confidential client using mTLS authentication utilizing a self-signed certificate).
        """
        return pulumi.get(self, "authentication_method")

    @authentication_method.setter
    def authentication_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_method", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the client for which to configure the authentication method.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter(name="privateKeyJwt")
    def private_key_jwt(self) -> Optional[pulumi.Input['ClientCredentialsPrivateKeyJwtArgs']]:
        """
        Defines `private_key_jwt` client authentication method.
        """
        return pulumi.get(self, "private_key_jwt")

    @private_key_jwt.setter
    def private_key_jwt(self, value: Optional[pulumi.Input['ClientCredentialsPrivateKeyJwtArgs']]):
        pulumi.set(self, "private_key_jwt", value)

    @property
    @pulumi.getter(name="selfSignedTlsClientAuth")
    def self_signed_tls_client_auth(self) -> Optional[pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs']]:
        """
        Defines `tls_client_auth` client authentication method.
        """
        return pulumi.get(self, "self_signed_tls_client_auth")

    @self_signed_tls_client_auth.setter
    def self_signed_tls_client_auth(self, value: Optional[pulumi.Input['ClientCredentialsSelfSignedTlsClientAuthArgs']]):
        pulumi.set(self, "self_signed_tls_client_auth", value)

    @property
    @pulumi.getter(name="signedRequestObject")
    def signed_request_object(self) -> Optional[pulumi.Input['ClientCredentialsSignedRequestObjectArgs']]:
        """
        Configuration for JWT-secured Authorization Requests(JAR).
        """
        return pulumi.get(self, "signed_request_object")

    @signed_request_object.setter
    def signed_request_object(self, value: Optional[pulumi.Input['ClientCredentialsSignedRequestObjectArgs']]):
        pulumi.set(self, "signed_request_object", value)

    @property
    @pulumi.getter(name="tlsClientAuth")
    def tls_client_auth(self) -> Optional[pulumi.Input['ClientCredentialsTlsClientAuthArgs']]:
        """
        Defines `tls_client_auth` client authentication method.
        """
        return pulumi.get(self, "tls_client_auth")

    @tls_client_auth.setter
    def tls_client_auth(self, value: Optional[pulumi.Input['ClientCredentialsTlsClientAuthArgs']]):
        pulumi.set(self, "tls_client_auth", value)


class ClientCredentials(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_method: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_jwt: Optional[pulumi.Input[Union['ClientCredentialsPrivateKeyJwtArgs', 'ClientCredentialsPrivateKeyJwtArgsDict']]] = None,
                 self_signed_tls_client_auth: Optional[pulumi.Input[Union['ClientCredentialsSelfSignedTlsClientAuthArgs', 'ClientCredentialsSelfSignedTlsClientAuthArgsDict']]] = None,
                 signed_request_object: Optional[pulumi.Input[Union['ClientCredentialsSignedRequestObjectArgs', 'ClientCredentialsSignedRequestObjectArgsDict']]] = None,
                 tls_client_auth: Optional[pulumi.Input[Union['ClientCredentialsTlsClientAuthArgs', 'ClientCredentialsTlsClientAuthArgsDict']]] = None,
                 __props__=None):
        """
        With this resource, you can configure the method to use when making requests to any endpoint that requires this client to authenticate.

        > Refer to the client secret rotation guide
        for instructions on how to rotate client secrets with zero downtime.

        ## Import

        This resource can be imported by specifying the client ID.

        Example:

        ```sh
        $ pulumi import auth0:index/clientCredentials:ClientCredentials my_creds "AaiyAPdpYdesoKnqjj8HJqRn4T5titww"
        ```

        ~> Importing this resource when the `authentication_method` is set to `private_key_jwt` will force the resource to be recreated.

        This is to be expected, because the pem file can't be checked for differences.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_method: Configure the method to use when making requests to any endpoint that requires this client to authenticate. Options include `none` (public client without a client secret), `client_secret_post` (confidential client using HTTP POST parameters), `client_secret_basic` (confidential client using HTTP Basic), `private_key_jwt` (confidential client using a Private Key JWT), `tls_client_auth` (confidential client using CA-based mTLS authentication), `self_signed_tls_client_auth` (confidential client using mTLS authentication utilizing a self-signed certificate).
        :param pulumi.Input[builtins.str] client_id: The ID of the client for which to configure the authentication method.
        :param pulumi.Input[Union['ClientCredentialsPrivateKeyJwtArgs', 'ClientCredentialsPrivateKeyJwtArgsDict']] private_key_jwt: Defines `private_key_jwt` client authentication method.
        :param pulumi.Input[Union['ClientCredentialsSelfSignedTlsClientAuthArgs', 'ClientCredentialsSelfSignedTlsClientAuthArgsDict']] self_signed_tls_client_auth: Defines `tls_client_auth` client authentication method.
        :param pulumi.Input[Union['ClientCredentialsSignedRequestObjectArgs', 'ClientCredentialsSignedRequestObjectArgsDict']] signed_request_object: Configuration for JWT-secured Authorization Requests(JAR).
        :param pulumi.Input[Union['ClientCredentialsTlsClientAuthArgs', 'ClientCredentialsTlsClientAuthArgsDict']] tls_client_auth: Defines `tls_client_auth` client authentication method.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientCredentialsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can configure the method to use when making requests to any endpoint that requires this client to authenticate.

        > Refer to the client secret rotation guide
        for instructions on how to rotate client secrets with zero downtime.

        ## Import

        This resource can be imported by specifying the client ID.

        Example:

        ```sh
        $ pulumi import auth0:index/clientCredentials:ClientCredentials my_creds "AaiyAPdpYdesoKnqjj8HJqRn4T5titww"
        ```

        ~> Importing this resource when the `authentication_method` is set to `private_key_jwt` will force the resource to be recreated.

        This is to be expected, because the pem file can't be checked for differences.

        :param str resource_name: The name of the resource.
        :param ClientCredentialsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientCredentialsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_method: Optional[pulumi.Input[builtins.str]] = None,
                 client_id: Optional[pulumi.Input[builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_jwt: Optional[pulumi.Input[Union['ClientCredentialsPrivateKeyJwtArgs', 'ClientCredentialsPrivateKeyJwtArgsDict']]] = None,
                 self_signed_tls_client_auth: Optional[pulumi.Input[Union['ClientCredentialsSelfSignedTlsClientAuthArgs', 'ClientCredentialsSelfSignedTlsClientAuthArgsDict']]] = None,
                 signed_request_object: Optional[pulumi.Input[Union['ClientCredentialsSignedRequestObjectArgs', 'ClientCredentialsSignedRequestObjectArgsDict']]] = None,
                 tls_client_auth: Optional[pulumi.Input[Union['ClientCredentialsTlsClientAuthArgs', 'ClientCredentialsTlsClientAuthArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientCredentialsArgs.__new__(ClientCredentialsArgs)

            __props__.__dict__["authentication_method"] = authentication_method
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            __props__.__dict__["private_key_jwt"] = private_key_jwt
            __props__.__dict__["self_signed_tls_client_auth"] = self_signed_tls_client_auth
            __props__.__dict__["signed_request_object"] = signed_request_object
            __props__.__dict__["tls_client_auth"] = tls_client_auth
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ClientCredentials, __self__).__init__(
            'auth0:index/clientCredentials:ClientCredentials',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_method: Optional[pulumi.Input[builtins.str]] = None,
            client_id: Optional[pulumi.Input[builtins.str]] = None,
            client_secret: Optional[pulumi.Input[builtins.str]] = None,
            private_key_jwt: Optional[pulumi.Input[Union['ClientCredentialsPrivateKeyJwtArgs', 'ClientCredentialsPrivateKeyJwtArgsDict']]] = None,
            self_signed_tls_client_auth: Optional[pulumi.Input[Union['ClientCredentialsSelfSignedTlsClientAuthArgs', 'ClientCredentialsSelfSignedTlsClientAuthArgsDict']]] = None,
            signed_request_object: Optional[pulumi.Input[Union['ClientCredentialsSignedRequestObjectArgs', 'ClientCredentialsSignedRequestObjectArgsDict']]] = None,
            tls_client_auth: Optional[pulumi.Input[Union['ClientCredentialsTlsClientAuthArgs', 'ClientCredentialsTlsClientAuthArgsDict']]] = None) -> 'ClientCredentials':
        """
        Get an existing ClientCredentials resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authentication_method: Configure the method to use when making requests to any endpoint that requires this client to authenticate. Options include `none` (public client without a client secret), `client_secret_post` (confidential client using HTTP POST parameters), `client_secret_basic` (confidential client using HTTP Basic), `private_key_jwt` (confidential client using a Private Key JWT), `tls_client_auth` (confidential client using CA-based mTLS authentication), `self_signed_tls_client_auth` (confidential client using mTLS authentication utilizing a self-signed certificate).
        :param pulumi.Input[builtins.str] client_id: The ID of the client for which to configure the authentication method.
        :param pulumi.Input[Union['ClientCredentialsPrivateKeyJwtArgs', 'ClientCredentialsPrivateKeyJwtArgsDict']] private_key_jwt: Defines `private_key_jwt` client authentication method.
        :param pulumi.Input[Union['ClientCredentialsSelfSignedTlsClientAuthArgs', 'ClientCredentialsSelfSignedTlsClientAuthArgsDict']] self_signed_tls_client_auth: Defines `tls_client_auth` client authentication method.
        :param pulumi.Input[Union['ClientCredentialsSignedRequestObjectArgs', 'ClientCredentialsSignedRequestObjectArgsDict']] signed_request_object: Configuration for JWT-secured Authorization Requests(JAR).
        :param pulumi.Input[Union['ClientCredentialsTlsClientAuthArgs', 'ClientCredentialsTlsClientAuthArgsDict']] tls_client_auth: Defines `tls_client_auth` client authentication method.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientCredentialsState.__new__(_ClientCredentialsState)

        __props__.__dict__["authentication_method"] = authentication_method
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["private_key_jwt"] = private_key_jwt
        __props__.__dict__["self_signed_tls_client_auth"] = self_signed_tls_client_auth
        __props__.__dict__["signed_request_object"] = signed_request_object
        __props__.__dict__["tls_client_auth"] = tls_client_auth
        return ClientCredentials(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authenticationMethod")
    def authentication_method(self) -> pulumi.Output[builtins.str]:
        """
        Configure the method to use when making requests to any endpoint that requires this client to authenticate. Options include `none` (public client without a client secret), `client_secret_post` (confidential client using HTTP POST parameters), `client_secret_basic` (confidential client using HTTP Basic), `private_key_jwt` (confidential client using a Private Key JWT), `tls_client_auth` (confidential client using CA-based mTLS authentication), `self_signed_tls_client_auth` (confidential client using mTLS authentication utilizing a self-signed certificate).
        """
        return pulumi.get(self, "authentication_method")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the client for which to configure the authentication method.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="privateKeyJwt")
    def private_key_jwt(self) -> pulumi.Output[Optional['outputs.ClientCredentialsPrivateKeyJwt']]:
        """
        Defines `private_key_jwt` client authentication method.
        """
        return pulumi.get(self, "private_key_jwt")

    @property
    @pulumi.getter(name="selfSignedTlsClientAuth")
    def self_signed_tls_client_auth(self) -> pulumi.Output[Optional['outputs.ClientCredentialsSelfSignedTlsClientAuth']]:
        """
        Defines `tls_client_auth` client authentication method.
        """
        return pulumi.get(self, "self_signed_tls_client_auth")

    @property
    @pulumi.getter(name="signedRequestObject")
    def signed_request_object(self) -> pulumi.Output[Optional['outputs.ClientCredentialsSignedRequestObject']]:
        """
        Configuration for JWT-secured Authorization Requests(JAR).
        """
        return pulumi.get(self, "signed_request_object")

    @property
    @pulumi.getter(name="tlsClientAuth")
    def tls_client_auth(self) -> pulumi.Output[Optional['outputs.ClientCredentialsTlsClientAuth']]:
        """
        Defines `tls_client_auth` client authentication method.
        """
        return pulumi.get(self, "tls_client_auth")

